<?php

if ( ! function_exists( 'it_zone_customize_register_frontopbar' ) ) :
	/**
	 * Headers
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function it_zone_customize_register_frontopbar( $wp_customize ) {
		// Create a new section top bar settings----------
		$wp_customize->add_section(
			'top_bar_section',
			array(
				'title'    => esc_html__( 'Header Settings', 'it-zone' ),
				'priority' => 10,
				'panel'    => 'general_settings_panel',
			)
		);

		// Add the toggle control to the section
		$wp_customize->add_setting(
			'topbar_toggle',
			array(
				'default'           => false,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'topbar_toggle',
				array(
					'label'       => esc_html__( 'Show/Hide Header', 'it-zone' ),
					'description' => esc_html__( 'Enable to show the header.', 'it-zone' ),
					'section'     => 'top_bar_section',
					'type'        => 'checkbox',
				)
			)
		);
		$wp_customize->add_setting(
			'heading_message',
			array(
				'default'           => __( 'Need help to start your project?', 'it-zone' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'heading_message',
			array(
				'selector'        => '.header-top-left .header-top-left-text',
				'render_callback' => function () {
					return get_theme_mod( 'heading_message', __( 'Need help to start your project?', 'it-zone' ) );
				},
			)
		);

		$wp_customize->add_control(
			'heading_message',
			array(
				'label'           => __( 'Heading', 'it-zone' ),
				'section'         => 'top_bar_section',
				'type'            => 'text',
				'active_callback' => 'it_zone_fronttopbar_active_callback',
			)
		);

		// adding setting for notification link text
		$wp_customize->add_setting(
			'heading_msg_link_text',
			array(
				'default'           => __( 'Request for a call!', 'it-zone' ),
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'heading_msg_link_text',
			array(
				'selector'        => '.header-top-left .underline',
				'render_callback' => function () {
					return get_theme_mod( 'heading_msg_link_text', __( 'Request for a call!', 'it-zone' ) );
				},
			)
		);

		// add control for notification link text
		$wp_customize->add_control(
			'heading_msg_link_text',
			array(
				'label'           => __( 'Heading Message Link Text', 'it-zone' ),
				'section'         => 'top_bar_section',
				'type'            => 'text',
				'active_callback' => 'it_zone_fronttopbar_active_callback',
			)
		);

		// adding setting for notification link
		$wp_customize->add_setting(
			'heading_msg_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);
		// add control for notification link
		$wp_customize->add_control(
			'heading_msg_link',
			array(
				'label'           => __( 'Heading Message Link', 'it-zone' ),
				'section'         => 'top_bar_section',
				'type'            => 'url',
				'active_callback' => 'it_zone_fronttopbar_active_callback',
			)
		);

		$wp_customize->add_setting(
			'header_btn_text',
			array(
				'default'           =>'',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'header_btn_text',
			array(
				'selector'        => '.header-link-list a.btn.btn-secondary',
				'render_callback' => function () {
					return esc_html( get_theme_mod( 'header_btn_text' ) );
				},
			)
		);

		// add control for get started title
		$wp_customize->add_control(
			'header_btn_text',
			array(
				'label'           => __( 'Button Text', 'it-zone' ),
				'section'         => 'top_bar_section',
				'type'            => 'text',
				'active_callback' => 'it_zone_fronttopbar_active_callback',
			)
		);
		// adding setting for get started link
		$wp_customize->add_setting(
			'header_btn_link',
			array(
				'default'           => '',
				'sanitize_callback' => 'esc_url_raw',
			)
		);
		// add control for get started link
		$wp_customize->add_control(
			'header_btn_link',
			array(
				'label'           => __( 'Button Link', 'it-zone' ),
				'section'         => 'top_bar_section',
				'type'            => 'url',
				'active_callback' => 'it_zone_fronttopbar_active_callback',
			)
		);
	}
endif;
add_action( 'customize_register', 'it_zone_customize_register_frontopbar' );

if ( ! function_exists( 'it_zone_fronttopbar_active_callback' ) ) :
	function it_zone_fronttopbar_active_callback( $control ) {
		$topbar_toggle = $control->manager->get_setting( 'topbar_toggle' )->value();

		$id = $control->id;

		if ( ! $topbar_toggle ) {
			return in_array( $id, array( 'header_btn_text', 'header_btn_link' ) );
		}
		return in_array( $id, array( 'header_btn_text', 'header_btn_link', 'heading_message', 'heading_msg_link', 'heading_msg_link_text' ) );
	}
endif;
