<?php

if ( ! function_exists( 'it_zone_customize_register_panels' ) ) :
	/**
	 * Registering Panel
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function it_zone_customize_register_panels( $wp_customize ) {
		$wp_customize->add_panel(
			'appearance_settings',
			array(
				'title'    => esc_html__( 'Appearance Settings', 'it-zone' ),
				'priority' => 10,
			)
		);

		$wp_customize->add_panel(
			'frontpage_settings_panel',
			array(
				'title'       => esc_html__( 'Front Page Settings', 'it-zone' ),
				'description' => esc_html__( 'Static Home Page Settings.', 'it-zone' ),
				'priority'    => 10,
			)
		);

		$wp_customize->add_panel(
			'general_settings_panel',
			array(
				'title'       => esc_html__( 'General Settings', 'it-zone' ),
				'description' => esc_html__( 'General Desc', 'it-zone' ),
				'priority'    => 10,
			)
		);        // ----------------------------Footer panel------------------------
		$wp_customize->add_panel(
			'footer_settings',
			array(
				'title'       => esc_html__( 'Footer Settings', 'it-zone' ),
				'description' => esc_html__( 'Footer Desc', 'it-zone' ),
				'priority'    => 10,
			)
		);
	}
endif;
add_action( 'customize_register', 'it_zone_customize_register_panels' );
