<?php
/**
 * Sanitization Functions
 *
 * @package IT_Zone
 */
if ( ! function_exists( 'it_zone_sanitize_checkbox' ) ) :
	/**
	 * Sanitize Checkbox
	 */
	function it_zone_sanitize_checkbox( $checked ) {
		// Boolean check.
		return ( ( isset( $checked ) && true == $checked ) ? true : false );
	}
endif;

if ( ! function_exists( 'it_zone_radio_sanitization_header' ) ) {
	/**
	 * Function for Sanitization Header
	 */
	function it_zone_radio_sanitization_header( $input, $setting ) {
		// get the list of possible radio box or select options
		$choices = $setting->manager->get_control( $setting->id )->choices;
		if ( array_key_exists( $input, $choices ) ) {
			return $input;
		} else {
			return $setting->default;
		}
	}
}
