<?php
/**
 * Customizer Controls Registration
 *
 * @package IT_Zone
 */

if ( ! function_exists( 'it_zone_customizer_controls_registration' ) ) :
	/**
	 * Register customizer controls.
	 *
	 * @since 1.0.0
	 * @param WP_Customize_Manager $wp_customize The customizer manager object.
	 * @return void
	 */
	function it_zone_customizer_controls_registration( $wp_customize ) {
		require_once get_template_directory() . '/inc/customizer/customizer-controls/toggle/toggle-control.php';
		require_once get_template_directory() . '/inc/customizer/customizer-controls/note/note-control.php';
		require_once get_template_directory() . '/inc/customizer/customizer-controls/radio/radio-control.php';
		require_once get_template_directory() . '/inc/customizer/customizer-controls/notice/notice-control.php';
		require_once get_template_directory() . '/inc/customizer/customizer-controls/pro/view-pro-control.php';

		$wp_customize->register_control_type( 'IT_Zone_Toggle_Control' );
		$wp_customize->register_section_type( 'IT_Zone_View_Pro_Control' );
	}
endif;
add_action( 'customize_register', 'it_zone_customizer_controls_registration' );
