<?php
/**
 * IT Zone Custom functions and definitions
 *
 * @package IT_Zone
 */

if ( ! function_exists( 'it_zone_mobile_header' ) ) :
	/**
	 * Display mobile header markup.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function it_zone_mobile_header() {
		?>
		<div class="mobile-header">
			<div class="header-wrapper">
				<div class="header-left">
					<?php it_zone_site_branding( false ); ?>
				</div>
				<div class="header-right">
					<?php it_zone_mobile_ham_wrapper(); ?>
				</div>
			</div>
		</div>
		<div class="sidebar" id="mobileSideMenu">
			<div class="sidebar-body">
				<div class="sidebar-top-wrap">
					<?php it_zone_site_branding( false ); ?>
					<button class="close-sidebar-btn" id="mobileSidebarClose">
						<span class="icon-close">
							<?php echo wp_kses( it_zone_handle_all_svgs( 'close-menu-btn' ), it_zone_get_kses_extended_ruleset() ); ?>
						</span>
					</button>
				</div>
				<?php it_zone_primary_nagivation(); ?>
			</div>
			<div class="sidebar-footer">
				<?php it_zone_front_header_one_get_started(); ?>
			</div>
		</div>
		<!-- mobile header end -->   
		<?php
	}
endif;

if ( ! function_exists( 'it_zone_top_header' ) ) :
	/**
	 * Display top header markup.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function it_zone_top_header() {
		$toggle_header = get_theme_mod( 'topbar_toggle', false );
		if ( $toggle_header ) : ?>
			<div class="header-top">
				<div class="header-top-wrapper">
					<div class="container">
						<div class="header-social-info">
							<?php it_zone_header_message(); ?>
							<?php it_zone_social_media_repeater( 'socials_media_repeater', 'header-one-social' ); ?> 
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
	<?php
	}
endif;

if ( ! function_exists( 'it_zone_bottom_header' ) ) :
	/**
	 * Display bottom header markup.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function it_zone_bottom_header() {
		?>
		<div class="header-bottom">
			<div class="container">
				<div class="header-wrapper">
					<?php it_zone_site_branding( true ); ?>
					<?php it_zone_primary_nagivation(); ?>
					<div class="header-search">
						<?php it_zone_front_header_one_get_started(); ?>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
endif;

if ( ! function_exists( 'it_zone_breadcrumbs' ) ) :
	/**
	 * Breadcrumb Trail wrapper.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function it_zone_breadcrumbs() {
		?>
		<div id="crumbs" class="breadcrumb-nav" itemscope="" itemtype="http://schema.org/BreadcrumbList">
			<?php it_zone_breadcrumb_trail(); ?>
		</div>
		<?php
	}
endif;

if ( ! function_exists( 'it_zone_breadcrumb_trail' ) ) :
	/**
	 * Get breadcrumb trail object and return the trail.
	 *
	 * @since 1.0.0
	 * @param array $args Breadcrumb trail arguments.
	 * @return string Breadcrumb trail HTML.
	 */
	function it_zone_breadcrumb_trail( $args = array() ) {
		$breadcrumb = apply_filters( 'breadcrumb_trail_object', null, $args );

		if ( ! is_object( $breadcrumb ) ) {
			$breadcrumb = new IT_Zone_Breadcrumb_Trail( $args );
		}

		return $breadcrumb->trail();
	}
endif;
