<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package IT_Zone
 */
/**
 * Doctype Hook
 *
 * @hooked it_zone_doctype
 */
do_action( 'it_zone_doctype' );
?>
<head itemscope itemtype="http://schema.org/WebSite">
	<?php
	/**
	 * Before wp_head
	 *
	 * @hooked it_zone_head
	 */
	do_action( 'it_zone_before_wp_head' );

	wp_head();
	?>
</head>

<body <?php body_class(); ?> itemscope itemtype="http://schema.org/WebPage">
	<?php wp_body_open(); ?>
	<?php
	/**
	 * Before Header
	 *
	 * @hooked it_zone_page_start - 20
	 */
	do_action( 'it_zone_before_header' );

	/**
	 * Header
	 *
	 * @hooked it_zone_header_inclusion - 10
	*/
	do_action( 'it_zone_header' );

	/**
	 * Before Content
	 *
	 * @hooked it_zone_background_header   -10
	*/
	do_action( 'it_zone_after_header' );
	echo '<div id="gl-container">';