<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package IT_Zone
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div class="comment-area-wrap">
	<?php echo it_zone_get_comment_count(); ?>
	<div id="comments" class="comments-area">

		<?php
		// You can start editing here -- including this comment!
		if ( have_comments() ) :
			?>
			<?php the_comments_navigation(); ?>

			<ol class="comment-list">
				<?php
					wp_list_comments(
						array(
							'style'      => 'ol',
							'short_ping' => true,
							'callback'   => 'it_zone_comment_list',
							'max_depth'  => 5,
						)
					);
				?>
			</ol><!-- .comment-list -->

			<?php
			the_comments_navigation();

			// If comments are closed and there are comments, let's leave a little note, shall we?
			if ( ! comments_open() ) :
				?>
				<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'it-zone' ); ?></p>
				<?php
			endif;

		endif; // Check for have_comments().

		comment_form(
			array(
				'title_reply'          => __( 'Post a Comment', 'it-zone' ),
				'title_reply_to'       => __( 'Reply to %s', 'it-zone' ),
				'title_reply_before'   => '<h3 id="reply-title" class="comment-reply-title">',
				'title_reply_after'    => '</h3>',
				'cancel_reply_before'  => ' <small>',
				'cancel_reply_after'   => '</small>',
				'comment_notes_before' => '<p class="comment-notes"><span id="email-notes">' . __( 'Your email address will not be published. Required fields are marked *', 'it-zone' ) . '</span></p>',
			)
		);
		?>

	</div><!-- #comments -->
</div><!-- .comment-area-wrap -->
