<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package IT_Zone
 */
get_header();

/**
 * Before Posts hook
 *
 * @hooked it_zone_content_wrapper_start
*/
do_action( 'it_zone_before_posts_content' );
?>
	<main id="main" class="site-main">
		<section class="error-404 not-found">
			<figure>
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/404-image.png' ); ?>" alt="">
			</figure>

			<div class="error-content">
				<h2>
					<?php echo __( 'We can\'t find the page you\'re searching for.', 'it-zone' ); ?>
				</h2>

				<p class="error-paragraph">
					<?php echo __( 'Try to use a correct url or go back to homepage to start again', 'it-zone' ); ?>
				</p>
			</div>

			<div class="error-link">
				<a href="<?php echo esc_url( get_home_url() ); ?>">
					<?php echo esc_html( __( 'Get to Homepage', 'it-zone' ) ); ?>
				</a>
			</div>
		</section>
	</main>
<?php

/**
 * After Posts hook
 *
 * @hooked it_zone_content_wrapper_end - 10
 */
do_action( 'it_zone_after_posts_content' );

get_footer();

