<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		
	<?php iris_lite_entry_header(); ?>

	<div class="post-thumbnail">
		<?php if ( '' !== get_the_post_thumbnail() && ! is_single() ) : ?>
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail(); ?>
			</a>
		<?php elseif ( '' !== get_the_post_thumbnail() ): ?>
			<?php the_post_thumbnail(); ?>
		<?php endif; ?>
	</div><!-- .post-thumbnail -->

	<div class="entry-content">
		<?php 
		if (is_single()): 
		
			the_content( sprintf(
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'iris-lite' ),
				get_the_title()
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links">' . __( 'Pages:', 'iris-lite' ),
				'after'       => '</div>',
				'link_before' => '<span class="page-number">',
				'link_after'  => '</span>',
			) );

		else:

			the_excerpt();

		endif; ?>

	</div><!-- .entry-content -->

	<?php iris_lite_entry_footer(); ?>

	<?php
		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'iris-lite' ),
				'after'  => '</div>',
			)
		);
	?>

	<?php if ( is_single() ) : ?>
		<?php get_template_part( 'template-parts/post/post-navigation' ); ?>
	<?php endif; ?>

	<?php if ( is_single() ) : ?>
		<?php get_template_part( 'template-parts/post/post-author' ); ?>
	<?php endif; ?>
	
</article><!-- #post-${ID} -->