<?php get_header(); ?>

<header class="search-page-header">
    <div class="container">
        <?php if ( have_posts() ) : ?>
            <h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'iris-lite' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
        <?php else : ?>
            <h1 class="page-title"><?php _e( 'Nothing Found', 'iris-lite' ); ?></h1>
        <?php endif; ?>
    </div><!-- .container -->
</header><!-- .search-page-header -->

<div class="page-wrap">
    <div class="container">  

    <div class="eight columns">
        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">

            <?php
            if ( have_posts() ) :
                /* Start the Loop */
                while ( have_posts() ) : the_post();

                    /**
                     * Run the loop for the search to output the results.
                     * If you want to overload this in a child theme then include a file
                     * called content-search.php and that will be used instead.
                     */
                    get_template_part( 'template-parts/content/content', 'excerpt' );

                endwhile; // End of the loop.

                the_posts_pagination();

            else : ?>

                <p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'iris-lite' ); ?></p>
                <?php
                    get_search_form();

            endif;
            ?>

            </main><!-- #main -->
        </div><!-- #primary -->
    </div><!-- .eight-columns -->

    <div class="four columns">	
		<?php get_sidebar(); ?>
    </div><!-- .four columns -->
    
    </div><!-- .container -->
</div><!-- .page-wrap -->

<?php get_footer();
