<?php

/*-----------------------------------------------------------------
	Posted By
------------------------------------------------------------------- */

if( ! function_exists( 'iris_lite_posted_by' ) ) :
    function iris_lite_posted_by(){
        $byline = sprintf(
            '<i class="fa fa-user"></i><span itemprop="name"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" itemprop="url">' . esc_html( get_the_author() ) . '</a></span>' 
        );
        echo '<span class="byline" itemprop="author" itemscope itemtype="https://schema.org/Person">' . $byline . '</span>';
    }
endif;

/*-----------------------------------------------------------------
	Posted On
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_lite_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function iris_lite_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);

		printf(
			'<span class="posted-on"><i class="fa fa-calendar"></i><a href="%1$s" rel="bookmark">%2$s</a></span>',
			esc_url( get_permalink() ),
			$time_string
		);
	}
endif;

/*-----------------------------------------------------------------
	Comment Count
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_lite_comment_count' ) ) :
	/**
	 * Prints HTML with the comment count for the current post.
	 */
	function iris_lite_comment_count() {
		if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link"><i class="fa fa-comment-o"></i>';

			/* translators: %s: Name of current post. Only visible to screen readers. */
			comments_popup_link( sprintf( __( 'Leave a comment<span class="screen-reader-text"> on %s</span>', 'iris-lite' ), get_the_title() ) );

			echo '</span>';
		}
	}
endif;

/*-----------------------------------------------------------------
	Display Tags
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_display_tags' ) ) :
function iris_display_tags(){
    if ( 'post' === get_post_type() ) {        
        $tags_list = get_the_tag_list(); 
        if ( $tags_list ) {            
            echo '<div class="post-tags"><i class="fa fa-tags"></i><span class="screen-reader-text">' . __( 'Tags', 'iris-lite' ) . '</span>' . $tags_list . '</div>';
        }
    }
}
endif;

/*-----------------------------------------------------------------
	Display Categories
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_display_categories' ) ) :
function iris_display_categories(){
    if ( 'post' === get_post_type() ) {
        $categories_list = get_the_category_list( esc_html__( ', ', 'iris-lite' ) );
        if ( $categories_list ) {
            echo '<span class="post-category" itemprop="about">' . $categories_list . '</span>';
        }
    }
}
endif;


/*-----------------------------------------------------------------
	Excerpt Text
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_excerpt_more' ) ) :
function iris_excerpt_more( $more ) {
    return is_admin() ? $more : ' &hellip; ';
}
endif;
add_filter( 'excerpt_more', 'iris_excerpt_more' );

/*-----------------------------------------------------------------
	Entry Header
------------------------------------------------------------------- */

if( ! function_exists( 'iris_lite_entry_header' ) ) :
	function iris_lite_entry_header(){ ?>
		<header class="entry-header">
			<?php
	
				iris_display_categories();
	
				if ( is_sticky() && is_home() && ! is_paged() ) {
					printf( '<span class="sticky-post">%s</span>', _x( 'Featured', 'post', 'iris-lite' ) );
				}
				if ( is_singular() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
				endif;
				
				if( is_single() ){
					echo '<div class="entry-meta">';
					iris_lite_posted_by();
					iris_lite_posted_on();
					iris_lite_comment_count();
					echo '</div>';
				}
			   
			?>
			
		</header><!-- .post-header -->
		<?php    
	}
endif;

/*-----------------------------------------------------------------
	Entry Footer
------------------------------------------------------------------- */

if( ! function_exists( 'iris_lite_entry_footer' ) ) :
	function iris_lite_entry_footer(){ 
		$readmore = __( 'Read More', 'iris-lite' );
		?>
		<footer class="entry-footer">
			<?php
				if( is_single() ) :
					iris_display_tags();

				elseif ( ! is_page() ) :
					echo '<a href="' . esc_url( get_the_permalink() ) . '" class="read-more">' . esc_html( $readmore ) . '</a>';
				
				endif;
				
				if( get_edit_post_link() ){
					edit_post_link(
						sprintf(
							wp_kses(
								__( 'Edit <span class="screen-reader-text">%s</span>', 'iris-lite' ),
								array(
									'span' => array(
										'class' => array(),
									),
								)
							),
							get_the_title()
						),
						'<span class="edit-link">[',
						']</span>'
					);
				}
			?>
		</footer><!-- .entry-footer -->
		<?php 
	}
endif;

/*-----------------------------------------------------------------
	Excerpt Text
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_widget_tag_cloud_args' ) ) :
function iris_widget_tag_cloud_args( $args ) {
	$args['largest']    = 1.2;
	$args['smallest']   = 0.8;
	$args['unit']       = 'em';
	$args['separator']  = '';

	return $args;
}
add_filter( 'widget_tag_cloud_args', 'iris_widget_tag_cloud_args' );
endif;

