<?php

/*-----------------------------------------------------------------
	Theme Setup
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_lite_setup' ) ) :
	function iris_lite_setup() {

		// Textdomain
		load_theme_textdomain( 'iris-lite', get_template_directory() . '/languages' );

		// Theme Support
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );

		// Register Menus
		register_nav_menus(
			array(
				'main'   => __( 'Main Menu', 'iris-lite' ),
				'mobile' => __( 'Mobile Menu', 'iris-lite' ),
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'iris_lite_setup' );

/*-----------------------------------------------------------------
	Include Scripts
------------------------------------------------------------------- */

function iris_lite_scripts() {

	// Main Style
	wp_enqueue_style( 'iris-lite-style', get_stylesheet_uri(), array(), wp_get_theme()->get( 'Version' ) );

	// Comment Reply
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Font Awesome
	wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css', array(), wp_get_theme()->get( 'Version' ) );

	// Google Fonts
	wp_enqueue_style( 'iris-lite-google-fonts', 'https://fonts.googleapis.com/css?family=Open+Sans:400,700"', array(), null );

	// Resposnsive Styles
	wp_enqueue_style( 'iris-lite-responsive', get_template_directory_uri() . '/assets/css/responsive.css', array(), wp_get_theme()->get( 'Version' ) );

	// jQuery
	wp_enqueue_script( 'jquery', false, '', true );

	// Navigation
	wp_enqueue_script( 'iris-lite-navigation', get_template_directory_uri() . '/assets/js/navigation.js' );
}
add_action( 'wp_enqueue_scripts', 'iris_lite_scripts' );


/*-----------------------------------------------------------------
	Comments Navigation
------------------------------------------------------------------- */

if ( ! function_exists( 'iris_lite_comment_nav' ) ) :
function iris_lite_comment_nav() {
	if (get_comment_pages_count() > 1 && get_option('page_comments')): ?>
		<nav class="comment-nav" role="navigation">
			<div class="nav-previous"><?php previous_comments_link(__( '&larr; Older Comments', 'iris-lite')); ?></div>
			<div class="nav-next"><?php next_comments_link(__( 'Newer Comments &rarr;', 'iris-lite')); ?></div>
		</nav>
	<?php endif;
}
endif;

/*-----------------------------------------------------------------
	Blog Sidebar
------------------------------------------------------------------- */

function iris_lite_sidebar_widgets() {
	register_sidebar( 
		array(
			'name'          => __( 'Main Sidebar', 'iris-lite' ),
			'id'            => 'main-sidebar',
			'description'   => __( 'Widgets in this area will be shown on blog pages.', 'iris-lite' ),
			'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="sidebar-widget-title"><span>',
			'after_title'   => '</span></h2>',
		) 
	);
}
add_action( 'widgets_init', 'iris_lite_sidebar_widgets' );

/*-----------------------------------------------------------------
	Footer Widgets
------------------------------------------------------------------- */

function iris_lite_footer_widgets() {
	if (function_exists('register_sidebar')) {
		$sidebar_attr = array(
			'name' => '',
			'before_widget' => '<section id="%1$s" class="footer-widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4 class="footer-widget-title"><span>',
			'after_title'   => '</span></h4>',
		);
		$sidebar_id = 0;
		$sidebar = array(
			__( 'Footer Column 1', 'iris-lite'),
			__( 'Footer Column 2', 'iris-lite'),
			__( 'Footer Column 3', 'iris-lite'),
			__( 'Footer Column 4', 'iris-lite'),
		);
		foreach ($sidebar as $sidebar_name) {
			$sidebar_attr['name'] = $sidebar_name;
			$sidebar_attr['id']   = 'footer-sidebar' . $sidebar_id++;
			register_sidebar($sidebar_attr);
		}
	}
}
add_action( 'widgets_init', 'iris_lite_footer_widgets' );

/*-----------------------------------------------------------------
	Require Files
------------------------------------------------------------------- */

require get_parent_theme_file_path( '/inc/template-functions.php' );

/*-----------------------------------------------------------------
	Content width
------------------------------------------------------------------- */

if ( ! isset( $content_width ) ) {
	$content_width = 810;
}