<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package Interserver Mommy Blog
 */
?>
<?php 
	global $interserver_mommy_blog_default;
	$index_feat_image = get_theme_mod( 'index_feat_image', $interserver_mommy_blog_default['index_feat_image'] );
	$index_post_content = get_theme_mod( 'index_post_content', $interserver_mommy_blog_default['index_post_content'] );
	$index_post_meta = get_theme_mod( 'index_post_meta', $interserver_mommy_blog_default['index_post_meta'] );
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
		<div class="featured-post">
			<?php esc_html_e( 'Featured', 'interserver-mommy-blog' ); ?>
		</div>
		<?php endif; ?>
		<div class="post-inner-wrap">
			<div class="post-header">
				<div class="cat-meta"><?php interserver_mommy_blog_cat_meta_info();?></div><!-- .cat-meta-->
				
				<h1 class="post-title">
					<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
				</h1><!-- .post-title-->
	
			</div><!-- .post-header -->
		<?php if(!$index_feat_image && has_post_thumbnail()):?>
			<div class="post-thumbnail">
				<?php
				if ( ! post_password_required() && ! is_attachment() ) : ?>
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<img class="img-responsive" src="<?php the_post_thumbnail_url('full'); ?>"/>
					</a>
				<?php endif; ?>
			</div><!-- .post-thumbnail -->
		<?php endif;?>

		<?php if(!$index_post_meta):?>
				<div class="post-meta">
				<?php interserver_mommy_blog_post_meta_info();?>
			</div><!-- .post-meta -->
		<?php endif;?>
			<div class="post-content">
				<?php 
				if ( ($index_post_content && is_home() ) || $index_post_content && is_archive() ) : ?>
					<?php the_content(); ?>
				<?php else :
					echo '<p>'.esc_html(interserver_mommy_blog_custom_excerpt()).'</p>';
					echo '<div class="readmore"><a href="'.esc_url(get_permalink()).'">'. esc_html('Continue Reading','interserver-mommy-blog').'</a></div>';
				 endif; ?>
			</div><!-- .post-content -->
		<?php edit_post_link( __( 'Edit', 'interserver-mommy-blog' ), '<span class="edit-link">', '</span>' ); ?>
		</div><!-- .post-inner-wrap -->
	</article><!-- #post -->