<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package Interserver Mommy Blog
 *
 */
?>
<div class="single-post-wrap">
<?php 
	global $interserver_mommy_blog_default;
	$single_feat_image = get_theme_mod( 'single_feat_image', $interserver_mommy_blog_default['single_feat_image'] );
	$single_post_meta = get_theme_mod( 'index_post_meta', $interserver_mommy_blog_default['index_post_meta'] );
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
		<div class="featured-post">
			<?php esc_html_e( 'Featured', 'interserver-mommy-blog' ); ?>
		</div>
		<?php endif; ?>
		<div class="post-header">
			<div class="cat-meta"><?php interserver_mommy_blog_cat_meta_info();?></div><!-- .cat-meta-->
			<h1 class="post-title"><?php the_title(); ?></h1>
		</div><!-- .post-header -->
		<?php if(!$single_feat_image):?>
			<div class="post-thumbnail">
			<?php
			if ( ! post_password_required() && ! is_attachment() ) :
				the_post_thumbnail('full', array( 'class' => 'img-responsive' ));
			endif;
			?>
			</div>
		<?php endif;?>
	
		<?php if(!$single_post_meta):?>
			<div class="post-meta">
				<?php interserver_mommy_blog_post_meta_info();?>
			</div><!-- .post-meta -->
		<?php endif;?>
		
		<div class="post-content">
			<?php the_content(); ?>
			<?php
			wp_link_pages(
				array(
					'before' => '<div class="page-links">' . __( 'Pages:', 'interserver-mommy-blog' ),
					'after'  => '</div>',
				)
			);
			?>
		</div><!-- .post-content -->
	</article><!-- #post -->
</div><!-- .single-post-wrap -->