<?php
/**
 * The template part for displaying a message that posts cannot be found.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Interserver Blog
 */
?>

<div class="page-wrapper">
	<div class="no-results not-found">
		<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'interserver-mommy-blog' ); ?></h1>
		<div class="page-content">
			<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
	        <p><?php sprintf(
	        	/* translators: %s: post author */
	        	__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'interserver-mommy-blog' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

			<?php elseif ( is_search() ) : ?>

				<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'interserver-mommy-blog' ); ?></p>
				<?php get_search_form(); ?>

			<?php else : ?>

				<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'interserver-mommy-blog' ); ?></p>
				<?php get_search_form(); ?>

			<?php endif; ?>
		</div><!-- .page-content -->
	</div><!-- .no-results -->
</div><!-- .page-wrapper -->
