<?php
/**
 * Template Name: Blog Page Template
 *
 * @package Interserver Mommy Blog
 *
 */
get_header();

global $interserver_mommy_blog_default;
$blog_layout = get_theme_mod( 'blog_layout', $interserver_mommy_blog_default['blog_layout'] );
    
?>
<div class="content-wrap">
    <div class="wrap">
        <div id="main" class="content-area <?php echo esc_attr( $blog_layout );?>"> 
            <div class="post-wrap">
                <?php 
                $args =array(
                    'post_type' => 'post',
                    'order' => 'desc'
                );
                $the_query = new WP_Query($args);
                while ($the_query->have_posts()) : $the_query->the_post(); ?>
                <?php get_template_part( 'template-parts/content', get_post_format() );
             
                endwhile; 
                ?>

            <?php if (function_exists("interserver_mommy_blog_pagination_nav")) {?>
                <div class="pagination"><?php interserver_mommy_blog_pagination_nav($wp_query); ?></div>
            <?php } ?>
            </div><!--.post-wrap-->
        </div><!--.main-->

        <?php if ( $blog_layout == $interserver_mommy_blog_default['blog_layout'] ) :
            get_sidebar();
        endif;?>
    </div><!-- .wrap -->
</div><!-- .content-wrap -->
<?php get_footer(); ?> 
