<?php
/**
 * The template for displaying search results pages.
 *
 * @package Interserver Mommy Blog
 */

get_header();
global $interserver_mommy_blog_default;

$blog_layout = get_theme_mod( 'blog_layout', $interserver_mommy_blog_default['blog_layout'] );
?>	

<div class="page-header">
	<h1 class="page-title"><?php 
	/* translators: %s: search-term */
	echo sprintf(__( 'Search Results for: %s', 'interserver-mommy-blog' ), '<span>' . get_search_query() . '</span>'); ?></h1>
</div><!-- .page-header -->
<div class="content-wrap">
	<div class="wrap">
		<div id="main" class="content-area <?php echo esc_attr( $blog_layout );?>">
			<?php if ( have_posts() ) : ?>
				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>
					<?php
					/**
					 * Run the loop for the search to output the results.
					 * If you want to overload this in a child theme then include a file
					 * called content-search.php and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_format() );
					?>

				<?php endwhile; ?>
				<?php the_posts_navigation(); ?>

			<?php else : ?>
				<?php get_template_part( 'template-parts/content', 'none' ); ?>
			<?php endif; ?>
			</div><!-- #main -->
	  <?php if ( $blog_layout == $interserver_mommy_blog_default['blog_layout'] ) :
			get_sidebar();
		endif;
	?>
	</div><!-- .wrap -->
</div><!-- .content-wrap -->
<?php get_footer(); ?>