<?php
/**
 *The main template file.
 *
 * @package Interserver Mommy Blog
 *
 */

get_header();
global $interserver_mommy_blog_default;
$blog_layout = get_theme_mod( 'blog_layout', $interserver_mommy_blog_default['blog_layout'] );
$hide_featured_sec = get_theme_mod( 'hide_featured_sec', $interserver_mommy_blog_default['hide_featured_sec'] );
?>  

<?php 
if(!$hide_featured_sec){
	interserver_mommy_blog_featured_section();
}
?>

<div class="content-wrap">
	<div class="wrap">
		<div id="main" class="content-area <?php echo esc_attr( $blog_layout );?>">	
			<div class="post-wrap">
				<?php while (have_posts()) : the_post(); ?>
				<?php get_template_part( 'template-parts/content', get_post_format() );?>
				<?php
				// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || get_comments_number() ) :
				    comments_template();
				endif;
				endwhile; 
				?>

			<?php if (function_exists("interserver_mommy_blog_pagination_nav")) {?>
			    <div class="pagination"><?php interserver_mommy_blog_pagination_nav($wp_query); ?></div>
			<?php } ?>
			</div><!--.post-wrap-->
		</div><!--.main-->

		<?php if ( $blog_layout == $interserver_mommy_blog_default['blog_layout'] ) :
			get_sidebar();
		endif;?>
	</div><!-- .wrap -->
</div><!-- .content-wrap -->
<?php get_footer(); ?> 