<?php
/**
 * Custom template tags for this theme.
 *
 * @package Interserver Mommy Blog
 */

if ( ! function_exists( 'interserver_mommy_blog_post_navigation' ) ) :
function interserver_mommy_blog_post_navigation() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<div class="navigation post-navigation" role="navigation">
		<h2 class="screen-reader-text"><?php esc_html_e( 'Post navigation', 'interserver-mommy-blog' ); ?></h2>
		<div class="nav-links clearfix">
			<div class="nav-previous">
			<?php previous_post_link('%link', '<i class="fas fa-long-arrow-alt-left"></i> %title'); ?>
			</div>
			<div class="nav-next">
			<?php next_post_link('%link', '%title <i class="fas fa-long-arrow-alt-right"></i>'); ?>
			</div>
		</div><!-- .nav-links -->
	</div><!-- .navigation -->
	<?php
}
endif;
if ( ! function_exists( 'interserver_mommy_blog_post_meta_info' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function interserver_mommy_blog_post_meta_info() {
	$archive_year  = get_the_time('Y'); 
	$archive_month = get_the_time('m'); 
	$archive_date  = get_the_time('d'); 

	$time_string = sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a>',
		esc_url(get_day_link($archive_year, $archive_month, $archive_date )),
		esc_attr( get_the_time() ),
		esc_attr( get_the_date() ),
		esc_html( get_the_date() )
	);

	$author = sprintf(
		/* translators: %s: post author */
		__( ' %s', 'interserver-mommy-blog' ),
		'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
	);
	echo '<span class="post-author"> ' . wp_kses_data($author) . '</span> <span class="post-date">' . wp_kses_data($time_string). '</span>';
	
	echo '<div class="post-comments">';
	if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
		echo '<span class="comments-link">';
		comments_popup_link( __( 'Leave a comment', 'interserver-mommy-blog' ), __( '1 Comment', 'interserver-mommy-blog' ), __( '% Comments', 'interserver-mommy-blog' ) );
		echo '</span>';
	}
 
 	echo "</div>";
}
endif;

if ( ! function_exists( 'interserver_mommy_blog_cat_meta_info' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function interserver_mommy_blog_cat_meta_info() {
	// Hide category and tag text for pages.
	if ( 'post' == get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( __( ', ', 'interserver-mommy-blog' ) );
		if ( $categories_list ) {
			/* translators: %s: category name */
			echo '<span class="cat-links">'. sprintf( esc_html__( ' %1$s', 'interserver-mommy-blog' ), wp_kses_data($categories_list)).'</span>';
		}
		$tags_list = get_the_tag_list( '', __( ', ', 'interserver-mommy-blog' ) );
		if ( $tags_list && is_single() ) {
			/* translators: %s: tag name */
			printf( '<span class="tags-links"><i class="fas fa-tags"></i>' . esc_html__( ' %1$s', 'interserver-mommy-blog' ) . '</span>', wp_kses_data($tags_list) );
		}
	}
}
endif;

