<?php
/**
 * Stylesheet for customizer setting
 *
 * @package Interserver Mommy Blog
 */


/* Convert hexdec color string to rgb(a) string */
 function interserver_mommy_blog_hex2rgba($color, $opacity = false) {
 	$def = 'rgb(0,0,0)';
		//Return interserver_mommy_blog_default if no color provided
		if(empty($color))
          	return $def; 
 		//Sanitize $color if "#" is provided 
        	if ($color[0] == '#' ) {
        		$color = substr( $color, 1 );
       	}
       	//Check if color has 6 or 3 characters and get values
        	if (strlen($color) == 6) {
                	$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
        	} elseif ( strlen( $color ) == 3 ) {
                	$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
        	} else {
                	return $def;
        }
		$rgb =  array_map('hexdec', $hex);
        $output = 'rgba('.implode(",",$rgb).','.$opacity.')';
        return $output;
 }
 
/* Dynamix style with customizer setting */
function interserver_mommy_blog_custom_styles($custom_css){
	global $interserver_mommy_blog_default;
	$custom_css ='';
	/*==================== Header ====================*/

    // Header Image 
    $header_image = get_header_image();
    if($header_image){
        $custom_css .= "header{background-image: url(".$header_image.");}"."\n";
    }
    
	//Header Type 
	$header_type = get_theme_mod('header_type',$interserver_mommy_blog_default['header_type']);
	if( $header_type != $interserver_mommy_blog_default['header_type'] ){
			$custom_css .= ".site-header.sticky{ position:fixed; }"."\n";
	}
	
	// Header Style
	$header_style = get_theme_mod('header_style',$interserver_mommy_blog_default['header_style']);
	if( $header_style != $interserver_mommy_blog_default['header_style'] ){
			$custom_css .= ".site-header.centered{ position:fixed; }"."\n";
	}

	
	/*==================== Fonts ====================*/
	$logo_fonts = get_theme_mod('logo_font_family', $interserver_mommy_blog_default['logo_font_family']);	
	$headings_fonts = get_theme_mod('headings_font_family', $interserver_mommy_blog_default['headings_font_family'] );
    $body_fonts = get_theme_mod('body_font_family', $interserver_mommy_blog_default['body_font_family']);  

	if ( $logo_fonts ) {
		$custom_css .= ".site-title a{ font-family:" . $logo_fonts . ";}"."\n";
	}
	if ( $headings_fonts ) {
		$custom_css .= "input[type=\"button\"], input[type=\"reset\"], input[type=\"submit\"],.main-navigation li, #sidebar .widget-title, h1, h2, h3, h4, h5, h6,.readmore a{ font-family:" . $headings_fonts . ";}"."\n";
	}
	if ( $body_fonts ) {
		$custom_css .= "body,button,select,textarea,.site-title { font-family:" . $body_fonts . ";}"."\n";
	}
	
    //Site title
    $site_title_size = get_theme_mod( 'site_title_size', $interserver_mommy_blog_default['site_title_size'] );
    if ($site_title_size) {
        $custom_css .= ".site-title { font-size:" . intval($site_title_size) . "px; }"."\n";
    }

    //Site description
    $site_desc_size = get_theme_mod( 'site_desc_size', $interserver_mommy_blog_default['site_desc_size'] );
    if ($site_desc_size) {
        $custom_css .= ".site-desc { font-size:" . intval($site_desc_size) . "px; }"."\n";
    }
    //Menu
    $menu_size = get_theme_mod( 'menu_size',  $interserver_mommy_blog_default['menu_size'] );
    if ($menu_size) {
        $custom_css .= ".nav-wrap ul li { font-size:" . intval($menu_size) . "px; }"."\n";
    }      

    //Body size
    $body_size = get_theme_mod( 'body_size', $interserver_mommy_blog_default['body_size'] );
    if ($body_size) {
        $custom_css .= "body { font-size:" . intval($body_size) . "px;}"."\n";
    }
	  	
	//H1 size
	$h1_size = get_theme_mod( 'h1_size', $interserver_mommy_blog_default['h1_size'] );
	if ($h1_size) {
		$custom_css .= "h1{ font-size:" . intval($h1_size) . "px; }"."\n";
	}
    //H2 size
    $h2_size = get_theme_mod( 'h2_size', $interserver_mommy_blog_default['h2_size'] );
    if ($h2_size) {
        $custom_css .= "h2{ font-size:" . intval($h2_size) . "px; }"."\n";
    }
    //H3 size
    $h3_size = get_theme_mod( 'h3_size', $interserver_mommy_blog_default['h3_size'] );
    if ($h3_size) {
        $custom_css .= "h3{ font-size:" . intval($h3_size) . "px; }"."\n";
    }
    //H4 size
    $h4_size = get_theme_mod( 'h4_size', $interserver_mommy_blog_default['h4_size'] );
    if ($h4_size) {
        $custom_css .= "h4{ font-size:" . intval($h4_size) . "px; }"."\n";
    }
    //H5 size
    $h5_size = get_theme_mod( 'h5_size', $interserver_mommy_blog_default['h5_size'] );
    if ($h5_size) {
        $custom_css .= "h5{ font-size:" . intval($h5_size) . "px; }"."\n";
    }
    //H6 size
    $h6_size = get_theme_mod( 'h6_size', $interserver_mommy_blog_default['h6_size'] );
    if ($h6_size) {
        $custom_css .= "h6{ font-size:" . intval($h6_size) . "px; }"."\n";
    }

	/*==================== Colors ====================*/
    // Primary color
    $primary_color = get_theme_mod( 'primary_color', $interserver_mommy_blog_default['primary_color']);
    if($primary_color){
        $custom_css .= ".site-title a,a, h1 a, h2 a, h3 a, h4 a, h5 a, h6 a,.social-icons a, .footer-bottom .social-icons a:hover,.post-title {color:" . esc_attr($primary_color) . "}"."\n";

        $custom_css .= "input[type=button], input[type=reset], input[type=submit],.readmore a,.page-numbers,.nav-previous a,.nav-next a{border: 1px solid" .esc_attr($primary_color). "}"."\n";
    }

    // Secondary color
    $secondary_color = get_theme_mod( 'secondary_color', $interserver_mommy_blog_default['secondary_color']);
    if($secondary_color){
        $custom_css .="#reply-title,.site-desc a, a:hover, body :before, h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover, .readmore a:hover,#sidebar a:hover, .widget-title{ color:" . esc_attr($secondary_color) . "}"."\n"; 

        $custom_css .= "input[type=button]:hover, input[type=reset]:hover, input[type=submit]:hover,.readmore a:hover,.nav-previous a:hover,.nav-next a:hover,.page-numbers.current,.page-numbers:hover{border: 1px solid " .esc_attr($secondary_color). "}"."\n";

        $custom_css .= ".page-header{text-shadow: 1px 2px " .esc_attr($secondary_color). "}"."\n";
    }          
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
	//Body
	$body_color = get_theme_mod( 'body_color', $interserver_mommy_blog_default['body_color'] );
	if ($body_color) {
		$custom_css .= "body { color:" . esc_attr($body_color) . "}"."\n";
	}

    //Button Color 
    $btn_bgcolor = get_theme_mod( 'btn_bgcolor', $interserver_mommy_blog_default['btn_bgcolor'] );
    $btn_textcolor = get_theme_mod( 'btn_textcolor', $interserver_mommy_blog_default['btn_textcolor'] );
    if ($btn_bgcolor || $btn_textcolor) {
        $custom_css .= "input[type=button], input[type=reset], input[type=submit],.page-numbers,.readmore a,.page-numbers,.search-form .search-submit,.menu-toggle em:before, .main-navigation ul.toggled-on li{ background-color:". esc_attr($btn_bgcolor)."; color:" . esc_attr($btn_textcolor) . "}"."\n";
        $custom_css .=".main-navigation li ul li a:hover,.main-navigation li ul li a:focus,.main-navigation li ul li a:active{ background-color: " . esc_attr($btn_bgcolor). "; color:" . esc_attr($btn_textcolor) . "}"."\n";
    }

    //Button Hover Color 
    $btn_bgcolor_hover = get_theme_mod( 'btn_bgcolor_hover', $interserver_mommy_blog_default['btn_bgcolor_hover'] );
    $btn_textcolor_hover = get_theme_mod( 'btn_textcolor_hover', $interserver_mommy_blog_default['btn_textcolor_hover'] );
    if ($btn_bgcolor_hover || $btn_textcolor_hover) {
        $custom_css .= "input[type=button]:hover, input[type=reset]:hover, input[type=submit]:hover,.readmore a:hover,.page-numbers.current,.page-numbers:hover,.page-header,.main-navigation ul.toggled-on li:hover{ background-color:". esc_attr($btn_bgcolor_hover)."; color:" . esc_attr($btn_textcolor_hover) . "}"."\n";
    }


	// Header Background Color
	$header_bg_color = get_theme_mod( 'header_bg_color', $interserver_mommy_blog_default['header_bg_color'] );
	$hbcrgba_1 = interserver_mommy_blog_hex2rgba($header_bg_color, 1);

	if ($header_bg_color) {
		$custom_css .= ".site-header { background-color:" . esc_attr($hbcrgba_1) . "}"."\n"; 
	}

    // Footer Background Color
    $footer_bg_color = get_theme_mod( 'footer_bg_color', $interserver_mommy_blog_default['footer_bg_color'] );
    $hbcrgba_1 = interserver_mommy_blog_hex2rgba($footer_bg_color, 0.9);

    if ($footer_bg_color) {
        $custom_css .= ".footer-top{ background-color:" . esc_attr($hbcrgba_1) . "}"."\n";
        $custom_css .= ".footer-bottom{ background-color:" . esc_attr($footer_bg_color) . "}"."\n"; 
    }

    // Footer Text Color
    $footer_textcolor = get_theme_mod( 'footer_textcolor', $interserver_mommy_blog_default['footer_textcolor'] );  
    if ($footer_textcolor) {
        $custom_css .= ".site-footer, .site-footer a {color:" . esc_attr($footer_textcolor) . "}"."\n";
        $custom_css .= "body.customize-partial-edit-shortcuts-shown #wrapper.boxed{ margin: auto 60px; }"."\n";
    }
    ?>
	<style type="text/css">
	<?php echo $custom_css.'custom_css';?>
	</style>
    <?php }
add_action( 'wp_head', 'interserver_mommy_blog_custom_styles' );
