<?php
/**
 * Customizer Sanitize functions
 */

// Site Layout 
function interserver_mommy_blog_sanitize_site_layout( $input ){
    $choices = array(
        'boxed'     => __('Boxed', 'interserver-mommy-blog'),
        'wide'   => __('Wide', 'interserver-mommy-blog'),
    );
    if ( array_key_exists( $input, $choices ) ) {
        return $input;
    } else {
        return '';
    }
}
//Text
function interserver_mommy_blog_sanitize_text( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}

// Textarea
if ( ! function_exists( 'interserver_mommy_blog_sanitize_textarea_content' ) ) :
function interserver_mommy_blog_sanitize_textarea( $input, $setting ) {
    return ( stripslashes( wp_filter_post_kses( addslashes( $input ) ) ) );
}
endif;

// Integer
function interserver_mommy_blog_sanitize_integer( $input ) {
    if( is_numeric( $input ) ) {
        return intval( $input );
    }
}

//Checkbox
function interserver_mommy_blog_sanitize_checkbox( $input ) {
    //returns true if checkbox is checked
    return ( ( isset( $input ) && true == $input ) ? true : false );
}

// Header Type
function interserver_mommy_blog_sanitize_header_type( $input ) {
    $choices = array(
        'sticky'     => __('Sticky', 'interserver-mommy-blog'),
        'static'   => __('Static', 'interserver-mommy-blog'),
    );
    if ( array_key_exists( $input, $choices ) ) {
        return $input;
    } else {
        return '';
    }
}

// Header Style
function interserver_mommy_blog_sanitize_header_style( $input ) {
    $choices = array(
        'inline'     => __('Inline', 'interserver-mommy-blog'),
        'centered'   => __('Centered', 'interserver-mommy-blog'),
    );
    if ( array_key_exists( $input, $choices ) ) {
        return $input;
    } else {
        return '';
    }
}

// Blog Layout
function interserver_mommy_blog_sanitize_blog_layout( $input ) {
    $choices = array(
        'full'   => __('Full', 'interserver-mommy-blog'),
        'classic'  => __('Classic', 'interserver-mommy-blog'),
    );
    if ( array_key_exists( $input, $choices ) ) {
        return $input;
    } else {
        return '';
    }
}