<?php
/**
 * Customizer Default Options
 *
 */

if ( ! function_exists( 'interserver_mommy_blog_defaults_customizer_options_options' ) ) :
	function interserver_mommy_blog_defaults_customizer_options_options() {
		$interserver_mommy_blog_defaults = array();

		// Featured Category
		$interserver_mommy_blog_defaults['hide_featured_sec'] = null;
		$interserver_mommy_blog_defaults['featured_cat'] = '0';
		
		/*======== Header Options ========*/
		// Site Layout
		$interserver_mommy_blog_defaults['site_layout'] = 'wide';

		//Header Type
		$interserver_mommy_blog_defaults['header_type'] = 'sticky';

		//Header Style
		$interserver_mommy_blog_defaults['header_style'] = 'inline';
		
 		/*======== Blog Options ========*/
		//Blog Layout
		$interserver_mommy_blog_defaults['blog_layout'] = 'classic';
			
		// Featured Images
		$interserver_mommy_blog_defaults['index_feat_image'] = null;
		$interserver_mommy_blog_defaults['single_feat_image'] = null;

	
		//Content
		$interserver_mommy_blog_defaults['index_post_content'] = null;
		$interserver_mommy_blog_defaults['index_post_meta'] = null;
		$interserver_mommy_blog_defaults['single_post_meta'] = null;
		$interserver_mommy_blog_defaults['excerpt_length'] = '50';

	
		/*======== Fonts ========*/
		// Logo Fonts
		$interserver_mommy_blog_defaults['logo_font_name'] = 'Archivo:400,600i';
		$interserver_mommy_blog_defaults['logo_font_family'] = '\'Archivo\', sans-serif';

		
		// Heading Fonts
		$interserver_mommy_blog_defaults['headings_font_name'] = 'Arvo:300,400,700,800';
		$interserver_mommy_blog_defaults['headings_font_family'] = '\'Arvo\', serif';

		// Body Fonts
		$interserver_mommy_blog_defaults['body_font_name'] = 'Lato:400,500,600';
		$interserver_mommy_blog_defaults['body_font_family'] = '\'Lato\', sans-serif';
		
		
		// Font Sizes
		$interserver_mommy_blog_defaults['site_title_size'] = '34';
		$interserver_mommy_blog_defaults['site_desc_size'] = '16';
		$interserver_mommy_blog_defaults['menu_size'] = '16';
		$interserver_mommy_blog_defaults['body_size'] = '14';
		$interserver_mommy_blog_defaults['h1_size'] = '36';
		$interserver_mommy_blog_defaults['h2_size'] = '32';
		$interserver_mommy_blog_defaults['h3_size'] = '28';
		$interserver_mommy_blog_defaults['h4_size'] = '24';
		$interserver_mommy_blog_defaults['h5_size'] = '20';
		$interserver_mommy_blog_defaults['h6_size'] = '18';

		
		/*======== Colors ========*/

		// Primary Color
		$interserver_mommy_blog_defaults['primary_color'] = '#dd9933';

		// Secondary Color
		$interserver_mommy_blog_defaults['secondary_color'] = '#dd5d52';

		// Body Text Color
		$interserver_mommy_blog_defaults['body_color'] = '#333333';

		// Button Background Color
		$interserver_mommy_blog_defaults['btn_bgcolor'] = '#333333';

		// Button Text Color
		$interserver_mommy_blog_defaults['btn_textcolor'] = '#ffffff';

		// Button Background Hover Color
		$interserver_mommy_blog_defaults['btn_bgcolor_hover'] = '#000000';

		// Button Text Hover Color
		$interserver_mommy_blog_defaults['btn_textcolor_hover'] = '#ffffff';
		
		// Header Background Color
		$interserver_mommy_blog_defaults['header_bg_color'] = '#ffffff';

		// Footer Background Color
		$interserver_mommy_blog_defaults['footer_bg_color'] = '#000000';

		// Footer Text Color
		$interserver_mommy_blog_defaults['footer_textcolor'] = '#ffffff';

		// Menu Items Color
		$interserver_mommy_blog_defaults['menu_color'] = '#333333';

		// Menu Items Hover Color
		$interserver_mommy_blog_defaults['menu_hover_color'] = '#d96e94';

		// SubMenu Items Color
		$interserver_mommy_blog_defaults['submenu_color'] = '#ffffff';

		// Slider Text color
		$interserver_mommy_blog_defaults['slider_text_color'] = '#333333';	
		
		// Sidebar Widget Title Color
		$interserver_mommy_blog_defaults['sw_title_color'] = '#d96e94';

		// Sidebar Text Color
		$interserver_mommy_blog_defaults['sidebar_text_color'] = '#333333';
		
		/*======== Footer ========*/		
		// No. of Footer Widgets to display
		$interserver_mommy_blog_defaults['footer_widgets'] = 1;
		
		// Footer Copyright
		$interserver_mommy_blog_defaults['footer_copyright'] = esc_html__( '&copy; Copyright Interserver Themes 2018. All Rights Reserved', 'interserver-mommy-blog');
		
		// Pass through filter.
		$interserver_mommy_blog_defaults = apply_filters( 'interserver_mommy_blog_defaults_customizer_options_options', $interserver_mommy_blog_defaults );
		return $interserver_mommy_blog_defaults;
	}
endif;

$interserver_mommy_blog_default = interserver_mommy_blog_defaults_customizer_options_options();