<?php
/**
 *  This template is for customizer settings
*/

    
include(locate_template('inc/customizer/defaults.php'));
get_template_part('inc/customizer/sanitize');
get_template_part('inc/customizer/controls');
get_template_part('inc/customizer/styles');

if(!function_exists('interserver_mommy_blog_customize_register')){
 function interserver_mommy_blog_customize_register( $wp_customize ) {
    $wp_customize->get_control( 'header_image' )->section = 'header_options';
    $wp_customize->get_control( 'header_image' )->priority = '2';
    $wp_customize->get_section( 'colors' )->panel = 'interserver_mommy_blog_color_panel';
    $wp_customize->get_section('colors')->title = __( 'General','interserver-mommy-blog' );
    $wp_customize->get_section( 'colors' )->priority = '35';

     
    global $interserver_mommy_blog_default;

/*====================== Site Layout ======================*/
$wp_customize->add_section( 'site_layout_sec',
        array(
        'title'      => __( 'Site Layout', 'interserver-mommy-blog' ),
        'capability' => 'edit_theme_options',
        )
    );
    
 $wp_customize->add_setting(
        'site_layout',
        array(
            'default'           => $interserver_mommy_blog_default['site_layout'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_site_layout',
        )
    );
    $wp_customize->add_control(
        'site_layout',
        array(
            'type'      => 'radio',
            'label'     => __('Site Layout', 'interserver-mommy-blog'),
            'section'   => 'site_layout_sec',
            'choices'   => array(
                'boxed'     => __('Boxed', 'interserver-mommy-blog'),
                'wide'   => __('Wide', 'interserver-mommy-blog'),
            ),
        )
    );
 
 /*====================== Featured Section ======================*/
$wp_customize->add_section( 'featured_sec',
        array(
        'title'      => __( 'Featured Section', 'interserver-mommy-blog' ),
        'capability' => 'edit_theme_options',
        )
    );

    //Hide Featured Section
    $wp_customize->add_setting(
        'hide_featured_sec',
        array(
            'default' => $interserver_mommy_blog_default['hide_featured_sec'],   
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_checkbox',
        )       
    );
    $wp_customize->add_control(
        'hide_featured_sec',
        array(
            'type' => 'checkbox',
            'label'     => __('Hide Featured Section?', 'interserver-mommy-blog'),
            'section' => 'featured_sec',
        )
    );

    $wp_customize->add_setting('featured_cat', array(
        'default' => $interserver_mommy_blog_default['featured_cat'],
        'sanitize_callback' => 'interserver_mommy_blog_sanitize_integer',
    ));

    $wp_customize->add_control( new Interserver_Mommy_Blog_Category_Control( $wp_customize, 'featured_cat', array(
        'label' => __('Featured Category', 'interserver-mommy-blog'),
        'section' => 'featured_sec',
        'settings' => 'featured_cat',
        'description' => __('Select featured category to show its posts featured section', 'interserver-mommy-blog'),
        ) )
    );     
    

/*====================== Header Options ======================*/

/*--------------- Header Type ---------------*/
    $wp_customize->add_section( 'header_options', array(
        'title'      => __( 'Header Options', 'interserver-mommy-blog' ),
        'capability' => 'edit_theme_options',
        )
    );

    // Header Image
    $wp_customize->add_setting('header_image[info]', array(
        'type'              => 'info_control',
        'sanitize_callback' => 'esc_attr',   
        )
    );
    $wp_customize->add_control( new Interserver_Mommy_Blog_Info( $wp_customize, 'header_image[info]', array(
        'label' => __('Header Image', 'interserver-mommy-blog'),
        'section' => 'header_options',
        'settings' => 'header_image[info]',
        'priority'    => 1,
        ) )
    );     

    // Header Type
    $wp_customize->add_setting('header_type[info]', array(
        'type'              => 'info_control',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new Interserver_Mommy_Blog_Info( $wp_customize, 'header_type[info]', array(
        'label' => __('Header Type', 'interserver-mommy-blog'),
        'section' => 'header_options',
        'settings' => 'header_type[info]',
        ) )
    );     

    $wp_customize->add_setting( 'header_type', array(
            'default'           => $interserver_mommy_blog_default['header_type'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_header_type',
        )
    );
    $wp_customize->add_control( 'header_type', array(
            'type' => 'radio',
            'section' => 'header_options',
            'choices' => array(
                'sticky'   => __('Sticky', 'interserver-mommy-blog'),
                'static'   => __('Static', 'interserver-mommy-blog'),
            ),
        )
    );

    // Header Style

    $wp_customize->add_setting('header_style[info]', array(
        'type'              => 'info_control',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new Interserver_Mommy_Blog_Info( $wp_customize, 'header_style[info]', array(
        'label' => __('Header Style', 'interserver-mommy-blog'),
        'section' => 'header_options',
        'settings' => 'header_style[info]',
        ) )
    );     

    $wp_customize->add_setting( 'header_style', array(
            'default'           => $interserver_mommy_blog_default['header_style'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_header_style',
        )
    );
    $wp_customize->add_control( 'header_style', array(
            'type'      => 'radio',
            'section'   => 'header_options',
            'choices'   => array(
                'inline'     => __('Inline', 'interserver-mommy-blog'),
                'centered'   => __('Centered', 'interserver-mommy-blog'),
            ),
        )
    );

     /*===================== Font Options ===================*/
   $wp_customize->add_section(
        'interserver_mommy_blog_fonts',
        array(
            'title' => __('Fonts', 'interserver-mommy-blog'),
            'description' => __('Google Fonts can be found here: google.com/fonts.', 'interserver-mommy-blog'),
        )
    );
    
    //Logo fonts title
    $wp_customize->add_setting('logo_fonts[info]', array(
            'type'              => 'info_control',
            'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new interserver_mommy_blog_Info( $wp_customize, 'logo_fonts', array(
        'label' => __('Logo fonts', 'interserver-mommy-blog'),
        'section' => 'interserver_mommy_blog_fonts',
        'settings' => 'logo_fonts[info]',
        ) )
    );    
    //Logo fonts
    $wp_customize->add_setting(
        'logo_font_name',
        array(
            'default' => $interserver_mommy_blog_default['logo_font_name'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'logo_font_name',
        array(
            'label' => __( 'Font name/style', 'interserver-mommy-blog' ),
            'section' => 'interserver_mommy_blog_fonts',
            'type' => 'text',
        )
    );
    //Logo fonts family
    $wp_customize->add_setting(
        'logo_font_family',
        array(
            'default' => $interserver_mommy_blog_default['logo_font_family'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'logo_font_family',
        array(
            'label' => __( 'Font family', 'interserver-mommy-blog' ),
            'section' => 'interserver_mommy_blog_fonts',
            'type' => 'text',
        )
    );

    //Headings fonts title
    $wp_customize->add_setting('interserver_mommy_blog_options[info]', array(
            'type'              => 'info_control',
            'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new interserver_mommy_blog_Info( $wp_customize, 'headings_fonts', array(
        'label' => __('Headings fonts', 'interserver-mommy-blog'),
        'section' => 'interserver_mommy_blog_fonts',
        'settings' => 'interserver_mommy_blog_options[info]',
        ) )
    );      
    //Headings fonts 
    $wp_customize->add_setting(
        'headings_font_name',
        array(
            'default' => $interserver_mommy_blog_default['headings_font_name'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'headings_font_name',
        array(
            'label' => __( 'Font name/style', 'interserver-mommy-blog' ),
            'section' => 'interserver_mommy_blog_fonts',
            'type' => 'text',
        )
    );
    //Headings fonts family
    $wp_customize->add_setting(
        'headings_font_family',
        array(
            'default' => $interserver_mommy_blog_default['headings_font_family'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'headings_font_family',
        array(
            'label' => __( 'Font family', 'interserver-mommy-blog' ),
            'section' => 'interserver_mommy_blog_fonts',
            'type' => 'text',
        )
    );
     
     //Body fonts title
    $wp_customize->add_setting('interserver_mommy_blog_options[info]', array(
            'type'              => 'info_control',
            'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new interserver_mommy_blog_Info( $wp_customize, 'body_fonts', array(
        'label' => __('Body fonts', 'interserver-mommy-blog'),
        'section' => 'interserver_mommy_blog_fonts',
        'settings' => 'interserver_mommy_blog_options[info]',
        ) )
    );    
    //Body fonts
    $wp_customize->add_setting(
        'body_font_name',
        array(
            'default' => $interserver_mommy_blog_default['body_font_name'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'body_font_name',
        array(
            'label' => __( 'Font name/style', 'interserver-mommy-blog' ),
            'section' => 'interserver_mommy_blog_fonts',
            'type' => 'text',
        )
    );
    //Body fonts family
    $wp_customize->add_setting(
        'body_font_family',
        array(
            'default' => $interserver_mommy_blog_default['body_font_family'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'body_font_family',
        array(
            'label' => __( 'Font family', 'interserver-mommy-blog' ),
            'section' => 'interserver_mommy_blog_fonts',
            'type' => 'text',
        )
    );
    
    //Font sizes title
    $wp_customize->add_setting('interserver_mommy_blog_options[info]', array(
            'type'              => 'info_control',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new interserver_mommy_blog_Info( $wp_customize, 'font_sizes', array(
        'label' => __('Font sizes', 'interserver-mommy-blog'),
        'section' => 'interserver_mommy_blog_fonts',
        'settings' => 'interserver_mommy_blog_options[info]',
        ) )
    );

    // Site Title
    $wp_customize->add_setting(
        'site_title_size',
        array(
      'default'           => $interserver_mommy_blog_default['site_title_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'site_title_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('Site Title font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
        ),
    ) );

     // Site Description
    $wp_customize->add_setting(
        'site_desc_size',
        array(
      'default'           => $interserver_mommy_blog_default['site_desc_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'site_desc_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('Site Description font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 24,
            'step'  => 1,
        ),
    ) );

    // Menu Items size
    $wp_customize->add_setting(
        'menu_size',
        array(
            'default'           => $interserver_mommy_blog_default['menu_size'],
      'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'menu_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('Menu items', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 50,
            'step'  => 1,
        ),
    ) );  

     //Body
    $wp_customize->add_setting(
        'body_size',
        array(
            'default'           => $interserver_mommy_blog_default['body_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'body_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('Body font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 24,
            'step'  => 1,
        ),
    ) );
       
    //H1 size
    $wp_customize->add_setting(
        'h1_size',
        array(
            'default'           => $interserver_mommy_blog_default['h1_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'h1_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('H1 font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
        ),
    ) );

    //H2 size
    $wp_customize->add_setting(
        'h2_size',
        array(
           'default'           => $interserver_mommy_blog_default['h2_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'h2_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('H2 font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
        ),
    ) );

    //H3 size
    $wp_customize->add_setting(
        'h3_size',
        array(
            'default'           => $interserver_mommy_blog_default['h3_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'h3_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('H3 font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
        ),
    ) );

    //H4 size
    $wp_customize->add_setting(
        'h4_size',
        array(
            'default'           => $interserver_mommy_blog_default['h4_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'h4_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('H4 font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
        ),
    ) );

    //H5 size
    $wp_customize->add_setting(
        'h5_size',
        array(
            'default'           => $interserver_mommy_blog_default['h5_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'h5_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('H5 font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
        ),
    ) );

    //H6 size
    $wp_customize->add_setting(
        'h6_size',
        array(
            'default'           => $interserver_mommy_blog_default['h6_size'],
            'sanitize_callback' => 'absint',
        )       
    );
    $wp_customize->add_control( 'h6_size', array(
        'type'        => 'number',
        'section'     => 'interserver_mommy_blog_fonts',
        'label'       => __('H6 font size', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
        ),
    ) );

/*======================= Colors ============================*/
    $wp_customize->add_panel('interserver_mommy_blog_color_panel', array( 
        'title'          => __('Colors', 'interserver-mommy-blog'),
        'capability'     => 'edit_theme_options',  
    ));
   /*----------------- Header Colors ------------------*/
    $wp_customize->add_section('header_colors',  array(
        'title'          => __('Header', 'interserver-mommy-blog'),
        'panel'     => 'interserver_mommy_blog_color_panel',
    ));

    //Primary Color
    $wp_customize->add_setting( 'primary_color', array(
        'default'           => $interserver_mommy_blog_default['primary_color'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'primary_color', array(
        'label' => __('Primary Color', 'interserver-mommy-blog'),
        'section' => 'colors',
        )
    ));
  
   //Secondary Color 
    $wp_customize->add_setting('secondary_color',array(
        'default'           => $interserver_mommy_blog_default['secondary_color'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize,'secondary_color', array(
        'label' => __('Secondary Color ', 'interserver-mommy-blog'),
        'section' => 'colors',
        )
    ));

    //Body Text Color 
    $wp_customize->add_setting('body_color',array(
        'default'           => $interserver_mommy_blog_default['body_color'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize,'body_color', array(
        'label' => __('Body Text Color', 'interserver-mommy-blog'),
        'section' => 'colors',
        )
    ));

    //Button Background Color 
    $wp_customize->add_setting('btn_bgcolor',array(
        'default'           => $interserver_mommy_blog_default['btn_bgcolor'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize,'btn_bgcolor', array(
        'label' => __('Button Background Color ', 'interserver-mommy-blog'),
        'section' => 'colors',
        )
    ));

    //Button Text Color 
    $wp_customize->add_setting('btn_textcolor',array(
        'default'           => $interserver_mommy_blog_default['btn_textcolor'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize,'btn_textcolor', array(
        'label' => __('Button Text Color', 'interserver-mommy-blog'),
        'section' => 'colors',
        )
    ));
    //Button Background Hover Color 
    $wp_customize->add_setting('btn_bgcolor_hover',array(
        'default'           => $interserver_mommy_blog_default['btn_bgcolor_hover'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize,'btn_bgcolor_hover', array(
        'label' => __('Button Background Hover Color ', 'interserver-mommy-blog'),
        'section' => 'colors',
        )
    ));

    //Button Text Hover Color 
    $wp_customize->add_setting('btn_textcolor_hover',array(
        'default'           => $interserver_mommy_blog_default['btn_textcolor_hover'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize,'btn_textcolor_hover', array(
        'label' => __('Button Text Hover Color', 'interserver-mommy-blog'),
        'section' => 'colors',
        )
    ));

    // Header Background Color
    $wp_customize->add_setting( 'header_bg_color', array(
        'default'           => $interserver_mommy_blog_default['header_bg_color'],
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_bg_color', array(
        'label' => __('Header Background', 'interserver-mommy-blog'),
        'section' => 'header_colors',
        )
    ));


    /*----------------- Footer Colors ------------------*/
    $wp_customize->add_section('footer_colors',  array(
        'title'          => __('Footer', 'interserver-mommy-blog'),
        'panel'     => 'interserver_mommy_blog_color_panel',
    ));
  
   // Footer Background Color
    $wp_customize->add_setting( 'footer_bg_color', array( 
        'default'       => $interserver_mommy_blog_default['footer_bg_color'],
        'sanitize_callback' => 'sanitize_hex_color',       
    ));
 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_bg_color', array(
        'label'      => __( 'Footer Background', 'interserver-mommy-blog' ),
        'section'    => 'footer_colors',
        'settings'   => 'footer_bg_color'
        )
    ));

    // Footer Text Color
    $wp_customize->add_setting( 'footer_textcolor', array( 
        'default'       => $interserver_mommy_blog_default['footer_textcolor'],
        'sanitize_callback' => 'sanitize_hex_color',       
    ));
 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_textcolor', array(
        'label'      => __( 'Footer Text', 'interserver-mommy-blog' ),
        'section'    => 'footer_colors',
        'settings'   => 'footer_textcolor'
        )
    ));


/*====================== Blog Options ======================*/

    //Blog Layout
    $wp_customize->add_section( 'blog_options', array(
        'title'      => __( 'Blog Options', 'interserver-mommy-blog' ),
        'capability' => 'edit_theme_options',
        )
    );

    $wp_customize->add_setting('blog_layout[info]', array(
        'type'              => 'info_control',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new Interserver_Mommy_Blog_Info( $wp_customize, 'blog_layout[info]', array(
        'label' => __('Blog Layout', 'interserver-mommy-blog'),
        'section' => 'blog_options',
        'settings' => 'blog_layout[info]',
        ) )
    );     

    $wp_customize->add_setting( 'blog_layout', array(
            'default'           => $interserver_mommy_blog_default['blog_layout'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_blog_layout',
        )
    );
    $wp_customize->add_control( 'blog_layout', array(
            'type' => 'radio',
            'section' => 'blog_options',
            'choices' => array(
                'full'     => __('Full', 'interserver-mommy-blog'),
                'classic'   => __('Classic', 'interserver-mommy-blog'),
            ),
        )
    );

    //Featured images
    $wp_customize->add_setting('featured_image[info]', array(
        'type'              => 'info_control',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new Interserver_Mommy_Blog_Info( $wp_customize, 'featured_image[info]', array(
        'label' => __('Featured images', 'interserver-mommy-blog'),
        'section' => 'blog_options',
        'settings' => 'featured_image[info]',
        ) )
    );     
    //Index featured images
    $wp_customize->add_setting(
        'index_feat_image',
        array(
            'default' => $interserver_mommy_blog_default['index_feat_image'],   
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_checkbox',
        )       
    );
    $wp_customize->add_control(
        'index_feat_image',
        array(
            'type' => 'checkbox',
            'label' => __('Check this box to hide featured images on index, archives etc.', 'interserver-mommy-blog'),
            'section' => 'blog_options',
        )
    );
    //Single featured images
    $wp_customize->add_setting(
        'single_feat_image',
        array(
            'default' => $interserver_mommy_blog_default['single_feat_image'],   
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_checkbox',
        )       
    );
    $wp_customize->add_control(
        'single_feat_image',
        array(
            'type' => 'checkbox',
            'label' => __('Check to hide featured images on single posts', 'interserver-mommy-blog'),
            'section' => 'blog_options',
        )
    );

    //Content Or Excerpt
    $wp_customize->add_setting('content_options[info]', array(
        'type'              => 'info_control',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new Interserver_Mommy_Blog_Info( $wp_customize, 'content_options[info]', array(
        'label' => __('Content', 'interserver-mommy-blog'),
        'section' => 'blog_options',
        'settings' => 'content_options[info]',
        ) )
    ); 

    // Post Excerpt length
    $wp_customize->add_setting(
        'excerpt_length',
        array(
            'default'  => $interserver_mommy_blog_default['excerpt_length'],
            'sanitize_callback' => 'absint',
         )       
    );
    $wp_customize->add_control( 'excerpt_length', array(
        'type'        => 'number',
        'section'     => 'blog_options',
        'label'       => __('Excerpt length', 'interserver-mommy-blog'),
        'desc' => __('Choose your excerpt length. Default: 33 words', 'interserver-mommy-blog'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 200,
            'step'  => 5,
        ),
    ) );    

     //Index Content
    $wp_customize->add_setting(
        'index_post_content',
        array(
            'default' => $interserver_mommy_blog_default['index_post_content'],   
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_checkbox',
        )       
    );
    $wp_customize->add_control(
        'index_post_content',
        array(
            'type' => 'checkbox',
            'label' => __('Check this box to display full content on index, archives etc.', 'interserver-mommy-blog'),
            'section' => 'blog_options',
        )
    );
    
    // Post Meta 
    $wp_customize->add_setting('post_meta[info]', array(
        'type'              => 'info_control',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new Interserver_Mommy_Blog_Info( $wp_customize, 'post_meta[info]', array(
        'label' => __('Post Meta', 'interserver-mommy-blog'),
        'section' => 'blog_options',
        'settings' => 'post_meta[info]',
        ) )
    ); 

    $wp_customize->add_setting(
        'index_post_meta',
        array(
            'default' => $interserver_mommy_blog_default['index_post_meta'],   
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_checkbox',
        )       
    );
    $wp_customize->add_control(
        'index_post_meta',
        array(
            'type' => 'checkbox',
            'label' => __('Check this box to hide post meta on index, archives etc.', 'interserver-mommy-blog'),
            'section' => 'blog_options',
        )
    );

    $wp_customize->add_setting(
        'single_post_meta',
        array(
            'default' => $interserver_mommy_blog_default['single_post_meta'],   
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_checkbox',
        )       
    );
    $wp_customize->add_control(
        'single_post_meta',
        array(
            'type' => 'checkbox',
            'label' => __('Check this box to hide post meta on single posts', 'interserver-mommy-blog'),
            'section' => 'blog_options',
        )
    );

/*====================== Footer Options ======================*/
    $wp_customize->add_section( 'footer_options', array(
            'title'         => __('Footer Options', 'interserver-mommy-blog'),
            'capability' => 'edit_theme_options',
     )
    );
  // Footer Widgets
    $wp_customize->add_setting( 'footer_widgets',  array(
            'default'           => $interserver_mommy_blog_default['footer_widgets'],
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control( 'footer_widgets', array(
            'type'        => 'number',
            'label'       => __('Footer Widgets', 'interserver-mommy-blog'),
            'section'     => 'footer_options',
            'description' => __('Select the number of widgets you want in the footer and go to Appearance > Widgets and add your widgets.', 'interserver-mommy-blog'),
            'input_attrs' => array(
            'min'   => 1,
            'max'   => 3,
            'step'  => 1,
            ),
        )
    );
    
  // Footer Copyright
    $wp_customize->add_setting( 'footer_copyright', array(
            'default'           => $interserver_mommy_blog_default['footer_copyright'],
            'sanitize_callback' => 'interserver_mommy_blog_sanitize_text',
        )
    );
     $wp_customize->add_control( 'footer_copyright', array(
           'label' => __( 'Copyright Text', 'interserver-mommy-blog' ),
           'section' => 'footer_options',
           'type' => 'text'
        ));
    
}
}
add_action( 'customize_register', 'interserver_mommy_blog_customize_register' );