<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package Interserver Mommy Blog
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>

<body <?php body_class();?>>
<?php wp_body_open();?>
<div id="page" class="site">
<?php 
	global $interserver_mommy_blog_default;
	$site_layout = get_theme_mod('site_layout', $interserver_mommy_blog_default['site_layout']);
	$header_type = get_theme_mod('header_type', $interserver_mommy_blog_default['header_type']);
	$header_style = get_theme_mod('header_style', $interserver_mommy_blog_default['header_style']);
?>
	<div id="wrapper" class="site-wrapper<?php if( $site_layout ){ echo ' '. esc_attr($site_layout);}?>">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'interserver-mommy-blog' ); ?></a>

	<header id="masthead" class="site-header<?php if( $header_type ){ echo ' '. esc_attr($header_type);}?>">
		<div class="wrap">
			<div class="header-inner <?php if( $header_style ){ echo ' '. esc_attr($header_style);}?>">
				<div class="site-brand">
				   	<?php 
				   		$custom_logo_id = get_theme_mod( 'custom_logo' );
						$logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );

						if(has_custom_logo()){
							echo '<a href="'.esc_url( home_url( '/' ) ).'"><img src="' . esc_url( $logo[0] ) . '" alt=""></a>';
						}
						else{
							echo '<h1 class="site-title"><a href="'.esc_url( home_url( '/' ) ).'">'.esc_attr(get_bloginfo('name')).'</a></h1><span class="site-desc"><a href="'.esc_url( home_url( '/' ) ).'">'.esc_attr(get_bloginfo('description')).'</a></span>';
						}
						?>
					</a>
				</div><!--.site-brand-->
			
				<?php if ( has_nav_menu( 'primary' ) ) : ?>
					<div class="navigation-section">
						<nav class="nav-wrap">
							<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'menu-item'.' '. esc_attr($header_style)) ); ?>
						</nav>
					</div>
				<?php endif; ?>
					
			</div><!-- .header-inner-->
		</div><!--.wrap-->
	</header><!-- #masthead -->

  	<div id="content" class="site-content">