<?php
/**
* This template displays footer of the theme.
*
* Contains the closing of the <div id="content"> and all content after.
*
* @package Interserver Mommy Blog
*/

global $interserver_mommy_blog_default;
?>

</div><!-- #content-->

<footer id="footer" class="site-footer" role="contentinfo">
	<a href="#page" class="scroll-top"><i class="fas fa-long-arrow-alt-up"></i></a>
	<div class="footer-top">
		<?php if(is_active_sidebar('footer-top')):
			dynamic_sidebar( 'footer-top');
		endif;
		?>
	<?php if (is_active_sidebar( 'footer-1' ) || is_active_sidebar( 'footer-2' ) || is_active_sidebar( 'footer-3' )) : ?>
		<div id="footer-widgets" class="footer-widgets widget-area" role="complementary">
			<div class="wrap">
		        <?php 
		        $widget_areas = (int)(get_theme_mod('footer_widgets', '1'));
		        if ($widget_areas == '3') {
		            $cols = 'three-column';
		        } elseif ($widget_areas == '2') {
		            $cols = 'two-column';
		        } else {
		            $cols = 'one-column';
		        }
		        for($i=1;$i<=$widget_areas*1;$i++){
		            if ( is_active_sidebar( 'footer-'.$i ) ) { ?>
		                <div class="footer-widget <?php echo esc_attr($cols); ?>">
		                    <?php dynamic_sidebar( 'footer-'.$i); ?>
		                </div>
		        <?php } } ?>
		    </div><!-- .wrap -->
		</div><!--#footer-widgets -->
	<?php endif;?>
	</div><!-- .footer-top -->
	<div class="footer-bottom">
		<div class="copyright">
			<span><?php echo esc_html(get_theme_mod('footer_copyright', $interserver_mommy_blog_default['footer_copyright']));?></span>
		</div>
	</div><!-- .footer-bottom -->
</footer><!-- #colophon -->
</div><!--.wrapper-->

</div><!-- #page -->
<?php wp_footer(); ?>
</body>
</html>