<?php
/**
 * The template for displaying archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Interserver Mommy Blog
 *
 */

get_header();
global $interserver_mommy_blog_default;
$blog_layout = get_theme_mod( 'blog_layout', $interserver_mommy_blog_default['blog_layout'] );
?>	

<div class="page-header">
	<?php
	the_archive_title( '<h1 class="archive-title">', '</h1>' );
	the_archive_description( '<div class="archive-description">', '</div>' );
	?>
</div><!-- .page-header -->

<div class="content-wrap">
	<div class="wrap">
		<div id="main" class="content-area <?php echo esc_attr( $blog_layout );?>">
			<?php if ( have_posts() ) : ?>
				<div class="blog-layout">
				<?php while ( have_posts() ) : the_post(); ?>
				<?php
					/* Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'template-parts/content', get_post_format() );
					?>
				<?php endwhile; ?>
				</div>
				
				<?php if ( function_exists( 'interserver_mommy_blog_pagination_nav' ) ) { ?>
			    	<div class="pagination"><?php interserver_mommy_blog_pagination_nav( $wp_query ); ?></div>
				<?php } ?>

			<?php else : ?>

				<?php get_template_part( 'template-parts/content', 'none' ); ?>

			<?php endif; ?>

			</div><!-- #main -->

		<?php if ( $blog_layout == $interserver_mommy_blog_default['blog_layout'] ) :
			get_sidebar();
		endif;
	?>
	</div><!-- .wrap -->
</div><!-- .content-wrap -->
<?php get_footer(); ?>
