<?php
/**
 * Template part for displaying posts
 *
 * @subpackage Interior Architect
 * @since 1.0
 * @version 1.4
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
  <?php if(has_post_thumbnail()) { ?>
    <?php the_post_thumbnail(); ?>
  <?php }?>
  <div class="article_content">
    <a href="<?php the_permalink(); ?>" class="head"><?php the_title(); ?></a>
    <p class="mb-0">
      <?php $interior_architect_excerpt = get_the_excerpt(); echo esc_html( interior_architect_string_limit_words( $interior_architect_excerpt,30 ) ); ?> <?php echo esc_html_e('...', 'interior-architect'); ?>
      <a href="<?php the_permalink(); ?>" class="read-btn"><?php echo esc_html_e('Read More', 'interior-architect'); ?><span class="screen-reader-text"><?php echo esc_html_e('Read More', 'interior-architect'); ?></span></a>
    </p>
    <div class="clearfix"></div>
  </div>
  <div class="metabox"> 
    <span class="entry-comments"><i class="fas fa-comments"></i><?php comments_number( __('0 Comments','interior-architect'), __('0 Comments','interior-architect'), __('% Comments','interior-architect') ); ?></span>
    <span class="entry-date"><span><i class="fas fa-calendar-alt"></i><?php echo esc_html( get_the_date()); ?></span></span>
  </div>
</article>