<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="skip-content" role="main">

	<?php do_action( 'interior_architect_above_slider' ); ?>

	<?php if( get_theme_mod('interior_architect_slider_hide_show') != ''){ ?>
		<section id="slider">
			<div id="slider" class="slider_section">
				<div class="msli-oly"></div>
				<div class="container">
					<div class="slider-area">
						<div class="row">
							<?php
								$interior_architect_slider_pages = array();
								for ( $count = 1; $count <= 4; $count++ ) {
									$mod = intval( get_theme_mod( 'interior_architect_slider'. $count ));
									if ( 'page-none-selected' != $mod ) {
										$interior_architect_slider_pages[] = $mod;
									}
								}
								$args = array(
									'post_type' => 'page',
									'post__in' => $interior_architect_slider_pages,
									'orderby' => 'post__in'
								);
								$query = new WP_Query( $args );
								if ( $query->have_posts() ) {
							?>
							<div class="swiper-container slider-top">
								<div class="swiper-wrapper">
									<?php while($query->have_posts()) : $query->the_post(); ?>
										<div class="swiper-slide">
											<div class="swiper-slide-container">
												<div class="slider_content">
													<div class="title  "><?php the_title(); ?></div>
													<div class="text ">
														<?php 
															$interior_architect_slider_excerpt_length = get_theme_mod('interior_architect_slider_excerpt_length');
														
															if( $interior_architect_slider_excerpt_length != '15'){?>
															<?php $interior_architect_excerpt = get_the_excerpt(); echo esc_html( interior_architect_string_limit_words( $interior_architect_excerpt, esc_attr(get_theme_mod('interior_architect_slider_excerpt_length','15') ) )); ?>
														<?php } ?>
													</div>
													<div class="slide-btna">
														<div class="btn5">  
															<a href="<?php the_permalink(); ?>"> 
																<?php echo esc_html_e('Read more','interior-architect'); ?></span>
																<span>
																<svg fill="#000000" height="25px" width="25px" viewBox="0 0 32 32"><path d="M19,25.6c-0.3,0-0.5-0.1-0.8-0.2c-0.8-0.3-1.2-1-1.2-1.8V20H5c-1.1,0-2-0.9-2-2v-4c0-1.1,0.9-2,2-2h12V8.4 c0-0.8,0.5-1.5,1.2-1.8C19,6.3,19.8,6.4,20.4,7l8.3,8.3c0.4,0.4,0.4,1,0,1.4L20.4,25C20,25.4,19.5,25.6,19,25.6z"></path> 
																</svg>
																</span>
															</a>
														</div>
													</div>
												</div>
											</div>
										</div>
									<?php endwhile; ?>
								</div>
							</div>
							<div class="swiper-container slider-thumbs">
								<div class="swiper-wrapper">
									<?php while($query->have_posts()) : $query->the_post(); ?>
										<div class="swiper-slide">
											<div class="swiper-slide-container">
												<?php
													if (has_post_thumbnail()) {
														$slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
														$image_url = $slider_image[0];
													} else {
														$image_url = get_template_directory_uri() . '/assets/images/default.png';
													}
												?>
												<img class="slide-mainimg"  src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />
											</div>
										</div>
									<?php endwhile; ?>
								</div>
							</div>
							<?php } else{ ?>
								
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		  	<div class="clearfix"></div>
		</section>
		<script>
			jQuery(document).ready(function($) {
			var sliderTop = new Swiper('.slider-top', {
			// direction: 'vertical',
			spaceBetween: 10,
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			loop: true,
			autoplay: {
					delay: 5000,
					disableOnInteraction: true,
					},
			loopedSlides: 4,
			breakpoints: {
				768: {
				direction: 'vertical',
				// loop: false
				}
			}
			});
			var sliderThumbs = new Swiper('.slider-thumbs', {
			spaceBetween: 10,
			centeredSlides: true,
			slidesPerView: 3,
			// touchRatio: 0.2,
			slideToClickedSlide: true,
			loop: true,
			autoplay: {
					delay: 5000,
					disableOnInteraction: true,
					},
			loopedSlides: 4
			});
			sliderTop.controller.control = sliderThumbs;
			sliderThumbs.controller.control = sliderTop;

			});
		</script>
	<?php }?>
	
	<?php do_action('interior_architect_below_slider'); ?>
		
		<section id="banner-section">
			<div class="banner-bx"> 
				<div class="row">
					<div class="col-xl-3 col-lg-3 col-md-12 col-xs-12 banleft-box">
						<div class="banner-shapetext">
							<h4><?php echo esc_html(get_theme_mod('interior_architect_bannerheading')); ?></h4>
						</div>
					</div>
					<div class="col-xl-9 col-lg-9 col-md-12 col-xs-12 banright-box">
						<div class="row">
							<div class="col-xl-5 col-lg-5 col-md-6 col-xs-12">
								<div class="banner-titlerea">
                                  <div class="banner_title">
                                      <h2 class="inner-area-title"><?php echo esc_html(get_theme_mod('interior_architect_bannertitle')); ?></h2> 
                                  </div>
                                  <div class="banner_subtitle">
                                      <h3><?php echo esc_html(get_theme_mod('interior_architect_bannersubtitle')); ?></h3>
                                  </div>
                              </div>
							</div>
							<div class="col-xl-7 col-lg-7 col-md-6 col-xs-12 pd-0">
                         		<div class="banner-textarea">
                                  <div class="banner_distitle">
                                      <p><?php echo esc_html(get_theme_mod('interior_architect_bannerdescription')); ?></p>
                                  </div>
								</div>
                      		</div>
						</div>
					</div>
				</div>
			</div>
		</section>

	<?php do_action('interior_architect_below_banner_section'); ?>

	<?php if( get_theme_mod('interior_architect_service_category_setting') != '' ){?>
		<section id="service-section" class="py-5">
			<div class="service-imgovly1">
				<?php 
					echo '<img alt="About us" src="'.get_template_directory_uri().'/assets/images/srvice-img1.png" class="img-responsive" />';
				?>
			</div>
			<div class="service-imgovly2">
				<?php 
					echo '<img alt="About us" src="'.get_template_directory_uri().'/assets/images/srvice-img2.png" class="img-responsive" />';
				?>
			</div>
			
			<div class="container"> 
		
				<div class="row ">  
					<?php $interior_architect_catData1 =  get_theme_mod('interior_architect_service_category_setting');
					if($interior_architect_catData1){ 
						$args = array(
							'post_type' => 'post',
							'category_name' => $interior_architect_catData1,
							'posts_per_page' => get_theme_mod('interior_architect_service_number',6)
						);
						$i=1; ?>
						<?php $query = new WP_Query( $args );
						if ( $query->have_posts() ) :
							while( $query->have_posts() ) : $query->the_post(); ?>
								<div class="col-lg-4 col-md-6 single-service-bx">
									<div class="single-service">
										<div class="service-numb">
											<h5><?php echo $i; ?></h5>
										</div>
										<div class="service-icon">
											<?php
												if (has_post_thumbnail()) {
													$services_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
													$image_url = $services_image[0];
												} else {
													$image_url = get_template_directory_uri() . '/assets/images/default.png';
												}
											?>
											<img class="slide-mainimg"  src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />

											<div class="sertxbx">
												<a href="<?php the_permalink(); ?>">
													<h4 class="post-title inner-area-title wow fadeInDown"><?php the_title_attribute(); ?></h4>
												</a>
												<p class="section-area-text"><?php $interior_architect_excerpt = get_the_excerpt(); echo esc_html( interior_architect_string_limit_words( $interior_architect_excerpt,8 ) ); ?>
													<a href="<?php the_permalink(); ?>"><i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
												</p>
											</div>
										</div>
									</div>
								</div>
							<?php $i++; endwhile; 
							wp_reset_postdata(); ?>
						<?php else : ?>
							<div class="no-postfound"></div>
						<?php endif; ?>
					<?php }?>
				</div>
			</div>
		</section>
	<?php }?>

	<?php do_action('interior_architect_below_service_section'); ?>

	<div class="container">
	  	<?php while ( have_posts() ) : the_post(); ?>
	  		<div class="lz-content">
	        	<?php the_content(); ?>
	        </div>
	    <?php endwhile; // end of the loop. ?>
	</div>
</main>

<?php get_footer(); ?>