<?php
/**
 * Interior Architect: Customizer
 *
 * @subpackage Interior Architect
 * @since 1.0
 */

use WPTRT\Customize\Section\Interior_Architect_Button;

add_action( 'customize_register', function( $manager ) {

	$manager->register_section_type( Interior_Architect_Button::class );

	$manager->add_section(
		new Interior_Architect_Button( $manager, 'interior_architect_pro', [
			'title' => __( 'Interior Architect Pro', 'interior-architect' ),
			'priority' => 0,
			'button_text' => __( 'Go Pro', 'interior-architect' ),
			'button_url'  => esc_url( 'https://www.luzuk.com/product/architect-wp-theme', 'interior-architect')
		] )
	);

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'interior-architect-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
		[ 'customize-controls' ],
		$version,
		true
	);

	wp_enqueue_style(
		'interior-architect-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
		[ 'customize-controls' ],
 		$version
	);

} );

function interior_architect_customize_register( $wp_customize ) {

	$wp_customize->add_setting('interior_architect_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('interior_architect_logo_padding',array(
		'label' => __('Logo Margin','interior-architect'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('interior_architect_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'interior_architect_sanitize_float'
	));
	$wp_customize->add_control('interior_architect_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','interior-architect'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('interior_architect_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'interior_architect_sanitize_float'
	));
	$wp_customize->add_control('interior_architect_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','interior-architect'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('interior_architect_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'interior_architect_sanitize_float'
	));
	$wp_customize->add_control('interior_architect_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','interior-architect'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('interior_architect_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'interior_architect_sanitize_float'
 	));
 	$wp_customize->add_control('interior_architect_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','interior-architect'),
		'section' => 'title_tagline',
    ));

	$wp_customize->add_setting('interior_architect_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'interior_architect_sanitize_checkbox'
	));
	$wp_customize->add_control('interior_architect_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','interior-architect'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'interior_architect_site_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_site_title_color', array(
		'label' => 'Title Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_setting('interior_architect_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'interior_architect_sanitize_checkbox'
	));
	$wp_customize->add_control('interior_architect_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','interior-architect'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'interior_architect_site_tagline_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_site_tagline_color', array(
		'label' => 'Tagline Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_panel( 'interior_architect_panel_id', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Theme Settings', 'interior-architect' ),
		'description' => __( 'Description of what this panel does.', 'interior-architect' ),
	) );

	$wp_customize->add_section( 'interior_architect_theme_options_section', array(
    	'title'      => __( 'General Settings', 'interior-architect' ),
		'priority'   => 30,
		'panel' => 'interior_architect_panel_id'
	) );

	$wp_customize->add_setting('interior_architect_theme_options',array(
		'default' => 'One Column',
		'sanitize_callback' => 'interior_architect_sanitize_choices'
	));
	$wp_customize->add_control('interior_architect_theme_options',array(
		'type' => 'select',
		'label' => __('Blog Page Sidebar Layout','interior-architect'),
		'section' => 'interior_architect_theme_options_section',
		'choices' => array(
		   'Left Sidebar' => __('Left Sidebar','interior-architect'),
		   'Right Sidebar' => __('Right Sidebar','interior-architect'),
		   'One Column' => __('One Column','interior-architect'),
		   'Grid Layout' => __('Grid Layout','interior-architect')
		),
	));

	$wp_customize->add_setting('interior_architect_single_post_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'interior_architect_sanitize_choices'
	));
	$wp_customize->add_control('interior_architect_single_post_sidebar',array(
        'type' => 'select',
        'label' => __('Single Post Sidebar Layout','interior-architect'),
        'section' => 'interior_architect_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','interior-architect'),
            'Right Sidebar' => __('Right Sidebar','interior-architect'),
            'One Column' => __('One Column','interior-architect')
        ),
	));

	$wp_customize->add_setting('interior_architect_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'interior_architect_sanitize_choices'
	));
	$wp_customize->add_control('interior_architect_page_sidebar',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','interior-architect'),
        'section' => 'interior_architect_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','interior-architect'),
            'Right Sidebar' => __('Right Sidebar','interior-architect'),
            'One Column' => __('One Column','interior-architect')
        ),
	));

	$wp_customize->add_setting('interior_architect_archive_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'interior_architect_sanitize_choices'
	));
	$wp_customize->add_control('interior_architect_archive_page_sidebar',array(
        'type' => 'select',
        'label' => __('Archive & Search Page Sidebar Layout','interior-architect'),
        'section' => 'interior_architect_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','interior-architect'),
            'Right Sidebar' => __('Right Sidebar','interior-architect'),
            'One Column' => __('One Column','interior-architect'),
            'Grid Layout' => __('Grid Layout','interior-architect')
        ),
	));

	//Header
	$wp_customize->add_section( 'interior_architect_header' , array(
    	'title'    => __( 'Header Section', 'interior-architect' ),
		'priority' => null,
		'panel' => 'interior_architect_panel_id'
	) );

	$wp_customize->add_setting( 'interior_architect_header_bg', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_bg', array(
		'label' => 'BG Color',
		'section' => 'interior_architect_header',
	)));


	$wp_customize->add_setting('interior_architect_phone',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('interior_architect_phone',array(
	   	'type' => 'text',
	   	'label' => __('Add Phone Number','interior-architect'),
	   	'section' => 'interior_architect_header',
	));

	$wp_customize->add_setting( 'interior_architect_header_phoneno_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_phoneno_color', array(
		'label' => 'Phone Number Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_header_phoneheading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_phoneheading_color', array(
		'label' => 'Phone Heading Color',
		'section' => 'interior_architect_header',
	)));



	$wp_customize->add_setting('interior_architect_facebook_url',array(
    	'default' => '',
    	'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('interior_architect_facebook_url',array(
	   	'type' => 'url',
	   	'label' => __('Add Facebook URL','interior-architect'),
	   	'section' => 'interior_architect_header',
	));

	$wp_customize->add_setting('interior_architect_twitter_url',array(
    	'default' => '',
    	'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('interior_architect_twitter_url',array(
	   	'type' => 'url',
	   	'label' => __('Add Twitter URL','interior-architect'),
	   	'section' => 'interior_architect_header',
	));

	$wp_customize->add_setting('interior_architect_instagram_url',array(
    	'default' => '',
    	'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('interior_architect_instagram_url',array(
	   	'type' => 'url',
	   	'label' => __('Add Instagram URL','interior-architect'),
	   	'section' => 'interior_architect_header',
	));

	$wp_customize->add_setting('interior_architect_instagram_telegram',array(
    	'default' => '',
    	'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('interior_architect_instagram_telegram',array(
	   	'type' => 'url',
	   	'label' => __('Add Telegram URL','interior-architect'),
	   	'section' => 'interior_architect_header',
	));

	$wp_customize->add_setting( 'interior_architect_header_icon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_icon_color', array(
		'label' => 'Icon Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_header_icon_colorbg', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_icon_colorbg', array(
		'label' => 'Icon BG Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_header_icon_colorbg', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_icon_colorbg', array(
		'label' => 'Icon BG Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_header_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_menu_color', array(
		'label' => 'Menu Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_activehrvmenu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_activehrvmenu_color', array(
		'label' => 'Active and Hover Menu Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_activehrvmenubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_activehrvmenubg_color', array(
		'label' => 'Active and Hover Menu BG Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_activehrvmenubrd_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_activehrvmenubrd_color', array(
		'label' => 'Active and Hover Border Menu Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_header_submenu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_submenu_color', array(
		'label' => 'Submenu Color',
		'section' => 'interior_architect_header',
	)));

	$wp_customize->add_setting( 'interior_architect_header_submenubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_header_submenubg_color', array(
		'label' => 'Submenu BG Color',
		'section' => 'interior_architect_header',
	)));




	//home page slider
	$wp_customize->add_section( 'interior_architect_slider_section' , array(
    	'title'    => __( 'Slider Settings', 'interior-architect' ),
		'priority' => null,
		'panel' => 'interior_architect_panel_id'
	) );

	$wp_customize->add_setting('interior_architect_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'interior_architect_sanitize_checkbox'
	));
	$wp_customize->add_control('interior_architect_slider_hide_show',array(
	   	'type' => 'checkbox',
	   	'label' => __('Show / Hide Slider','interior-architect'),
	   	'section' => 'interior_architect_slider_section',
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'interior_architect_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'interior_architect_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'interior_architect_slider' . $count, array(
			'label' => __('Select Slider Image Page', 'interior-architect' ),
			'section' => 'interior_architect_slider_section',
			'type' => 'dropdown-pages'
		));
	}


	$wp_customize->add_setting('interior_architect_slider_excerpt_length',array(
		'default' => '15',
		'sanitize_callback'	=> 'interior_architect_sanitize_float'
	));
	$wp_customize->add_control('interior_architect_slider_excerpt_length',array(
		'type' => 'number',
		'label' => __('Description Excerpt Length','interior-architect'),
		'section' => 'interior_architect_slider_section',
	));

	$wp_customize->add_setting( 'interior_architect_slider_heading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_heading_color', array(
		'label' => 'Heading Color',
		'section' => 'interior_architect_slider_section',
	)));

	$wp_customize->add_setting( 'interior_architect_slider_description_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_description_color', array(
		'label' => 'Description Color',
		'section' => 'interior_architect_slider_section',
	)));

	$wp_customize->add_setting( 'interior_architect_slider_btntxt_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_btntxt_color', array(
		'label' => 'Button Text Color',
		'section' => 'interior_architect_slider_section',
	)));

	$wp_customize->add_setting( 'interior_architect_slider_btnbrd_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_btnbrd_color', array(
		'label' => 'Button Border Color',
		'section' => 'interior_architect_slider_section',
	)));

	$wp_customize->add_setting( 'interior_architect_slider_btnicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_btnicon_color', array(
		'label' => 'Button Icon Color',
		'section' => 'interior_architect_slider_section',
	)));

	$wp_customize->add_setting( 'interior_architect_slider_btniconbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_btniconbg_color', array(
		'label' => 'Button Icon BG Color',
		'section' => 'interior_architect_slider_section',
	)));

	$wp_customize->add_setting( 'interior_architect_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_btnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'interior_architect_slider_section',
	)));

	$wp_customize->add_setting( 'interior_architect_slider_bg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_slider_bg_color', array(
		'label' => 'BG Color',
		'section' => 'interior_architect_slider_section',
	)));


	//banner Section
	$wp_customize->add_section('interior_architect_banner_section',array(
		'title'	=> __('Banner Section','interior-architect'),
		'description'=> __('<b>Note :</b> This section will appear below the slider.','interior-architect'),
		'panel' => 'interior_architect_panel_id',
	));


	$wp_customize->add_setting('interior_architect_bannerheading',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('interior_architect_bannerheading',array(
	   	'type' => 'text',
	   	'label' => __('Heading','interior-architect'),
	   	'section' => 'interior_architect_banner_section',
	));

	$wp_customize->add_setting( 'interior_architect_bannerhead_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_bannerhead_color', array(
		'label' => 'Header Color',
		'section' => 'interior_architect_banner_section',
	)));


	$wp_customize->add_setting('interior_architect_bannertitle',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('interior_architect_bannertitle',array(
	   	'type' => 'text',
	   	'label' => __('Title','interior-architect'),
	   	'section' => 'interior_architect_banner_section',
	));


	$wp_customize->add_setting( 'interior_architect_bannertitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_bannertitle_color', array(
		'label' => 'Title Color',
		'section' => 'interior_architect_banner_section',
	)));


	$wp_customize->add_setting('interior_architect_bannersubtitle',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('interior_architect_bannersubtitle',array(
	   	'type' => 'text',
	   	'label' => __('Sub Title','interior-architect'),
	   	'section' => 'interior_architect_banner_section',
	));

	$wp_customize->add_setting( 'interior_architect_bannersubtitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_bannersubtitle_color', array(
		'label' => 'Sub Title Color',
		'section' => 'interior_architect_banner_section',
	)));

	$wp_customize->add_setting('interior_architect_bannerdescription',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('interior_architect_bannerdescription',array(
	   	'type' => 'text',
	   	'label' => __('Description','interior-architect'),
	   	'section' => 'interior_architect_banner_section',
	));

	$wp_customize->add_setting( 'interior_architect_bannerdescription_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_bannerdescription_color', array(
		'label' => 'Description Color',
		'section' => 'interior_architect_banner_section',
	)));

	$wp_customize->add_setting( 'interior_architect_bannerdescriptionbrd_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_bannerdescriptionbrd_color', array(
		'label' => 'Border Color',
		'section' => 'interior_architect_banner_section',
	)));

	$wp_customize->add_setting( 'interior_architect_bannerheadbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_bannerheadbg_color', array(
		'label' => 'Heading BG Color',
		'section' => 'interior_architect_banner_section',
	)));

	$wp_customize->add_setting( 'interior_architect_bannercontentbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_bannercontentbg_color', array(
		'label' => 'Content BG Color',
		'section' => 'interior_architect_banner_section',
	)));




	//Service Section
	$wp_customize->add_section('interior_architect_service_section',array(
		'title'	=> __('Service Section','interior-architect'),
		'description'=> __('<b>Note :</b> This section will appear below the banner.','interior-architect'),
		'panel' => 'interior_architect_panel_id',
	));




	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_pst[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_pst[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('interior_architect_service_category_setting',array(
		'default' => 'select',
		'sanitize_callback' => 'interior_architect_sanitize_choices',
	));
	$wp_customize->add_control('interior_architect_service_category_setting',array(
		'type' => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Post','interior-architect'),
		'section' => 'interior_architect_service_section',
	));

	$wp_customize->add_setting('interior_architect_service_number',array(
		'default'	=> '6',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('interior_architect_service_number',array(
		'label'	=> __('Number Of Posts To Show In A Category','interior-architect'),
		'section' => 'interior_architect_service_section',
		'type'	  => 'number'
	));

	$interior_architect_service_number = get_theme_mod('interior_architect_service_number', 6);
	for ($i=1; $i <= $interior_architect_service_number; $i++) { 

		$wp_customize->add_setting('interior_architect_service_number'. $i,array(
			'default' => '01',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control('interior_architect_service_number'. $i,array(
			   'type' => 'text',
			   'label' => __('Number ','interior-architect') . $i,
			   'section' => 'interior_architect_service_section',
		));

	   	
	}

	
	$wp_customize->add_setting( 'interior_architect_servicetitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_servicetitle_color', array(
		'label' => 'Title Color',
		'section' => 'interior_architect_service_section',
	)));

	$wp_customize->add_setting( 'interior_architect_servicedesciption_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_servicedesciption_color', array(
		'label' => 'Description Color',
		'section' => 'interior_architect_service_section',
	)));

	$wp_customize->add_setting( 'interior_architect_servicedesciptionicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_servicedesciptionicon_color', array(
		'label' => 'Icon Color',
		'section' => 'interior_architect_service_section',
	)));

	$wp_customize->add_setting( 'interior_architect_servicenumber_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_servicenumber_color', array(
		'label' => 'Number Color',
		'section' => 'interior_architect_service_section',
	)));


	$wp_customize->add_setting( 'interior_architect_servicenumberbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_servicenumberbg_color', array(
		'label' => 'Number BG Color',
		'section' => 'interior_architect_service_section',
	)));




	//Footer
    $wp_customize->add_section( 'interior_architect_footer', array(
    	'title'  => __( 'Footer Settings', 'interior-architect' ),
		'priority' => null,
		'panel' => 'interior_architect_panel_id'
	) );

	$wp_customize->add_setting('interior_architect_show_back_totop',array(
       'default' => true,
       'sanitize_callback'	=> 'interior_architect_sanitize_checkbox'
    ));
    $wp_customize->add_control('interior_architect_show_back_totop',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Back to Top','interior-architect'),
       'section' => 'interior_architect_footer'
    ));

    $wp_customize->add_setting('interior_architect_footer_copy',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('interior_architect_footer_copy',array(
		'label'	=> __('Copyright Text','interior-architect'),
		'section' => 'interior_architect_footer',
		'setting' => 'interior_architect_footer_copy',
		'type' => 'text'
	));

	$wp_customize->add_setting( 'interior_architect_footercopyright_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_footercopyright_color', array(
		'label' => 'Copyright Color',
		'section' => 'interior_architect_footer',
	)));

	$wp_customize->add_setting( 'interior_architect_footercopyrightbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_footercopyrightbg_color', array(
		'label' => 'Copyright BG Color',
		'section' => 'interior_architect_footer',
	)));

	$wp_customize->add_setting( 'interior_architect_footertext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_footertext_color', array(
		'label' => 'Text Color',
		'section' => 'interior_architect_footer',
	)));

	$wp_customize->add_setting( 'interior_architect_footer1_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_footer1_color', array(
		'label' => 'Footer 1 BG Color',
		'section' => 'interior_architect_footer',
	)));

	$wp_customize->add_setting( 'interior_architect_footerbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'interior_architect_footerbg_color', array(
		'label' => 'BG Color',
		'section' => 'interior_architect_footer',
	)));

	

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'interior_architect_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'interior_architect_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'interior_architect_customize_register' );

function interior_architect_customize_partial_blogname() {
	bloginfo( 'name' );
}

function interior_architect_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if (class_exists('WP_Customize_Control')) {

   	class Interior_Architect_Fontawesome_Icon_Chooser extends WP_Customize_Control {

      	public $type = 'icon';

      	public function render_content() { ?>
	     	<label>
	            <span class="customize-control-title">
	               <?php echo esc_html($this->label); ?>
	            </span>

	            <?php if ($this->description) { ?>
	                <span class="description customize-control-description">
	                   <?php echo wp_kses_post($this->description); ?>
	                </span>
	            <?php } ?>

	            <div class="interior-architect-selected-icon">
	                <i class="fa <?php echo esc_attr($this->value()); ?>"></i>
	                <span><i class="fa fa-angle-down"></i></span>
	            </div>

	            <ul class="interior-architect-icon-list clearfix">
	                <?php
	                $interior_architect_font_awesome_icon_array = interior_architect_font_awesome_icon_array();
	                foreach ($interior_architect_font_awesome_icon_array as $interior_architect_font_awesome_icon) {
	                   $icon_class = $this->value() == $interior_architect_font_awesome_icon ? 'icon-active' : '';
	                   echo '<li class=' . esc_attr($icon_class) . '><i class="' . esc_attr($interior_architect_font_awesome_icon) . '"></i></li>';
	                }
	                ?>
	            </ul>
	            <input type="hidden" value="<?php $this->value(); ?>" <?php $this->link(); ?> />
	        </label>
	        <?php
      	}
  	}
}
function interior_architect_customizer_script() {
   wp_enqueue_style( 'font-awesome-1', esc_url(get_template_directory_uri()).'/assets/css/fontawesome-all.css');
}
add_action( 'customize_controls_enqueue_scripts', 'interior_architect_customizer_script' );