<?php
/**
 * The header for our theme
 *
 * @subpackage Interior Architect
 * @since 1.0
 * @version 0.1
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
} else {
    do_action( 'wp_body_open' );
}?>

<a class="screen-reader-text skip-link" href="#skip-content"><?php esc_html_e( 'Skip to content', 'interior-architect' ); ?></a>

<div id="header">
	<div class="container">
		<div class="main-header">
			<div class="row mx-0">
				<div class="col-lg-3 col-md-12 col-sm-11">
					<div class="logo text-lg-left text-center">
						<?php if ( has_custom_logo() ) : ?>
		            		<?php the_custom_logo(); ?>
			            <?php endif; ?>
		             	<?php if (get_theme_mod('interior_architect_show_site_title',true)) {?>
		          			<?php $blog_info = get_bloginfo( 'name' ); ?>
			                <?php if ( ! empty( $blog_info ) ) : ?>
			                  	<?php if ( is_front_page() && is_home() ) : ?>
			                    	<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			                  	<?php else : ?>
		                      		<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
		                  		<?php endif; ?>
			                <?php endif; ?>
			            <?php }?>
			            <?php if (get_theme_mod('interior_architect_show_tagline',true)) {?>
			                <?php $description = get_bloginfo( 'description', 'display' );
		                  	if ( $description || is_customize_preview() ) : ?>
			                  	<p class="site-description"><?php echo esc_html($description); ?></p>
		              		<?php endif; ?>
		          		<?php }?>
					</div>
				</div>
				<div class="col-lg-9 col-md-12 col-sm-12 R-hd">
					<div class="topheadmobout">
						<div class="menu-bar">
							<div class="toggle-menu responsive-menu text-md-left text-center">
								<?php if(has_nav_menu('primary')){ ?>
									<button onclick="interior_architect_open()" role="tab" class="mobile-menu"><i class="fas fa-bars"></i><span class="screen-reader-text"><?php esc_html_e('Open Menu','interior-architect'); ?></span></button>
								<?php }?>
							</div>
							<div id="sidelong-menu" class="nav sidenav">
								<nav id="primary-site-navigation" class="nav-menu" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'interior-architect' ); ?>">
									<?php if(has_nav_menu('primary')){
										wp_nav_menu( array( 
											'theme_location' => 'primary',
											'container_class' => 'main-menu-navigation clearfix' ,
											'menu_class' => 'clearfix',
											'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
											'fallback_cb' => 'wp_page_menu',
										) ); 
									} ?>
									<a href="javascript:void(0)" class="closebtn responsive-menu" onclick="interior_architect_close()"><i class="fas fa-times"></i><span class="screen-reader-text"><?php esc_html_e('Close Menu','interior-architect'); ?></span></a>
								</nav>
							</div>
						</div>
					</div>
					<div class="bottomhead">
						<div class="mobi">
							<div class="htop">
								<div class="row">
									<?php if(get_theme_mod('interior_architect_phone') != ''){ ?>
										<div class="hphone col-xl-8 col-lg-7 col-md-6 col-sm-6">
											<p><?php echo esc_html_e('Call US :','interior-architect'); ?><a href="tel:<?php echo esc_html(get_theme_mod('interior_architect_phone')); ?>"><?php echo esc_html(get_theme_mod('interior_architect_phone')); ?></a></p>
										</div>
									<?php }?>
									<div class="col-xl-4 col-lg-5 col-md-6 col-sm-6">
										<div class="share-btn">

											<?php if(get_theme_mod('interior_architect_facebook_url') != ''){?>
												<li><a href="<?php echo esc_url(get_theme_mod('interior_architect_facebook_url')) ?>"><i class="fab fa-facebook-f"></i><span class="screen-reader-text"><?php echo esc_html_e('Facebook', 'interior-architect'); ?></span></a></li>
											<?php }?>
											<?php if(get_theme_mod('interior_architect_twitter_url') != ''){?>
												<li><a href="<?php echo esc_url(get_theme_mod('interior_architect_twitter_url')) ?>"><i class="fab fa-twitter"></i><span class="screen-reader-text"><?php echo esc_html_e('Twitter', 'interior-architect'); ?></span></a></li>
											<?php }?>
											<?php if(get_theme_mod('interior_architect_instagram_url') != ''){?>
												<li><a href="<?php echo esc_url(get_theme_mod('interior_architect_instagram_url')) ?>"><i class="fab fa-instagram"></i><span class="screen-reader-text"><?php echo esc_html_e('Instagram', 'interior-architect'); ?></span></a></li>
											<?php }?>	
											<?php if(get_theme_mod('interior_architect_instagram_telegram') != ''){?>
												<li><a href="<?php echo esc_url(get_theme_mod('interior_architect_instagram_telegram')) ?>"><i class="fab fa-telegram"></i><span class="screen-reader-text"><?php echo esc_html_e('Telegram', 'interior-architect'); ?></span></a></li>
											<?php }?>	
										</div>
									</div>
								</div>
							</div>
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php if(is_singular()) {?>
	<div id="inner-pages-header">
		<div class="header-overlay"></div>
	    <div class="header-content">
		    <div class="container"> 
		      	<h1><?php single_post_title(); ?></h1>
		      	<div class="innheader-border"></div>
		      	<div class="theme-breadcrumb mt-2">
					<?php interior_architect_breadcrumb();?>
				</div>
		    </div>
		</div>
	</div>
<?php } ?>