<?php
/**
 * Title: Homepage
 * Slug: inspiro-blocks/page-front-page
 * Categories: inspiro-blocks-page
 * Viewport Width: 1280
 */
?>
<!-- wp:group {"tagName":"section","align":"full","className":"site-content is-style-default","style":{"spacing":{"margin":{"top":"0"},"padding":{"right":"0%","left":"0%"},"blockGap":"0px"}},"layout":{"type":"default"}} -->
<section class="wp-block-group alignfull site-content is-style-default" id="hero" style="margin-top:0;padding-right:0%;padding-left:0%"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ) . '/assets/video/'; ?>video.mp4","id":7174,"dimRatio":40,"backgroundType":"video","minHeightUnit":"px","contentPosition":"center center","isDark":false,"style":{"spacing":{"padding":{"top":"0px","bottom":"0px","right":"30px","left":"30px"}}}} -->
<div class="wp-block-cover is-light" style="padding-top:0px;padding-right:30px;padding-bottom:0px;padding-left:30px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-40 has-background-dim"></span><video class="wp-block-cover__video-background intrinsic-ignore" autoplay muted loop playsinline src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/video/'; ?>video.mp4" data-object-fit="cover"></video><div class="wp-block-cover__inner-container"><!-- wp:template-part {"slug":"header-transparent"} /-->

<!-- wp:spacer {"height":"25vh"} -->
<div style="height:25vh" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"className":"is-style-default","layout":{"type":"constrained","contentSize":"1000px"}} -->
<div id="hero" class="wp-block-group is-style-default"><!-- wp:spacer {"height":"4vh"} -->
<div style="height:4vh" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"white","fontSize":"max-72"} -->
<h1 class="wp-block-heading has-text-align-center has-white-color has-text-color has-max-72-font-size" style="font-style:normal;font-weight:600">Create. Amaze. Inspire</h1>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","textColor":"white","fontSize":"medium"} -->
<p class="has-text-align-center has-white-color has-text-color has-medium-font-size">Inspiro Blocks is a modern Portfolio &amp; Business WordPress Theme. You can add in this area any block you want or replace the background with an image. The video icon below can be replaced with a button.</p>
<!-- /wp:paragraph -->

<!-- wp:wpzoom-video-popup-block/block {"source":"local","url":"<?php echo esc_url( get_theme_file_uri() ) . '/assets/video/'; ?>video.mp4","libraryId":52,"text":"","icon":2,"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}},"textColor":"white","fontSize":"max-36"} -->
<a class="wp-block-wpzoom-video-popup-block-block wpzoom-video-popup-block has-white-color has-text-color has-max-36-font-size" href="<?php echo esc_url( get_theme_file_uri() ) . '/assets/video/'; ?>video.mp4" style="font-style:normal;font-weight:300"><span class="wpzoom-video-popup-block_icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" aria-hidden="true"><path d="m14.25 10.367c-1-0.57778-2.2504 0.14388-2.2504 1.2988v8.6674c0 1.155 1.2504 1.8766 2.2504 1.2988l8.2498-4.7666c0.3094-0.1786 0.4998-0.5088 0.4998-0.86588 0-0.35714-0.1904-0.68718-0.4998-0.86586zm-14.25 5.6326c0-8.8366 7.1634-16 16-16 8.8366 0 16 7.1634 16 16 0 8.8366-7.1634 16-16 16-8.8366 0-16-7.1634-16-16zm16-14c-7.732 0-14 6.268-14 14 0 7.732 6.268 14 14 14 7.732 0 14-6.268 14-14 0-7.732-6.268-14-14-14z" fill="currentColor"></path></svg></span></a>
<!-- /wp:wpzoom-video-popup-block/block -->

<!-- wp:spacer {"height":"5vh"} -->
<div style="height:5vh" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"25vh"} -->
<div style="height:25vh" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div></div>
<!-- /wp:cover --></section>
<!-- /wp:group -->

<!-- wp:group {"tagName":"main","align":"full","className":"pattern_multiple_covers","layout":{"type":"constrained","contentSize":"1200px"}} -->
<main class="wp-block-group alignfull pattern_multiple_covers" id="content"><!-- wp:spacer {"height":"46px"} -->
<div style="height:46px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|small","bottom":"var:preset|spacing|small","right":"0","left":"0"}}},"layout":{"type":"constrained","contentSize":"950px","justifyContent":"left"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--small);padding-right:0;padding-bottom:var(--wp--preset--spacing--small);padding-left:0"><!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"max-36"} -->
<h2 class="wp-block-heading has-text-align-left has-max-36-font-size" style="font-style:normal;font-weight:600">Experience the Future of WordPress with Inspiro</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left"} -->
<p class="has-text-align-left">Inspiro Blocks is a block theme that supports the new Full Site Editor. The theme includes unique page templates, block patterns, and color styles that can be customized to create a beautiful website. The modern and minimalist design is perfect for videographers, photographers, creatives, and small businesses. Inspiro Blocks includes video and portfolio integration, which makes it easy for users to showcase their work and create a professional portfolio website.</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline","style":{"border":{"radius":"0px"}}} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#" style="border-radius:0px">ABOUT US</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->

<!-- wp:spacer {"height":"46px"} -->
<div style="height:46px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></main>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"portfolio-dark","style":{"spacing":{"margin":{"top":"0px"}}},"backgroundColor":"secondary","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull portfolio-dark has-secondary-background-color has-background" id="portfolio" style="margin-top:0px"><!-- wp:spacer {"height":"122px"} -->
<div style="height:122px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:paragraph {"align":"left","style":{"typography":{"letterSpacing":"1px"}},"textColor":"primary"} -->
<p class="has-text-align-left has-primary-color has-text-color" style="letter-spacing:1px">FROM THE PORTFOLIO</p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"left","level":3,"textColor":"white","fontSize":"max-48"} -->
<h3 class="wp-block-heading has-text-align-left has-white-color has-text-color has-max-48-font-size">Our Work</h3>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"44px"} -->
<div style="height:44px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:wpzoom-blocks/portfolio {"align":"full","showCategoryFilter":false} /-->

<!-- wp:spacer {"height":"50px"} -->
<div style="height:50px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"pattern_multiple_covers","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull pattern_multiple_covers" id="services"><!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:paragraph {"align":"left","style":{"typography":{"letterSpacing":"1px"}},"textColor":"primary"} -->
<p class="has-text-align-left has-primary-color has-text-color" style="letter-spacing:1px">LET'S WORK TOGETHER!</p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"left","fontSize":"max-48"} -->
<h2 class="wp-block-heading has-text-align-left has-max-48-font-size">Our Services</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left"} -->
<p class="has-text-align-left">Inspiro is the perfect solution to create a beautiful website for your portfolio or your business. If you’re looking to create a captivating presence online, then you’ve found the right tool. The theme is easy to manage, with a drag-and-drop interface and fully customizable using the Theme Customizer.</p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"46px"} -->
<div style="height:46px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}}} -->
<div class="wp-block-column" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_356BERTH29.jpg","id":7392,"dimRatio":70,"overlayColor":"secondary","isUserOverlayColor":true,"contentPosition":"bottom left","style":{"spacing":{"padding":{"top":"var:preset|spacing|small","right":"var:preset|spacing|small","bottom":"var:preset|spacing|small","left":"var:preset|spacing|small"}}}} -->
<div class="wp-block-cover has-custom-content-position is-position-bottom-left" style="padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--small)"><span aria-hidden="true" class="wp-block-cover__background has-secondary-background-color has-background-dim-70 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-7392" alt="" src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_356BERTH29.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"left":"0","top":"0","right":"0","bottom":"0"}}},"textColor":"white","fontSize":"max-36"} -->
<h3 class="wp-block-heading has-white-color has-text-color has-max-36-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">Video<br>Production</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"left":"0","top":"0","right":"0","bottom":"0"}}}} -->
<p style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0"><a href="#">Explore more →</a></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}}} -->
<div class="wp-block-column" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_KV0WLH355C.jpg","id":7394,"dimRatio":70,"overlayColor":"secondary","isUserOverlayColor":true,"contentPosition":"bottom left","style":{"spacing":{"padding":{"top":"var:preset|spacing|small","right":"var:preset|spacing|small","bottom":"var:preset|spacing|small","left":"var:preset|spacing|small"}}}} -->
<div class="wp-block-cover has-custom-content-position is-position-bottom-left" style="padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--small)"><span aria-hidden="true" class="wp-block-cover__background has-secondary-background-color has-background-dim-70 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-7394" alt="" src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_KV0WLH355C.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"left":"0","top":"0","right":"0","bottom":"0"}}},"textColor":"white","fontSize":"max-36"} -->
<h3 class="wp-block-heading has-white-color has-text-color has-max-36-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">Professional<br>Editing</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"left":"0","top":"0","right":"0","bottom":"0"}}}} -->
<p style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0"><a href="#">Explore more →</a></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}}} -->
<div class="wp-block-column" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_P9QYJ8AAL8.jpg","id":7497,"dimRatio":70,"overlayColor":"secondary","isUserOverlayColor":true,"contentPosition":"bottom left","style":{"spacing":{"padding":{"top":"var:preset|spacing|small","right":"var:preset|spacing|small","bottom":"var:preset|spacing|small","left":"var:preset|spacing|small"}}}} -->
<div class="wp-block-cover has-custom-content-position is-position-bottom-left" style="padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--small)"><span aria-hidden="true" class="wp-block-cover__background has-secondary-background-color has-background-dim-70 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-7497" alt="" src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_P9QYJ8AAL8.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"left":"0","top":"0","right":"0","bottom":"0"}}},"textColor":"white","fontSize":"max-36"} -->
<h3 class="wp-block-heading has-white-color has-text-color has-max-36-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">Aerial<br>Video</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"left":"0","top":"0","right":"0","bottom":"0"}}}} -->
<p style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0"><a href="#">Explore more →</a></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"88px"} -->
<div style="height:88px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","layout":{"type":"constrained","contentSize":"1200px"}} -->
<div class="wp-block-group alignfull" id="cover"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_6O7JXC5DC5.jpg","id":7391,"dimRatio":60,"minHeight":549,"minHeightUnit":"px","customGradient":"linear-gradient(180deg,rgba(255,255,255,0) 14%,rgb(0,0,0) 83%)","contentPosition":"center center","align":"full"} -->
<div class="wp-block-cover alignfull" style="min-height:549px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-60 has-background-dim wp-block-cover__gradient-background has-background-gradient" style="background:linear-gradient(180deg,rgba(255,255,255,0) 14%,rgb(0,0,0) 83%)"></span><img class="wp-block-cover__image-background wp-image-7391" alt="" src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>StockSnap_6O7JXC5DC5.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"layout":{"type":"constrained","contentSize":"1200px"}} -->
<div class="wp-block-group"><!-- wp:spacer {"height":"88px"} -->
<div style="height:88px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"level":3,"textColor":"white","fontSize":"max-48"} -->
<h3 class="wp-block-heading has-white-color has-text-color has-max-48-font-size">Why us?</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"white"} -->
<p class="has-white-color has-text-color">This is some dummy copy. You’re not really <br>supposed to read this dummy copy.</p>
<!-- /wp:paragraph -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"textColor":"white","className":"is-style-outline","style":{"border":{"radius":"0px"},"typography":{"textTransform":"uppercase"}}} -->
<div class="wp-block-button is-style-outline" style="text-transform:uppercase"><a class="wp-block-button__link has-white-color has-text-color wp-element-button" style="border-radius:0px">Learn More</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->

<!-- wp:spacer {"height":"63px"} -->
<div style="height:63px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div id="team" class="wp-block-group"><!-- wp:group {"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:spacer {"height":"74px"} -->
<div style="height:74px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"fontSize":"max-48"} -->
<h2 class="wp-block-heading has-max-48-font-size">Our Team</h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"47px"} -->
<div style="height:47px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:spacer {"height":"0px"} -->
<div style="height:0px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"className":"is-style-default","style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}},"border":{"width":"0px","style":"none"}}} -->
<div class="wp-block-column is-style-default" style="border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":7403,"sizeSlug":"full","linkDestination":"none","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>team1.png" alt="" class="wp-image-7403"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading">Cynthia Howery</h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Co-founder / CEO</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type.</p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"iconColor":"primary","iconColorValue":"currentColor","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|x-small","left":"var:preset|spacing|x-small"}}},"layout":{"type":"flex","flexWrap":"wrap"}} -->
<ul class="wp-block-social-links has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"#","service":"instagram"} /-->

<!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"is-style-default","style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}},"border":{"width":"0px","style":"none"}}} -->
<div class="wp-block-column is-style-default" style="border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":7404,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>team2.png" alt="" class="wp-image-7404"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading">Jimmy Banh</h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>LEAD DESIGNER</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type.</p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"iconColor":"primary","iconColorValue":"currentColor","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|x-small","left":"var:preset|spacing|x-small"}}}} -->
<ul class="wp-block-social-links has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"#","service":"linkedin"} /-->

<!-- wp:social-link {"service":"x"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"is-style-default","style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"}},"border":{"width":"0px","style":"none"}}} -->
<div class="wp-block-column is-style-default" style="border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":7405,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>team3.png" alt="" class="wp-image-7405"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading">Leah Palmieri</h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>CFO</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type.</p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"iconColor":"primary","iconColorValue":"currentColor","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|x-small","left":"var:preset|spacing|x-small"}}}} -->
<ul class="wp-block-social-links has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"#","service":"instagram"} /-->

<!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"63px"} -->
<div style="height:63px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline","style":{"border":{"radius":"0px"}}} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#" style="border-radius:0px">VIEW ALL</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->

<!-- wp:spacer {"height":"44px"} -->
<div style="height:44px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","backgroundColor":"secondary","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull has-secondary-background-color has-background" id="testimonial"><!-- wp:spacer {"height":"151px"} -->
<div style="height:151px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:image {"id":6029,"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"0px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>Rectangle-43.png" alt="" class="wp-image-6029" style="border-radius:0px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"5px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:5px"></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"70%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:70%"><!-- wp:outermost/icon-block {"iconName":"","width":66} -->
<div class="wp-block-outermost-icon-block"><div class="icon-container" style="width:66px"><svg width="73" height="50" viewBox="0 0 73 50" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M50 22.7273H63.6364V9.09091H50V22.7273ZM9.09091 22.7273H22.7273V9.09091H9.09091V22.7273ZM59.8864 50C57.6136 50 55.8712 49.0349 54.6591 47.1045C53.447 45.1712 53.3712 43.1818 54.4318 41.1364L59.0909 31.8182H50C47.5 31.8182 45.3606 30.9273 43.5818 29.1455C41.8 27.3667 40.9091 25.2273 40.9091 22.7273V9.09091C40.9091 6.59091 41.8 4.45151 43.5818 2.67273C45.3606 0.890908 47.5 0 50 0H63.6364C66.1364 0 68.2773 0.890908 70.0591 2.67273C71.8379 4.45151 72.7273 6.59091 72.7273 9.09091V29.6591C72.7273 30.3409 72.6697 31.0424 72.5545 31.7636C72.4424 32.4818 72.197 33.1439 71.8182 33.75L65.3409 46.5909C64.8106 47.6515 64.053 48.4848 63.0682 49.0909C62.0833 49.697 61.0227 50 59.8864 50ZM18.9773 50C16.7045 50 14.9621 49.0349 13.75 47.1045C12.5379 45.1712 12.4621 43.1818 13.5227 41.1364L18.1818 31.8182H9.09091C6.59091 31.8182 4.45151 30.9273 2.67273 29.1455C0.890908 27.3667 0 25.2273 0 22.7273V9.09091C0 6.59091 0.890908 4.45151 2.67273 2.67273C4.45151 0.890908 6.59091 0 9.09091 0H22.7273C25.2273 0 27.3682 0.890908 29.15 2.67273C30.9288 4.45151 31.8182 6.59091 31.8182 9.09091V29.6591C31.8182 30.3409 31.7621 31.0424 31.65 31.7636C31.5348 32.4818 31.2879 33.1439 30.9091 33.75L24.4318 46.5909C23.9015 47.6515 23.1439 48.4848 22.1591 49.0909C21.1742 49.697 20.1136 50 18.9773 50Z" fill="var(--wp--preset--color--primary)"></path></svg></div></div>
<!-- /wp:outermost/icon-block -->

<!-- wp:spacer {"height":"85px"} -->
<div style="height:85px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"textAlign":"left","textColor":"white","fontSize":"max-36"} -->
<h2 class="wp-block-heading has-text-align-left has-white-color has-text-color has-max-36-font-size">Metus vulputate eu scelerisque felis imperdiet proin fermentum leo. Adipiscing enim eu turpis egestas pretium aenean pharetra.</h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"59px"} -->
<div style="height:59px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:paragraph {"align":"right","fontSize":"medium"} -->
<p class="has-text-align-right has-medium-font-size"><strong>Eva Lester</strong><br>Senior Supervisors ・ Fables</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"152px"} -->
<div style="height:152px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div id="news" class="wp-block-group"><!-- wp:spacer {"height":"151px"} -->
<div style="height:151px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:paragraph {"align":"left","textColor":"primary"} -->
<p class="has-text-align-left has-primary-color has-text-color">FROM THE BLOG</p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"left","fontSize":"max-48"} -->
<h2 class="wp-block-heading has-text-align-left has-max-48-font-size">News</h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"46px"} -->
<div style="height:46px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:query {"queryId":4,"query":{"perPage":"6","pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->
<div class="wp-block-query"><!-- wp:post-template {"layout":{"type":"default","columnCount":2}} -->
<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|x-small"}}}} -->
<div class="wp-block-columns are-vertically-aligned-center" style="padding-bottom:var(--wp--preset--spacing--x-small)"><!-- wp:column {"verticalAlignment":"center","width":"20%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:20%"><!-- wp:post-date /--></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"60%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:60%"><!-- wp:post-title {"level":3,"isLink":true,"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"max-36"} /--></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"10%","className":"wpz-hide-mobile"} -->
<div class="wp-block-column is-vertically-aligned-center wpz-hide-mobile" style="flex-basis:10%"><!-- wp:outermost/icon-block {"iconName":"","itemsJustification":"right","linkUrl":"#"} -->
<div class="wp-block-outermost-icon-block items-justified-right"><a class="icon-container" href="#" style="width:48px"><svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M42.0635 13.4921L6.84524 48.8095C6.05159 49.6032 5.10847 50 4.01587 50C2.92593 50 1.98413 49.6032 1.19047 48.8095C0.396824 48.0159 0 47.0727 0 45.9802C0 44.8902 0.396824 43.9484 1.19047 43.1548L36.5079 7.93651H6.34921C5.22487 7.93651 4.28175 7.55688 3.51984 6.79762C2.76058 6.03571 2.38095 5.09259 2.38095 3.96825C2.38095 2.84392 2.76058 1.90079 3.51984 1.13889C4.28175 0.37963 5.22487 0 6.34921 0H46.0317C47.1561 0 48.0979 0.37963 48.8571 1.13889C49.619 1.90079 50 2.84392 50 3.96825V43.6508C50 44.7751 49.619 45.7169 48.8571 46.4762C48.0979 47.2381 47.1561 47.619 46.0317 47.619C44.9074 47.619 43.9656 47.2381 43.2063 46.4762C42.4444 45.7169 42.0635 44.7751 42.0635 43.6508V13.4921Z" fill="currentColor"></path></svg></a></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:separator {"className":"is-style-wide","backgroundColor":"lightgrey"} -->
<hr class="wp-block-separator has-text-color has-lightgrey-color has-alpha-channel-opacity has-lightgrey-background-color has-background is-style-wide"/>
<!-- /wp:separator -->
<!-- /wp:post-template --></div>
<!-- /wp:query -->

<!-- wp:spacer {"height":"115px"} -->
<div style="height:115px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"67px"} -->
<div style="height:67px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div id="location" class="wp-block-group"><!-- wp:group {"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"align":"left","textColor":"primary"} -->
<p class="has-text-align-left has-primary-color has-text-color">WHERE ARE WE LOCATED</p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"left","fontSize":"max-48"} -->
<h2 class="wp-block-heading has-text-align-left has-max-48-font-size">Our Location</h2>
<!-- /wp:heading -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"2.5"}}} -->
<p style="line-height:2.5">Amsterdam<br>Munich<br>Brussels<br>Hong Kong<br>Barcelona</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"2.5"}}} -->
<p style="line-height:2.5">New York<br>Paris<br>San Francisco<br>Sydney<br>Tokyo</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":5640,"sizeSlug":"large","linkDestination":"none"} -->
<figure class="wp-block-image size-large"><img src="<?php echo esc_url( get_theme_file_uri() ) . '/assets/images/'; ?>map.png" alt="" class="wp-image-5640"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:separator {"className":"is-style-wide","backgroundColor":"lightgrey"} -->
<hr class="wp-block-separator has-text-color has-lightgrey-color has-alpha-channel-opacity has-lightgrey-background-color has-background is-style-wide"/>
<!-- /wp:separator -->

<!-- wp:columns {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","left":"0","bottom":"var:preset|spacing|60"}}}} -->
<div class="wp-block-columns" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:0"><!-- wp:column {"verticalAlignment":"center","width":"66.66%","layout":{"type":"constrained","justifyContent":"left"}} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:66.66%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading">Thinking about joining our team?</h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Check out our open positions, or drop us a line, say hi.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.33%"} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"right"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-fill","style":{"border":{"radius":"0px"},"typography":{"textTransform":"uppercase"}}} -->
<div class="wp-block-button is-style-fill" style="text-transform:uppercase"><a class="wp-block-button__link wp-element-button" style="border-radius:0px">View Job Openings</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"is-style-default","style":{"spacing":{"padding":{"top":"40px","bottom":"40px"},"margin":{"top":"0px"}},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"backgroundColor":"header-footer","textColor":"white","fontSize":"small","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull is-style-default has-white-color has-header-footer-background-color has-text-color has-background has-link-color has-small-font-size" id="social-cta" style="margin-top:0px;padding-top:40px;padding-bottom:40px"><!-- wp:spacer {"height":"39px"} -->
<div style="height:39px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"textAlign":"left","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}}},"textColor":"white","fontSize":"max-48"} -->
<h2 class="wp-block-heading has-text-align-left has-white-color has-text-color has-max-48-font-size" style="margin-bottom:var(--wp--preset--spacing--50)">Let's connect!</h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"39px"} -->
<div style="height:39px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false} -->
<div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"42px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:42px"><!-- wp:outermost/icon-block {"iconName":"","width":36} -->
<div class="wp-block-outermost-icon-block"><div class="icon-container" style="width:36px"><svg width="43" height="50" viewBox="0 0 43 50" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M22.5 50L21.875 42.5H21.25C15.3333 42.5 10.3125 40.4375 6.1875 36.3125C2.0625 32.1875 0 27.1667 0 21.25C0 15.3333 2.0625 10.3125 6.1875 6.1875C10.3125 2.0625 15.3333 0 21.25 0C24.2083 0 26.9683 0.551667 29.53 1.655C32.0933 2.76 34.3442 4.28083 36.2825 6.2175C38.2192 8.15583 39.7392 10.4058 40.8425 12.9675C41.9475 15.5308 42.5 18.2917 42.5 21.25C42.5 24.375 41.99 27.375 40.97 30.25C39.9483 33.125 38.5525 35.7917 36.7825 38.25C35.0108 40.7083 32.9067 42.9375 30.47 44.9375C28.0317 46.9375 25.375 48.625 22.5 50ZM27.5 40.875C30.4583 38.375 32.8642 35.4483 34.7175 32.095C36.5725 28.74 37.5 25.125 37.5 21.25C37.5 16.7083 35.9275 12.8642 32.7825 9.7175C29.6358 6.5725 25.7917 5 21.25 5C16.7083 5 12.865 6.5725 9.72 9.7175C6.57333 12.8642 5 16.7083 5 21.25C5 25.7917 6.57333 29.6358 9.72 32.7825C12.865 35.9275 16.7083 37.5 21.25 37.5H27.5V40.875ZM21.1875 34.9375C21.8958 34.9375 22.5 34.6875 23 34.1875C23.5 33.6875 23.75 33.0833 23.75 32.375C23.75 31.6667 23.5 31.0625 23 30.5625C22.5 30.0625 21.8958 29.8125 21.1875 29.8125C20.4792 29.8125 19.875 30.0625 19.375 30.5625C18.875 31.0625 18.625 31.6667 18.625 32.375C18.625 33.0833 18.875 33.6875 19.375 34.1875C19.875 34.6875 20.4792 34.9375 21.1875 34.9375ZM19.375 27H23.125C23.125 25.75 23.25 24.875 23.5 24.375C23.75 23.875 24.5417 22.9583 25.875 21.625C26.625 20.875 27.25 20.0625 27.75 19.1875C28.25 18.3125 28.5 17.375 28.5 16.375C28.5 14.25 27.7817 12.6558 26.345 11.5925C24.9067 10.5308 23.2083 10 21.25 10C19.4167 10 17.875 10.51 16.625 11.53C15.375 12.5517 14.5 13.7917 14 15.25L17.5 16.625C17.7083 15.9167 18.1042 15.2183 18.6875 14.53C19.2708 13.8433 20.125 13.5 21.25 13.5C22.375 13.5 23.2192 13.8125 23.7825 14.4375C24.3442 15.0625 24.625 15.75 24.625 16.5C24.625 17.2083 24.4167 17.8433 24 18.405C23.5833 18.9683 23.0833 19.5417 22.5 20.125C21.0417 21.375 20.1567 22.3642 19.845 23.0925C19.5317 23.8225 19.375 25.125 19.375 27Z" fill="var(--wp--preset--color--primary)"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":""} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><a href="#">Contact us</a></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"40px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40px"><!-- wp:outermost/icon-block {"iconName":"","itemsJustification":"right","width":22} -->
<div class="wp-block-outermost-icon-block items-justified-right"><div class="icon-container" style="width:22px"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.1905 6.47619L3.28571 23.4286C2.90476 23.8095 2.45206 24 1.92762 24C1.40444 24 0.95238 23.8095 0.571428 23.4286C0.190476 23.0476 0 22.5949 0 22.0705C0 21.5473 0.190476 21.0952 0.571428 20.7143L17.5238 3.80952H3.04762C2.50794 3.80952 2.05524 3.6273 1.68952 3.26286C1.32508 2.89714 1.14286 2.44444 1.14286 1.90476C1.14286 1.36508 1.32508 0.912381 1.68952 0.546667C2.05524 0.182223 2.50794 0 3.04762 0H22.0952C22.6349 0 23.087 0.182223 23.4514 0.546667C23.8171 0.912381 24 1.36508 24 1.90476V20.9524C24 21.4921 23.8171 21.9441 23.4514 22.3086C23.087 22.6743 22.6349 22.8571 22.0952 22.8571C21.5556 22.8571 21.1035 22.6743 20.739 22.3086C20.3733 21.9441 20.1905 21.4921 20.1905 20.9524V6.47619Z" fill="#EDEDED"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:separator {"className":"is-style-wide wpz-hide-mobile","backgroundColor":"tertiary"} -->
<hr class="wp-block-separator has-text-color has-tertiary-color has-alpha-channel-opacity has-tertiary-background-color has-background is-style-wide wpz-hide-mobile"/>
<!-- /wp:separator --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false} -->
<div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"42px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:42px"><!-- wp:outermost/icon-block {"iconName":"","width":36} -->
<div class="wp-block-outermost-icon-block"><div class="icon-container" style="width:36px"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" aria-hidden="true"><path d="m14.25 10.367c-1-0.57778-2.2504 0.14388-2.2504 1.2988v8.6674c0 1.155 1.2504 1.8766 2.2504 1.2988l8.2498-4.7666c0.3094-0.1786 0.4998-0.5088 0.4998-0.86588 0-0.35714-0.1904-0.68718-0.4998-0.86586zm-14.25 5.6326c0-8.8366 7.1634-16 16-16 8.8366 0 16 7.1634 16 16 0 8.8366-7.1634 16-16 16-8.8366 0-16-7.1634-16-16zm16-14c-7.732 0-14 6.268-14 14 0 7.732 6.268 14 14 14 7.732 0 14-6.268 14-14 0-7.732-6.268-14-14-14z" fill="var(--wp--preset--color--primary)"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":""} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><a href="#">Showreel</a></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"40px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40px"><!-- wp:outermost/icon-block {"iconName":"","itemsJustification":"right","width":22} -->
<div class="wp-block-outermost-icon-block items-justified-right"><div class="icon-container" style="width:22px"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.1905 6.47619L3.28571 23.4286C2.90476 23.8095 2.45206 24 1.92762 24C1.40444 24 0.95238 23.8095 0.571428 23.4286C0.190476 23.0476 0 22.5949 0 22.0705C0 21.5473 0.190476 21.0952 0.571428 20.7143L17.5238 3.80952H3.04762C2.50794 3.80952 2.05524 3.6273 1.68952 3.26286C1.32508 2.89714 1.14286 2.44444 1.14286 1.90476C1.14286 1.36508 1.32508 0.912381 1.68952 0.546667C2.05524 0.182223 2.50794 0 3.04762 0H22.0952C22.6349 0 23.087 0.182223 23.4514 0.546667C23.8171 0.912381 24 1.36508 24 1.90476V20.9524C24 21.4921 23.8171 21.9441 23.4514 22.3086C23.087 22.6743 22.6349 22.8571 22.0952 22.8571C21.5556 22.8571 21.1035 22.6743 20.739 22.3086C20.3733 21.9441 20.1905 21.4921 20.1905 20.9524V6.47619Z" fill="#EDEDED"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:separator {"className":"is-style-wide wpz-hide-mobile","backgroundColor":"tertiary"} -->
<hr class="wp-block-separator has-text-color has-tertiary-color has-alpha-channel-opacity has-tertiary-background-color has-background is-style-wide wpz-hide-mobile"/>
<!-- /wp:separator --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false} -->
<div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"42px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:42px"><!-- wp:outermost/icon-block {"iconName":"","iconColor":"primary","iconColorValue":"#40916C","hasNoIconFill":true,"width":36} -->
<div class="wp-block-outermost-icon-block"><div class="icon-container has-icon-color has-no-icon-fill-color has-primary-color" style="color:#40916C;width:36px"><svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M42.503 7.26888C40.2107 4.95538 37.4809 3.12122 34.4727 1.87329C31.4645 0.625358 28.238 -0.0113883 24.9812 0.000154157C11.3343 0.000154157 0.212499 11.1189 0.199999 24.7688C0.199999 29.1407 1.34375 33.3938 3.50311 37.1594L0 50L13.1375 46.5563C16.7718 48.5341 20.8435 49.5708 24.9812 49.5719H24.9937C38.6436 49.5719 49.7623 38.4532 49.7748 24.7907C49.778 21.5346 49.1368 18.3101 47.8882 15.3029C46.6396 12.2956 44.8083 9.56522 42.4999 7.26888H42.503ZM24.9812 45.3781C21.2906 45.3794 17.6678 44.3862 14.4937 42.5031L13.7437 42.0531L5.94998 44.0969L8.03123 36.4938L7.54373 35.7094C5.48063 32.4292 4.38951 28.6314 4.39686 24.7563C4.39686 13.4251 13.6375 4.18139 24.9937 4.18139C27.6991 4.17654 30.3787 4.70725 32.8781 5.74292C35.3774 6.7786 37.6471 8.29875 39.5561 10.2157C41.4718 12.1253 42.9906 14.3952 44.0246 16.8946C45.0587 19.394 45.5877 22.0734 45.5811 24.7782C45.5686 36.15 36.328 45.3781 24.9812 45.3781ZM36.278 29.9594C35.6624 29.6501 32.6218 28.1532 32.0499 27.9407C31.4812 27.7376 31.0655 27.6313 30.6593 28.2501C30.2437 28.8657 29.0562 30.2688 28.6999 30.6719C28.3437 31.0876 27.9749 31.1344 27.3562 30.8282C26.7405 30.5157 24.7437 29.8657 22.3812 27.7501C20.5374 26.1094 19.3031 24.0782 18.9343 23.4626C18.5781 22.8438 18.8999 22.5126 19.2093 22.2032C19.4812 21.9282 19.8249 21.4782 20.1343 21.122C20.4468 20.7657 20.5499 20.5032 20.7531 20.0907C20.9562 19.672 20.8593 19.3157 20.7062 19.0063C20.5499 18.697 19.3156 15.6439 18.7937 14.4126C18.2937 13.197 17.7843 13.3657 17.4031 13.3501C17.0468 13.3282 16.6312 13.3282 16.2156 13.3282C15.9017 13.336 15.5928 13.4086 15.3084 13.5415C15.0239 13.6743 14.7699 13.8645 14.5625 14.1001C13.9937 14.7189 12.4031 16.2157 12.4031 19.2688C12.4031 22.322 14.6218 25.2563 14.9343 25.6719C15.2406 26.0876 19.2906 32.3344 25.5062 35.0219C26.9749 35.6625 28.1312 36.0407 29.0343 36.3282C30.5187 36.8032 31.8593 36.7313 32.928 36.5782C34.1155 36.3969 36.5874 35.0782 37.1093 33.6313C37.6218 32.1813 37.6218 30.9438 37.4655 30.6844C37.3124 30.4219 36.8968 30.2688 36.278 29.9594Z" fill="var(--wp--preset--color--primary)"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":""} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><a href="#">WhatsApp</a></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"40px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40px"><!-- wp:outermost/icon-block {"iconName":"","itemsJustification":"right","width":22} -->
<div class="wp-block-outermost-icon-block items-justified-right"><div class="icon-container" style="width:22px"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.1905 6.47619L3.28571 23.4286C2.90476 23.8095 2.45206 24 1.92762 24C1.40444 24 0.95238 23.8095 0.571428 23.4286C0.190476 23.0476 0 22.5949 0 22.0705C0 21.5473 0.190476 21.0952 0.571428 20.7143L17.5238 3.80952H3.04762C2.50794 3.80952 2.05524 3.6273 1.68952 3.26286C1.32508 2.89714 1.14286 2.44444 1.14286 1.90476C1.14286 1.36508 1.32508 0.912381 1.68952 0.546667C2.05524 0.182223 2.50794 0 3.04762 0H22.0952C22.6349 0 23.087 0.182223 23.4514 0.546667C23.8171 0.912381 24 1.36508 24 1.90476V20.9524C24 21.4921 23.8171 21.9441 23.4514 22.3086C23.087 22.6743 22.6349 22.8571 22.0952 22.8571C21.5556 22.8571 21.1035 22.6743 20.739 22.3086C20.3733 21.9441 20.1905 21.4921 20.1905 20.9524V6.47619Z" fill="#EDEDED"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:separator {"className":"is-style-wide wpz-hide-mobile","backgroundColor":"tertiary"} -->
<hr class="wp-block-separator has-text-color has-tertiary-color has-alpha-channel-opacity has-tertiary-background-color has-background is-style-wide wpz-hide-mobile"/>
<!-- /wp:separator --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false} -->
<div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"42px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:42px"><!-- wp:outermost/icon-block {"iconName":"","width":36} -->
<div class="wp-block-outermost-icon-block"><div class="icon-container" style="width:36px"><svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title></title><path d="M23.9765 6.4168c-.105 2.338-1.739 5.5429-4.894 9.6088-3.2679 4.247-6.0258 6.3699-8.2898 6.3699-1.409 0-2.578-1.294-3.553-3.881l-1.9179-7.1138c-.719-2.584-1.488-3.878-2.312-3.878-.179 0-.806.378-1.8809 1.132l-1.129-1.457a315.06 315.06 0 003.501-3.1279c1.579-1.368 2.765-2.085 3.5539-2.159 1.867-.18 3.016 1.1 3.447 3.838.465 2.953.789 4.789.971 5.5069.5389 2.45 1.1309 3.674 1.7759 3.674.502 0 1.256-.796 2.265-2.385 1.004-1.589 1.54-2.797 1.612-3.628.144-1.371-.395-2.061-1.614-2.061-.574 0-1.167.121-1.777.391 1.186-3.8679 3.434-5.7568 6.7619-5.6368 2.4729.06 3.6279 1.664 3.4929 4.7969z" fill="var(--wp--preset--color--primary)"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":""} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><a href="#">Vimeo</a></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"40px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40px"><!-- wp:outermost/icon-block {"iconName":"","itemsJustification":"right","width":22} -->
<div class="wp-block-outermost-icon-block items-justified-right"><div class="icon-container" style="width:22px"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.1905 6.47619L3.28571 23.4286C2.90476 23.8095 2.45206 24 1.92762 24C1.40444 24 0.95238 23.8095 0.571428 23.4286C0.190476 23.0476 0 22.5949 0 22.0705C0 21.5473 0.190476 21.0952 0.571428 20.7143L17.5238 3.80952H3.04762C2.50794 3.80952 2.05524 3.6273 1.68952 3.26286C1.32508 2.89714 1.14286 2.44444 1.14286 1.90476C1.14286 1.36508 1.32508 0.912381 1.68952 0.546667C2.05524 0.182223 2.50794 0 3.04762 0H22.0952C22.6349 0 23.087 0.182223 23.4514 0.546667C23.8171 0.912381 24 1.36508 24 1.90476V20.9524C24 21.4921 23.8171 21.9441 23.4514 22.3086C23.087 22.6743 22.6349 22.8571 22.0952 22.8571C21.5556 22.8571 21.1035 22.6743 20.739 22.3086C20.3733 21.9441 20.1905 21.4921 20.1905 20.9524V6.47619Z" fill="#EDEDED"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false} -->
<div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"42px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:42px"><!-- wp:outermost/icon-block {"iconName":"","width":36} -->
<div class="wp-block-outermost-icon-block"><div class="icon-container" style="width:36px"><svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title></title><path d="M18.901 1.153h3.68l-8.04 9.19L24 22.846h-7.406l-5.8-7.584-6.638 7.584H.474l8.6-9.83L0 1.154h7.594l5.243 6.932ZM17.61 20.644h2.039L6.486 3.24H4.298Z" fill="var(--wp--preset--color--primary)"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":""} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><a href="#">X</a></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"40px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40px"><!-- wp:outermost/icon-block {"iconName":"","itemsJustification":"right","width":22} -->
<div class="wp-block-outermost-icon-block items-justified-right"><div class="icon-container" style="width:22px"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.1905 6.47619L3.28571 23.4286C2.90476 23.8095 2.45206 24 1.92762 24C1.40444 24 0.95238 23.8095 0.571428 23.4286C0.190476 23.0476 0 22.5949 0 22.0705C0 21.5473 0.190476 21.0952 0.571428 20.7143L17.5238 3.80952H3.04762C2.50794 3.80952 2.05524 3.6273 1.68952 3.26286C1.32508 2.89714 1.14286 2.44444 1.14286 1.90476C1.14286 1.36508 1.32508 0.912381 1.68952 0.546667C2.05524 0.182223 2.50794 0 3.04762 0H22.0952C22.6349 0 23.087 0.182223 23.4514 0.546667C23.8171 0.912381 24 1.36508 24 1.90476V20.9524C24 21.4921 23.8171 21.9441 23.4514 22.3086C23.087 22.6743 22.6349 22.8571 22.0952 22.8571C21.5556 22.8571 21.1035 22.6743 20.739 22.3086C20.3733 21.9441 20.1905 21.4921 20.1905 20.9524V6.47619Z" fill="#EDEDED"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false} -->
<div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"42px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:42px"><!-- wp:outermost/icon-block {"iconName":"","width":36} -->
<div class="wp-block-outermost-icon-block"><div class="icon-container" style="width:36px"><svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M14.6932 0.15C17.3591 0.0272727 18.2091 0 25 0C31.7909 0 32.6409 0.0295454 35.3045 0.15C37.9682 0.270454 39.7864 0.695455 41.3773 1.31136C43.0432 1.94091 44.5545 2.925 45.8045 4.19773C47.0773 5.44545 48.0591 6.95455 48.6864 8.62273C49.3045 10.2136 49.7273 12.0318 49.85 14.6909C49.9727 17.3614 50 18.2114 50 25C50 31.7909 49.9705 32.6409 49.85 35.3068C49.7295 37.9659 49.3045 39.7841 48.6864 41.375C48.0591 43.0434 47.0756 44.555 45.8045 45.8045C44.5545 47.0773 43.0432 48.0591 41.3773 48.6864C39.7864 49.3045 37.9682 49.7273 35.3091 49.85C32.6409 49.9727 31.7909 50 25 50C18.2091 50 17.3591 49.9705 14.6932 49.85C12.0341 49.7295 10.2159 49.3045 8.625 48.6864C6.95664 48.059 5.44505 47.0756 4.19545 45.8045C2.92359 44.5561 1.93935 43.0452 1.31136 41.3773C0.695455 39.7864 0.272727 37.9682 0.15 35.3091C0.0272727 32.6386 0 31.7886 0 25C0 18.2091 0.0295454 17.3591 0.15 14.6955C0.270454 12.0318 0.695455 10.2136 1.31136 8.62273C1.94028 6.95473 2.92527 5.44389 4.19773 4.19545C5.44555 2.92387 6.95562 1.93964 8.62273 1.31136C10.2136 0.695455 12.0318 0.272727 14.6909 0.15H14.6932ZM35.1023 4.65C32.4659 4.52955 31.675 4.50455 25 4.50455C18.325 4.50455 17.5341 4.52955 14.8977 4.65C12.4591 4.76136 11.1364 5.16818 10.2545 5.51136C9.08864 5.96591 8.25455 6.50455 7.37955 7.37955C6.5501 8.18648 5.91177 9.16882 5.51136 10.2545C5.16818 11.1364 4.76136 12.4591 4.65 14.8977C4.52955 17.5341 4.50455 18.325 4.50455 25C4.50455 31.675 4.52955 32.4659 4.65 35.1023C4.76136 37.5409 5.16818 38.8636 5.51136 39.7455C5.91136 40.8295 6.55 41.8136 7.37955 42.6205C8.18636 43.45 9.17045 44.0886 10.2545 44.4886C11.1364 44.8318 12.4591 45.2386 14.8977 45.35C17.5341 45.4705 18.3227 45.4955 25 45.4955C31.6773 45.4955 32.4659 45.4705 35.1023 45.35C37.5409 45.2386 38.8636 44.8318 39.7455 44.4886C40.9114 44.0341 41.7455 43.4955 42.6205 42.6205C43.45 41.8136 44.0886 40.8295 44.4886 39.7455C44.8318 38.8636 45.2386 37.5409 45.35 35.1023C45.4705 32.4659 45.4955 31.675 45.4955 25C45.4955 18.325 45.4705 17.5341 45.35 14.8977C45.2386 12.4591 44.8318 11.1364 44.4886 10.2545C44.0341 9.08864 43.4955 8.25455 42.6205 7.37955C41.8135 6.55016 40.8311 5.91184 39.7455 5.51136C38.8636 5.16818 37.5409 4.76136 35.1023 4.65ZM21.8068 32.7068C23.5901 33.4492 25.5759 33.5494 27.4248 32.9903C29.2738 32.4312 30.8713 31.2475 31.9446 29.6415C33.0178 28.0354 33.5001 26.1065 33.3092 24.1843C33.1183 22.2621 32.2659 20.4658 30.8977 19.1023C30.0255 18.2306 28.9709 17.5632 27.8098 17.1481C26.6488 16.7329 25.4101 16.5804 24.1829 16.7014C22.9558 16.8224 21.7708 17.214 20.7132 17.848C19.6556 18.482 18.7517 19.3426 18.0666 20.3678C17.3815 21.3931 16.9322 22.5575 16.7512 23.7772C16.5701 24.9969 16.6617 26.2416 17.0194 27.4216C17.3771 28.6017 17.992 29.6877 18.8198 30.6016C19.6476 31.5155 20.6678 32.2345 21.8068 32.7068ZM15.9136 15.9136C17.1069 14.7204 18.5235 13.7739 20.0825 13.1281C21.6415 12.4823 23.3125 12.1499 25 12.1499C26.6875 12.1499 28.3585 12.4823 29.9175 13.1281C31.4765 13.7739 32.8931 14.7204 34.0864 15.9136C35.2796 17.1069 36.2261 18.5235 36.8719 20.0825C37.5177 21.6415 37.8501 23.3125 37.8501 25C37.8501 26.6875 37.5177 28.3585 36.8719 29.9175C36.2261 31.4765 35.2796 32.8931 34.0864 34.0864C31.6765 36.4962 28.408 37.8501 25 37.8501C21.592 37.8501 18.3235 36.4962 15.9136 34.0864C13.5038 31.6765 12.1499 28.408 12.1499 25C12.1499 21.592 13.5038 18.3235 15.9136 15.9136ZM40.7 14.0636C40.9957 13.7847 41.2324 13.4493 41.3961 13.0772C41.5599 12.7052 41.6473 12.304 41.6532 11.8976C41.6591 11.4911 41.5835 11.0876 41.4306 10.7109C41.2778 10.3343 41.051 9.99207 40.7635 9.70463C40.4761 9.4172 40.1339 9.19036 39.7573 9.03754C39.3806 8.88472 38.9771 8.80904 38.5706 8.81496C38.1642 8.82089 37.763 8.9083 37.391 9.07204C37.0189 9.23577 36.6835 9.47249 36.4045 9.76818C35.8621 10.3432 35.5651 11.1071 35.5766 11.8976C35.5881 12.688 35.9073 13.4429 36.4663 14.0019C37.0253 14.5609 37.7801 14.8801 38.5706 14.8916C39.3611 14.9031 40.1249 14.6061 40.7 14.0636Z" fill="var(--wp--preset--color--primary)"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":""} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><a href="#">Instagram</a></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"40px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40px"><!-- wp:outermost/icon-block {"iconName":"","itemsJustification":"right","width":22} -->
<div class="wp-block-outermost-icon-block items-justified-right"><div class="icon-container" style="width:22px"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.1905 6.47619L3.28571 23.4286C2.90476 23.8095 2.45206 24 1.92762 24C1.40444 24 0.95238 23.8095 0.571428 23.4286C0.190476 23.0476 0 22.5949 0 22.0705C0 21.5473 0.190476 21.0952 0.571428 20.7143L17.5238 3.80952H3.04762C2.50794 3.80952 2.05524 3.6273 1.68952 3.26286C1.32508 2.89714 1.14286 2.44444 1.14286 1.90476C1.14286 1.36508 1.32508 0.912381 1.68952 0.546667C2.05524 0.182223 2.50794 0 3.04762 0H22.0952C22.6349 0 23.087 0.182223 23.4514 0.546667C23.8171 0.912381 24 1.36508 24 1.90476V20.9524C24 21.4921 23.8171 21.9441 23.4514 22.3086C23.087 22.6743 22.6349 22.8571 22.0952 22.8571C21.5556 22.8571 21.1035 22.6743 20.739 22.3086C20.3733 21.9441 20.1905 21.4921 20.1905 20.9524V6.47619Z" fill="#EDEDED"></path></svg></div></div>
<!-- /wp:outermost/icon-block --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"114px"} -->
<div style="height:114px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:separator {"className":"is-style-wide","backgroundColor":"tertiary"} -->
<hr class="wp-block-separator has-text-color has-tertiary-color has-alpha-channel-opacity has-tertiary-background-color has-background is-style-wide"/>
<!-- /wp:separator --></div>
<!-- /wp:group -->
