<?php
/**
 * Plugin install helper.
 *
 * @package Innofit
 * @since Innofit 0.1
 */

/**
 * Class Innofit_Plugin_Install_Helper
 */
class Innofit_Plugin_Install_Helper {
	/**
	 * Instance of class.
	 *
	 * @var bool $instance instance variable.
	 */
	private static $instance;

	/**
	 * Check if instance already exists.
	 *
	 * @return Innofit_Plugin_Install_Helper
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Innofit_Plugin_Install_Helper ) ) {
			self::$instance = new Innofit_Plugin_Install_Helper;
		}

		return self::$instance;
	}

	/**
	 * Generate action button html.
	 *
	 * @param string $slug plugin slug.
	 *
	 * @return string
	 */
	public function get_button_html( $slug ) {
		$button = '';
		$state  = $this->check_plugin_state( $slug );
		if ( ! empty( $slug ) ) {

			$button .= '<div class=" plugin-card-' . $slug . '" style="padding: 8px 0 5px;">';

			switch ( $state ) {
				case 'install':
					$nonce   = wp_nonce_url(
						add_query_arg(
							array(
								'action' => 'install-plugin',
								'from'   => 'import',
								'plugin' => $slug,
							),
							network_admin_url( 'update.php' )
						),
						'install-plugin_' . $slug
					);
					$button .= '<a data-slug="' . $slug . '" class="install-now innofit-install-plugin button  " href="' . esc_url( $nonce ) . '" data-name="' . $slug . '" aria-label="Install ' . $slug . '">' . esc_html__( 'Install and activate', 'innofit' ) . '</a>';
					break;

				case 'activate':
					if ( $slug == 'mailin' ) {
						$plugin_link_suffix = $slug . '/sendinblue.php';
					} else {
						$plugin_link_suffix = $slug . '/' . $slug . '.php';
					}

					$nonce = add_query_arg(
						array(
							'action'        => 'activate',
							'plugin'        => rawurlencode( $plugin_link_suffix ),
							'plugin_status' => 'all',
							'paged'         => '1',
							'_wpnonce'      => wp_create_nonce( 'activate-plugin_' . $plugin_link_suffix ),
						), network_admin_url( 'plugins.php' )
					);

					$button .= '<a data-slug="' . $slug . '" class="activate-now button button-primary" href="' . esc_url( $nonce ) . '" aria-label="Activate ' . $slug . '">' . esc_html__( 'Activate', 'innofit' ) . '</a>';
					break;
			}// End switch().
			$button .= '</div>';
		}// End if().

		return $button;
	}

	/**
	 * Check plugin state.
	 *
	 * @param string $slug plugin slug.
	 *
	 * @return bool
	 */
	private function check_plugin_state( $slug ) {
		if ( file_exists( ABSPATH . 'wp-content/plugins/' . $slug . '/' . $slug . '.php' ) || file_exists( ABSPATH . 'wp-content/plugins/' . $slug . '/index.php' ) ) {
			
			if( class_exists('SIB_Widget_Subscribe'))
			{
				$needs ='deactivate';
			}
			else
			{
				$needs ='activate';
			}
			return $needs;
		} else {
			return 'install';
		}
	}

	/**
	 * Enqueue Function.
	 */
	public function enqueue_scripts() {
		wp_enqueue_script( 'plugin-install' );
		wp_enqueue_script( 'updates' );
		wp_enqueue_script( 'innofit-plugin-install-helper', INNOFIT_TEMPLATE_DIR_URI . '/functions/plugin-install/js/innofit-plugin-install.js', array( 'jquery' ), 999, true );
		wp_localize_script(
			'innofit-plugin-install-helper', 'innofit_plugin_helper',
			array(
				'activating' => esc_html__( 'Activating ', 'innofit' ),
			)
		);
		wp_localize_script(
			'innofit-plugin-install-helper', 'pagenow',
			array( 'import' )
		);
	}
}
