<?php
/**
 * Returns an array of preconfigured theme options. Used in the Customizer to
 * dynamically update various theme options.
 * 
 * @pckage Inkblot
 * @return array
 */
return array(
	'inkblot' => array(
		'name' => __('Inkblot', 'inkblot'),
		'mods' => array(
			'content' => 'one-column',
			'sidebar1_width' => 25,
			'sidebar2_width' => 25,
			'sidebar3_width' => 25,
			'min_width' => 0,
			'max_width' => 0,
			'responsive_width' => 0,
			'font_size' => 100,
			'font' => '',
			'header_font' => '',
			'page_font' => '',
			'title_font' => '',
			'trim_font' => '',
			'background_color' => '#fff',
			'page_color' => '#fff',
			'trim_color' => '#000',
			'text_color' => '#000',
			'header_textcolor' => '#000',
			'page_text_color' => '#000',
			'trim_text_color' => '#fff',
			'link_color' => '#767676',
			'link_hover_color' => '#000',
			'page_link_color' => '#767676',
			'page_link_hover_color' => '#000',
			'trim_link_color' => '#767676',
			'trim_link_hover_color' => '#fff'
		)
	),
	'honeypot' => array( // https://color.adobe.com/Honey-Pot-color-theme-1490158/
		'name' => __('Honey Pot', 'inkblot'),
		'mods' => array(
			'content' => 'three-column content-center',
			'sidebar1_width' => 21,
			'sidebar2_width' => 21,
			'sidebar3_width' => 21,
			'min_width' => 0,
			'max_width' => 962,
			'responsive_width' => 640,
			'font_size' => 85,
			'font' => 'ABeeZee:regular,italic',
			'header_font' => 'Oleo+Script+Swash+Caps:regular,700',
			'page_font' => '',
			'title_font' => 'Oleo+Script:regular,700',
			'trim_font' => 'Oleo+Script:regular,700',
			'background_color' => '#ffd34e',
			'page_color' => '#fffad5',
			'trim_color' => '#bd4932',
			'text_color' => '#105b63',
			'header_textcolor' => '#db9e36',
			'page_text_color' => '#db9e36',
			'trim_text_color' => '#fffad5',
			'link_color' => '#bd4932',
			'link_hover_color' => '#105b63',
			'page_link_color' => '#105b63',
			'page_link_hover_color' => '#bd4932',
			'trim_link_color' => '#ffd34e',
			'trim_link_hover_color' => '#fffad5'
		)
	),
	'son' => array( // https://color.adobe.com/Son-color-theme-1523553/
		'name' => __('Son', 'inkblot'),
		'mods' => array(
			'content' => 'four-column content-left',
			'sidebar1_width' => 20,
			'sidebar2_width' => 20,
			'sidebar3_width' => 20,
			'min_width' => 0,
			'max_width' => 1026,
			'responsive_width' => 800,
			'font_size' => 80,
			'font' => 'Oldenburg:regular',
			'header_font' => 'Rye:regular',
			'page_font' => '',
			'title_font' => 'Rye:regular',
			'trim_font' => 'Rye:regular',
			'background_color' => '#ffab48',
			'page_color' => '#ffe7ad',
			'trim_color' => '#cc6b32',
			'text_color' => '#ffe7ad',
			'header_textcolor' => '#cc6b32',
			'page_text_color' => '#cc6b32',
			'trim_text_color' => '#ffe7ad',
			'link_color' => '#888a63',
			'link_hover_color' => '#ffe7ad',
			'page_link_color' => '#888a63',
			'page_link_hover_color' => '#a7c9ae',
			'trim_link_color' => '#a7c9ae',
			'trim_link_hover_color' => '#ffe7ad'
		)
	),
	'grannysmithapple' => array( // https://color.adobe.com/Granny-Smith-Apple-color-theme-2313/
		'name' => __('Granny Smith Apple', 'inkblot'),
		'mods' => array(
			'content' => 'two-column content-left',
			'sidebar1_width' => 38,
			'sidebar2_width' => 20,
			'sidebar3_width' => 20,
			'min_width' => 0,
			'max_width' => 802,
			'responsive_width' => 480,
			'font_size' => 100,
			'font' => 'Cabin+Condensed:regular,500,600,700',
			'header_font' => 'Crushed:regular',
			'page_font' => '',
			'title_font' => 'Crushed:regular',
			'trim_font' => 'Crushed:regular',
			'background_color' => '#493f0b',
			'page_color' => '#f5f6d4',
			'trim_color' => '#a7c520',
			'text_color' => '#f5f6d4',
			'header_textcolor' => '#493f0b',
			'page_text_color' => '#493f0b',
			'trim_text_color' => '#f5f6d4',
			'link_color' => '#85db18',
			'link_hover_color' => '#f5f6d4',
			'page_link_color' => '#a7c520',
			'page_link_hover_color' => '#85db18',
			'trim_link_color' => '#cde855',
			'trim_link_hover_color' => '#f5f6d4'
		)
	),
	'quietcry' => array( // https://color.adobe.com/Quiet-Cry-color-theme-124171/
		'name' => __('Quiet Cry', 'inkblot'),
		'mods' => array(
			'content' => 'one-column',
			'sidebar1_width' => 25,
			'sidebar2_width' => 25,
			'sidebar3_width' => 25,
			'min_width' => 0,
			'max_width' => 642,
			'responsive_width' => 320,
			'font_size' => 100,
			'font' => 'Averia+Libre:300,300italic,regular,italic,700,700italic',
			'header_font' => 'Amatic+SC:regular,700',
			'page_font' => '',
			'title_font' => 'Loved+by+the+King:regular',
			'trim_font' => 'Loved+by+the+King:regular',
			'background_color' => '#31353d',
			'page_color' => '#1c1d21',
			'trim_color' => '#445878',
			'text_color' => '#eeeff7',
			'header_textcolor' => '#445878',
			'page_text_color' => '#445878',
			'trim_text_color' => '#eeeff7',
			'link_color' => '#92cdcf',
			'link_hover_color' => '#eeeff7',
			'page_link_color' => '#92cdcf',
			'page_link_hover_color' => '#eeeff7',
			'trim_link_color' => '#92cdcf',
			'trim_link_hover_color' => '#eeeff7'
		)
	),
	'womaninpurpledress' => array( // https://color.adobe.com/Quiet-Cry-color-theme-124171/
		'name' => __('Woman in Purple Dress', 'inkblot'),
		'mods' => array(
			'content' => 'three-column content-right',
			'sidebar1_width' => 21,
			'sidebar2_width' => 21,
			'sidebar3_width' => 21,
			'min_width' => 0,
			'max_width' => 962,
			'responsive_width' => 640,
			'font_size' => 85,
			'font' => 'Milonga:regular',
			'header_font' => 'Henny+Penny:regular',
			'page_font' => '',
			'title_font' => 'Henny+Penny:regular',
			'trim_font' => 'Henny+Penny:regular',
			'background_color' => '#cc4452',
			'page_color' => '#31152b',
			'trim_color' => '#723147',
			'text_color' => '#f9e4ad',
			'header_textcolor' => '#e6b098',
			'page_text_color' => '#e6b098',
			'trim_text_color' => '#e6b098',
			'link_color' => '#31152b',
			'link_hover_color' => '#f9e4ad',
			'page_link_color' => '#cc4452',
			'page_link_hover_color' => '#e6b098',
			'trim_link_color' => '#cc4452',
			'trim_link_hover_color' => '#e6b098'
		)
	),
	'retropackage' => array( // https://color.adobe.com/Retro-package-color-theme-1366529/
		'name' => __('Retro Package', 'inkblot'),
		'mods' => array(
			'content' => 'two-column content-right',
			'sidebar1_width' => 25,
			'sidebar2_width' => 25,
			'sidebar3_width' => 25,
			'min_width' => 0,
			'max_width' => 802,
			'responsive_width' => 480,
			'font_size' => 100,
			'font' => 'VT323:regular',
			'header_font' => 'Press+Start+2P:regular',
			'page_font' => '',
			'title_font' => '',
			'trim_font' => '',
			'background_color' => '#593325',
			'page_color' => '#f2e6ce',
			'trim_color' => '#606362',
			'text_color' => '#f2e6ce',
			'header_textcolor' => '#1d1d1f',
			'page_text_color' => '#1d1d1f',
			'trim_text_color' => '#f2e6ce',
			'link_color' => '#8ab29f',
			'link_hover_color' => '#f2e6ce',
			'page_link_color' => '#593325',
			'page_link_hover_color' => '#8ab29f',
			'trim_link_color' => '#8ab29f',
			'trim_link_hover_color' => '#f2e6ce'
		)
	),
	'mustang' => array( // https://color.adobe.com/1944mustang-color-theme-4817/
		'name' => __('Mustang', 'inkblot'),
		'mods' => array(
			'content' => 'three-column content-left',
			'sidebar1_width' => 21,
			'sidebar2_width' => 21,
			'sidebar3_width' => 21,
			'min_width' => 0,
			'max_width' => 962,
			'responsive_width' => 640,
			'font_size' => 85,
			'font' => 'Nova+Square:regular',
			'header_font' => 'Wallpoet:regular',
			'page_font' => '',
			'title_font' => 'Wallpoet:regular',
			'trim_font' => 'Wallpoet:regular',
			'background_color' => '#000',
			'page_color' => '#263248',
			'trim_color' => '#ff9800',
			'text_color' => '#fff',
			'header_textcolor' => '#fff',
			'page_text_color' => '#fff',
			'trim_text_color' => '#fff',
			'link_color' => '#7e8aa2',
			'link_hover_color' => '#ff9800',
			'page_link_color' => '#7e8aa2',
			'page_link_hover_color' => '#ff9800',
			'trim_link_color' => '#263248',
			'trim_link_hover_color' => '#fff'
		)
	),
	'hereweare' => array( // https://color.adobe.com/Here-We-Are-color-theme-1555849/
		'name' => __('Here We Are', 'inkblot'),
		'mods' => array(
			'content' => 'four-column content-left',
			'sidebar1_width' => 20,
			'sidebar2_width' => 20,
			'sidebar3_width' => 20,
			'min_width' => 0,
			'max_width' => 1026,
			'responsive_width' => 800,
			'font_size' => 85,
			'font' => 'Schoolbell:regular',
			'header_font' => 'Luckiest+Guy:regular',
			'page_font' => '',
			'title_font' => 'Luckiest+Guy:regular',
			'trim_font' => 'Luckiest+Guy:regular',
			'background_color' => '#bd4932',
			'page_color' => '#3f0b1b',
			'trim_color' => '#7a1631',
			'text_color' => '#ffd462',
			'header_textcolor' => '#fc7d49',
			'page_text_color' => '#fc7d49',
			'trim_text_color' => '#ffd462',
			'link_color' => '#fc7d49',
			'link_hover_color' => '#ffd462',
			'page_link_color' => '#bd4932',
			'page_link_hover_color' => '#fc7d49',
			'trim_link_color' => '#bd4932',
			'trim_link_hover_color' => '#fc7d49'
		)
	),
	'knotjustnautical' => array( // https://color.adobe.com/KnotJustNautical-color-theme-2565165/
		'name' => __('Knot Just Nautical', 'inkblot'),
		'mods' => array(
			'content' => 'four-column content-right',
			'sidebar1_width' => 20,
			'sidebar2_width' => 20,
			'sidebar3_width' => 20,
			'min_width' => 0,
			'max_width' => 1026,
			'responsive_width' => 800,
			'font_size' => 85,
			'font' => 'Bubblegum+Sans:regular',
			'header_font' => 'Fredericka+the+Great:regular',
			'page_font' => '',
			'title_font' => 'Fredericka+the+Great:regular',
			'trim_font' => '',
			'background_color' => '#d7dadb',
			'page_color' => '#fff',
			'trim_color' => '#2c3e50',
			'text_color' => '#2c3e50',
			'header_textcolor' => '#2c3e50',
			'page_text_color' => '#2c3e50',
			'trim_text_color' => '#d7dadb',
			'link_color' => '#fc4349',
			'link_hover_color' => '#6dbcdb',
			'page_link_color' => '#fc4349',
			'page_link_hover_color' => '#6dbcdb',
			'trim_link_color' => '#6dbcdb',
			'trim_link_hover_color' => '#d7dadb'
		)
	),
	'dasboot' => array( // https://color.adobe.com/Das-Boot-color-theme-189112/
		'name' => __('Das Boot', 'inkblot'),
		'mods' => array(
			'content' => 'four-column content-far-right',
			'sidebar1_width' => 20,
			'sidebar2_width' => 20,
			'sidebar3_width' => 20,
			'min_width' => 0,
			'max_width' => 1026,
			'responsive_width' => 800,
			'font_size' => 85,
			'font' => 'Slabo+13px:regular',
			'header_font' => 'Kelly+Slab:regular',
			'page_font' => '',
			'title_font' => 'Kelly+Slab:regular',
			'trim_font' => 'Slabo+27px:regular',
			'background_color' => '#666a73',
			'page_color' => '#2f3540',
			'trim_color' => '#8c8681',
			'text_color' => '#f2ede4',
			'header_textcolor' => '#d9d1c7',
			'page_text_color' => '#d9d1c7',
			'trim_text_color' => '#f2ede4',
			'link_color' => '#d9d1c7',
			'link_hover_color' => '#f2ede4',
			'page_link_color' => '#8c8681',
			'page_link_hover_color' => '#d9d1c7',
			'trim_link_color' => '#d9d1c7',
			'trim_link_hover_color' => '#f2ede4'
		)
	)
);