<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'influencer-marketing' ); ?></a>

<?php if(get_theme_mod('influencer_marketing_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'influencer_marketing_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'influencer-marketing' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'influencer_marketing_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>

<div class="header_area">
	<div class="topheader py-2">
		<div class="container">
			<div class="row">
				<div class="col-lg-7 col-md-7 col-sm-7 align-self-center text-center text-md-start wow fadeInLeft">
					<?php if ( get_theme_mod('influencer_marketing_header_phone_number') ) : ?>
						<span class="me-3"><i class="fas fa-phone me-2"></i><a href="callto:<?php echo esc_html(get_theme_mod('influencer_marketing_header_phone_number','')); ?>"><?php echo esc_html(get_theme_mod('influencer_marketing_header_phone_number','')); ?></a></span>
					<?php endif; ?>

					<?php if ( get_theme_mod('influencer_marketing_header_email_address') ) : ?>
						<span><i class="fas fa-envelope me-2"></i><a href="mailto:<?php echo esc_html(get_theme_mod('influencer_marketing_header_email_address','')); ?>"><?php echo esc_html(get_theme_mod('influencer_marketing_header_email_address','')); ?></a></span>
					<?php endif; ?>
				</div>			
				<div class="col-lg-5 col-md-5 col-sm-5 align-self-center wow fadeInRight">
					<?php $influencer_marketing_settings = get_theme_mod( 'influencer_marketing_social_links_settings' ); ?>
					<div class="social-links text-center text-md-end">
						<?php if ( is_array($influencer_marketing_settings) || is_object($influencer_marketing_settings) ){ ?>
						    	<?php foreach( $influencer_marketing_settings as $influencer_marketing_setting ) { ?>
							        <a href="<?php echo esc_url( $influencer_marketing_setting['link_url'] ); ?>">
							            <i class="<?php echo esc_attr( $influencer_marketing_setting['link_text'] ); ?> me-2"></i>
							        </a>
						    	<?php } ?>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="<?php if( get_theme_mod( 'influencer_marketing_sticky_header', false) != '') { ?>sticky-header<?php } else { ?>close-sticky main-menus<?php } ?>">
		<header id="site-navigation" class="text-center text-md-start">			
			<div class="container">
				<div class="header_inner px-3 py-2  wow fadeInDown">
					<div class="row">
						<div class="col-lg-3 col-md-4 col-sm-12 align-self-center">
							<div class="logo">
					    		<div class="logo-image">
					    			<?php the_custom_logo(); ?>
						    	</div>
						    	<div class="logo-content text-center text-lg-start">
							    	<?php
							    		if ( get_theme_mod('influencer_marketing_display_header_title', true) == true ) :
								      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
								      			echo esc_attr(get_bloginfo('name'));
								      		echo '</a>';
								      	endif;

								      	if ( get_theme_mod('influencer_marketing_display_header_text', false) == true ) :
							      			echo '<span>'. esc_attr(get_bloginfo('description')) . '</span>';
							      		endif;
						    		?>
								</div>
							</div>
					   	</div>
						<div class="col-lg-6 col-md-2 col-sm-8 col-4 align-self-center">
							<div class="top-menu-wrapper">
							    <div class="navigation_header">
							        <div class="toggle-nav mobile-menu">
							            <button onclick="influencer_marketing_openNav()">
							                <span class="dashicons dashicons-menu"></span>
							            </button>
							        </div>
							        <div id="mySidenav" class="nav sidenav">
							            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'influencer-marketing' ); ?>">
							                <?php {
							                    wp_nav_menu(
							                        array(
							                            'theme_location' => 'main-menu',
							                            'container_class' => 'navi clearfix navbar-nav',
							                            'menu_class'     => 'menu clearfix',
							                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							                            'fallback_cb'    => 'wp_page_menu',
							                        )
							                    );
							                } ?>
							            </nav>
							            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="influencer_marketing_closeNav()">
							                <span class="dashicons dashicons-no"></span>
							            </a>
							        </div>
							    </div>
							</div>
						</div>
						<div class="col-lg-3 col-md-6 col-sm-4 col-6 align-self-center text-md-end text-center my-2">
							<?php if ( get_theme_mod('influencer_marketing_header_login_link') ) : ?>
								<a href="<?php echo esc_url(get_theme_mod('influencer_marketing_header_login_link','')); ?>"><?php esc_html_e('Log In','influencer-marketing'); ?></a>
							<?php endif; ?>
							<?php if ( get_theme_mod('influencer_marketing_header_signin_link') ) : ?>
								<a class="sign-in-area ms-2" href="<?php echo esc_url(get_theme_mod('influencer_marketing_header_signin_link','')); ?>"><?php esc_html_e('Sign In','influencer-marketing'); ?></a>
							<?php endif; ?>
				       	</div>
				   	</div>
				</div>
			</div>
		</header>
	</div>
</div>