<?php

/*-----------------------------------------------------------------------------------*/
/* Enqueue script and styles */
/*-----------------------------------------------------------------------------------*/

function influencer_marketing_enqueue_google_fonts() {

	require_once get_theme_file_path( 'core/includes/wptt-webfont-loader.php' );

	wp_enqueue_style( 'google-fonts-josefin', 'https://fonts.googleapis.com/css2?family=Josefin+Sans:ital,wght@0,100..700;1,100..700&display=swap' );
}
add_action( 'wp_enqueue_scripts', 'influencer_marketing_enqueue_google_fonts' );

if (!function_exists('influencer_marketing_enqueue_scripts')) {

	function influencer_marketing_enqueue_scripts() {

		wp_enqueue_style(
			'bootstrap-css',
			get_template_directory_uri() . '/css/bootstrap.css',
			array(),'4.5.0'
		);

		wp_enqueue_style(
			'fontawesome-css',
			get_template_directory_uri() . '/css/fontawesome-all.css',
			array(),'4.5.0'
		);

		wp_enqueue_style(
			'slick-css',
			get_template_directory_uri() . '/css/slick.css',
			array(),'2.3.4'
		);

		wp_enqueue_style( 'influencer-marketing-block-style', get_theme_file_uri('/css/blocks.css') );

		wp_enqueue_style('influencer-marketing-style', get_stylesheet_uri(), array() );

		wp_style_add_data('influencer-marketing-style', 'rtl', 'replace');

		wp_enqueue_style(
			'influencer-marketing-media-css',
			get_template_directory_uri() . '/css/media.css',
			array(),'2.3.4'
		);

		wp_enqueue_style(
			'influencer-marketing-woocommerce-css',
			get_template_directory_uri() . '/css/woocommerce.css',
			array(),'2.3.4'
		);

		wp_enqueue_style('dashicons');

		wp_enqueue_script(
			'influencer-marketing-navigation',
			get_template_directory_uri() . '/js/navigation.js',
			FALSE,
			'1.0',
			TRUE
		);

		wp_enqueue_script(
			'slick-min-js',
			get_template_directory_uri() . '/js/slick.min.js',
			array('jquery'),
			'2.3.4',
			TRUE
		);

		wp_enqueue_script(
			'influencer-marketing-script',
			get_template_directory_uri() . '/js/script.js',
			array('jquery'),
			'1.0',
			TRUE
		);

		if ( get_theme_mod( 'influencer_marketing_animation_enabled', true ) ) {
        wp_enqueue_script(
            'influencer-marketing-wow-script',
            get_template_directory_uri() . '/js/wow.js',
            array( 'jquery' ),
            '1.0',
            true
        );

        wp_enqueue_style(
            'influencer-marketing-animate',
            get_template_directory_uri() . '/css/animate.css',
            array(),
            '4.1.1'
        );
    }

		if ( is_singular() ) wp_enqueue_script( 'comment-reply' );

		$influencer_marketing_css = '';

		if ( get_header_image() ) :

			$influencer_marketing_css .=  '
				.header_area{
					background-image: url('.esc_url(get_header_image()).');
					-webkit-background-size: cover !important;
					-moz-background-size: cover !important;
					-o-background-size: cover !important;
					background-size: cover !important;
				}';

		endif;

		wp_add_inline_style( 'influencer-marketing-style', $influencer_marketing_css );

		// Theme Customize CSS.
		require get_template_directory(). '/core/includes/inline.php';
		wp_add_inline_style( 'influencer-marketing-style',$influencer_marketing_custom_css );

	}

	add_action( 'wp_enqueue_scripts', 'influencer_marketing_enqueue_scripts' );

}

/*-----------------------------------------------------------------------------------*/
/* Setup theme */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('influencer_marketing_after_setup_theme')) {

	function influencer_marketing_after_setup_theme() {

		load_theme_textdomain( 'influencer-marketing', get_stylesheet_directory() . '/languages' );
		if ( ! isset( $influencer_marketing_content_width ) ) $influencer_marketing_content_width = 900;

		register_nav_menus( array(
			'main-menu' => esc_html__( 'Main menu', 'influencer-marketing' ),
		));

		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'align-wide' );
		add_theme_support('title-tag');
		add_theme_support('automatic-feed-links');
		add_theme_support( 'wp-block-styles' );
		add_theme_support('post-thumbnails');
		add_theme_support( 'custom-background', array(
		  'default-color' => 'f3f3f3'
		));

		add_theme_support( 'custom-logo', array(
			'height'      => 70,
			'width'       => 70,
		) );

		add_theme_support( 'custom-header', array(
			'header-text' => false,
			'width' => 1920,
			'height' => 100
		));

		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

		add_editor_style( array( '/css/editor-style.css' ) );

	}

	add_action( 'after_setup_theme', 'influencer_marketing_after_setup_theme', 999 );

}

function influencer_marketing_template_setup() {

require get_template_directory() .'/core/includes/main.php';
require get_template_directory() .'/core/includes/theme-breadcrumb.php';
require get_template_directory() . '/core/includes/importer/config.php';
require get_template_directory() . '/core/includes/customizer.php';
load_template( trailingslashit( get_template_directory() ) . '/core/includes/class-upgrade-pro.php' );

}
add_action('after_setup_theme', 'influencer_marketing_template_setup');

/*-----------------------------------------------------------------------------------*/
/* Enqueue theme logo style */
/*-----------------------------------------------------------------------------------*/
function influencer_marketing_logo_resizer() {

    $influencer_marketing_theme_logo_size_css = '';
    $influencer_marketing_logo_resizer = get_theme_mod('influencer_marketing_logo_resizer');

	$influencer_marketing_theme_logo_size_css = '
		.custom-logo{
			height: '.esc_attr($influencer_marketing_logo_resizer).'px !important;
			width: '.esc_attr($influencer_marketing_logo_resizer).'px !important;
		}
	';
    wp_add_inline_style( 'influencer-marketing-style',$influencer_marketing_theme_logo_size_css );

}
add_action( 'wp_enqueue_scripts', 'influencer_marketing_logo_resizer' );

/*-----------------------------------------------------------------------------------*/
/* Enqueue Global color style */
/*-----------------------------------------------------------------------------------*/
function influencer_marketing_global_color() {

    $influencer_marketing_theme_color_css = '';
    $influencer_marketing_copyright_bg = get_theme_mod('influencer_marketing_copyright_bg');

	$influencer_marketing_theme_color_css = '
    	.copyright {
			background: '.esc_attr($influencer_marketing_copyright_bg).';
		}
	';
    wp_add_inline_style( 'influencer-marketing-style',$influencer_marketing_theme_color_css );
    wp_add_inline_style( 'influencer-marketing-woocommerce-css',$influencer_marketing_theme_color_css );

}
add_action( 'wp_enqueue_scripts', 'influencer_marketing_global_color' );

/*-----------------------------------------------------------------------------------*/
/* Get post comments */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('influencer_marketing_comment')) :
    /**
     * Template for comments and pingbacks.
     *
     * Used as a callback by wp_list_comments() for displaying the comments.
     */
    function influencer_marketing_comment($comment, $args, $depth){

        if ('pingback' == $comment->comment_type || 'trackback' == $comment->comment_type) : ?>

            <li id="comment-<?php comment_ID(); ?>" <?php comment_class('media'); ?>>
            <div class="comment-body">
                <?php esc_html_e('Pingback:', 'influencer-marketing');
                comment_author_link(); ?><?php edit_comment_link(__('Edit', 'influencer-marketing'), '<span class="edit-link">', '</span>'); ?>
            </div>

        <?php else : ?>

        <li id="comment-<?php comment_ID(); ?>" <?php comment_class(empty($args['has_children']) ? '' : 'parent'); ?>>
            <article id="div-comment-<?php comment_ID(); ?>" class="comment-body media mb-4">
                <a class="pull-left" href="#">
                    <?php if (0 != $args['avatar_size']) echo get_avatar($comment, $args['avatar_size']); ?>
                </a>
                <div class="media-body">
                    <div class="media-body-wrap card">
                        <div class="card-header">
                            <h5 class="mt-0"><?php /* translators: %s: author */ printf('<cite class="fn">%s</cite>', get_comment_author_link() ); ?></h5>
                            <div class="comment-meta">
							    <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
							        <time datetime="<?php comment_time( 'c' ); ?>">
							            <?php printf(
							                esc_html__( '%1$s at %2$s', 'influencer-marketing' ),
							                esc_html( get_comment_date() ), esc_html( get_comment_time() ) ); ?>
							        </time>
							    </a>
							    <?php
							    edit_comment_link(esc_html__( 'Edit', 'influencer-marketing' ),'<span class="edit-link">','</span>');?>
							</div>
                        </div>

                        <?php if ('0' == $comment->comment_approved) : ?>
                            <p class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'influencer-marketing'); ?></p>
                        <?php endif; ?>

                        <div class="comment-content card-block">
                            <?php comment_text(); ?>
                        </div>

                        <?php comment_reply_link(
                            array_merge(
                                $args, array(
                                    'add_below' => 'div-comment',
                                    'depth' => $depth,
                                    'max_depth' => $args['max_depth'],
                                    'before' => '<footer class="reply comment-reply card-footer">',
                                    'after' => '</footer><!-- .reply -->'
                                )
                            )
                        ); ?>
                    </div>
                </div>
            </article>

            <?php
        endif;
    }
endif; // ends check for influencer_marketing_comment()

if (!function_exists('influencer_marketing_widgets_init')) {

	function influencer_marketing_widgets_init() {

		register_sidebar(array(

			'name' => esc_html__('Sidebar','influencer-marketing'),
			'id'   => 'influencer-marketing-sidebar',
			'description'   => esc_html__('This sidebar will be shown next to the content.', 'influencer-marketing'),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));

		register_sidebar(array(

			'name' => esc_html__('Sidebar 2','influencer-marketing'),
			'id'   => 'influencer-marketing-sidebar-2',
			'description'   => esc_html__('This sidebar will be shown next to the content.', 'influencer-marketing'),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));

		register_sidebar(array(

			'name' => esc_html__('Sidebar 3','influencer-marketing'),
			'id'   => 'influencer-marketing-sidebar-3',
			'description'   => esc_html__('This sidebar will be shown next to the content.', 'influencer-marketing'),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));

		register_sidebar(array(

			'name' => esc_html__('Footer sidebar','influencer-marketing'),
			'id'   => 'influencer-marketing-footer-sidebar',
			'description'   => esc_html__('This sidebar will be shown next at the bottom of your content.', 'influencer-marketing'),
			'before_widget' => '<div id="%1$s" class="col-lg-3 col-md-3 %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));

	}

	add_action( 'widgets_init', 'influencer_marketing_widgets_init' );

}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'influencer_marketing_loop_columns');
if (!function_exists('influencer_marketing_loop_columns')) {
	function influencer_marketing_loop_columns() {
		$influencer_marketing_columns = get_theme_mod( 'influencer_marketing_per_columns', 3 );
		return $influencer_marketing_columns;
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'influencer_marketing_per_page', 20 );
function influencer_marketing_per_page( $influencer_marketing_cols ) {
  	$influencer_marketing_cols = get_theme_mod( 'influencer_marketing_product_per_page', 9 );
	return $influencer_marketing_cols;
}

// Add filter to modify the number of related products
add_filter( 'woocommerce_output_related_products_args', 'influencer_marketing_products_args' );
function influencer_marketing_products_args( $args ) {
    $args['posts_per_page'] = get_theme_mod( 'custom_related_products_number', 6 );
    $args['columns'] = get_theme_mod( 'custom_related_products_number_per_row', 3 );
    return $args;
}

function influencer_marketing_sanitize_phone_number( $phone ) {
	return preg_replace( '/[^\d+]/', '', $phone );
}

add_action('after_switch_theme', 'influencer_marketing_setup_options');
function influencer_marketing_setup_options () {
    update_option('dismissed-get_started', FALSE );
}

add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );

//add animation class
if ( class_exists( 'WooCommerce' ) ) { 
	add_filter('post_class', function($influencer_marketing, $class, $product_id) {
	    if( is_shop() || is_product_category() ){
	        
	        $influencer_marketing = array_merge(['wow','zoomIn'], $influencer_marketing);
	    }
	    return $influencer_marketing;
	},10,3);
}

function get_page_id_by_title($pagename){

    $args = array(
        'post_type' => 'page',
        'posts_per_page' => 1,
        'post_status' => 'publish',
        'title' => $pagename
    );
    $query = new WP_Query( $args );

    $page_id = '1';
    if (isset($query->post->ID)) {
        $page_id = $query->post->ID;
    }

    return $page_id;
}

add_action( 'customize_register', 'influencer_marketing_remove_setting', 20 );
function influencer_marketing_remove_setting( $wp_customize ) {
    // Check if the setting or control exists before removing
    if ( $wp_customize->get_setting( 'header_textcolor' ) ) {
        $wp_customize->remove_setting( 'header_textcolor' );
    }

    if ( $wp_customize->get_control( 'header_textcolor' ) ) {
        $wp_customize->remove_control( 'header_textcolor' );
    }
}

// edit link option
if (!function_exists('influencer_marketing_edit_link')) :

    function influencer_marketing_edit_link($view = 'default')
    {
        global $post;
            edit_post_link(
                sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __('Edit <span class="screen-reader-text">%s</span>', 'influencer-marketing'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    get_the_title()
                ),
                '<span class="edit-link"><i class="fas fa-edit"></i>',
                '</span>'
            );

    }
endif;

/*-----------------------------------------------------------------------------------*/
/* Dark Mode */
/*-----------------------------------------------------------------------------------*/

function influencer_marketing_body_class( $influencer_marketing_classes ) {
    $influencer_marketing_dark_mode_enabled = get_theme_mod( 'influencer_marketing_is_dark_mode_enabled', false );

    if ( $influencer_marketing_dark_mode_enabled ) {
        $influencer_marketing_classes[] = 'dark-mode';
    }

    return $influencer_marketing_classes;
}
add_filter( 'body_class', 'influencer_marketing_body_class' );