<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_influencer_marketing_dismissed_notice_handler', 'influencer_marketing_ajax_notice_handler' );

/**
 * AJAX handler to store the state of dismissible notices.
 */
function influencer_marketing_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        // Pick up the notice "type" - passed via jQuery (the "data-notice" attribute on the notice)
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        // Store it in the options table
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function influencer_marketing_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_influencer-marketing-guide-page' &&
            $current_screen->id !== 'appearance_page_influencermarketing-wizard'
        ) {
            $influencer_marketing_comments_theme = wp_get_theme();
            ?>
            <div class="influencer-marketing-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="influencer-marketing-notice">
                    <div class="influencer-marketing-notice-content">
                        <div class="influencer-marketing-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'influencer-marketing'); ?>
                                <?php echo esc_html( $influencer_marketing_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'influencer-marketing'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'influencer-marketing'),
                                    $influencer_marketing_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=influencer-marketing-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'influencer-marketing'); ?>
                            </a>
                            <a class="button button-primary" target="_blank" href="<?php echo esc_url( INFLUENCER_MARKETING_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'influencer-marketing'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=influencermarketing-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'influencer-marketing'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="influencer-marketing-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'influencer-marketing'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'influencer_marketing_deprecated_hook_admin_notice' );

function influencer_marketing_admin_enqueue_scripts() {
	wp_enqueue_style( 'influencer-marketing-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'influencer-marketing-admin-script', get_template_directory_uri() . '/js/influencer-marketing-admin-script.js', array( 'jquery' ), '', true );
	wp_localize_script( 'influencer-marketing-demo-script', 'influencer_marketing_demo_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'influencer_marketing_admin_enqueue_scripts' );

add_action( 'admin_menu', 'influencer_marketing_getting_started' );
function influencer_marketing_getting_started() {
	add_theme_page( esc_html__('Get Started', 'influencer-marketing'), esc_html__('Get Started', 'influencer-marketing'), 'edit_theme_options', 'influencer-marketing-guide-page', 'influencer_marketing_test_guide');
}

if ( ! defined( 'INFLUENCER_MARKETING_DOCS_FREE' ) ) {
define('INFLUENCER_MARKETING_DOCS_FREE',__('https://demo.misbahwp.com/docs/influencer-marketing-free-docs/','influencer-marketing'));
}
if ( ! defined( 'INFLUENCER_MARKETING_DOCS_PRO' ) ) {
define('INFLUENCER_MARKETING_DOCS_PRO',__('https://demo.misbahwp.com/docs/influencer-marketing-pro-docs','influencer-marketing'));
}
if ( ! defined( 'INFLUENCER_MARKETING_BUY_NOW' ) ) {
define('INFLUENCER_MARKETING_BUY_NOW',__('https://www.misbahwp.com/products/influencer-marketing-wordpress-theme','influencer-marketing'));
}
if ( ! defined( 'INFLUENCER_MARKETING_SUPPORT_FREE' ) ) {
define('INFLUENCER_MARKETING_SUPPORT_FREE',__('https://wordpress.org/support/theme/influencer-marketing','influencer-marketing'));
}
if ( ! defined( 'INFLUENCER_MARKETING_REVIEW_FREE' ) ) {
define('INFLUENCER_MARKETING_REVIEW_FREE',__('https://wordpress.org/support/theme/influencer-marketing/reviews/#new-post','influencer-marketing'));
}
if ( ! defined( 'INFLUENCER_MARKETING_DEMO_PRO' ) ) {
define('INFLUENCER_MARKETING_DEMO_PRO',__('https://demo.misbahwp.com/influencer-marketing/','influencer-marketing'));
}
if( ! defined( 'INFLUENCER_MARKETING_THEME_BUNDLE' ) ) {
define('INFLUENCER_MARKETING_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','influencer-marketing'));
}

function influencer_marketing_test_guide() { ?>
	<?php $influencer_marketing_theme = wp_get_theme();?>
	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( INFLUENCER_MARKETING_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'influencer-marketing' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'influencer-marketing' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( INFLUENCER_MARKETING_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'influencer-marketing' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( INFLUENCER_MARKETING_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'influencer-marketing' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','influencer-marketing'); ?><?php echo esc_html( $influencer_marketing_theme ); ?>  <span><?php esc_html_e('Version: ', 'influencer-marketing'); ?><?php echo esc_html($influencer_marketing_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','influencer-marketing'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','influencer-marketing'); ?></p>
					<a class="button button-primary import" href="themes.php?page=influencermarketing-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','influencer-marketing'); ?></a>
				</div>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $influencer_marketing_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$influencer_marketing_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $influencer_marketing_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="postboxx donate">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'influencer-marketing' ); ?></h3>
				<div class="insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','influencer-marketing'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( INFLUENCER_MARKETING_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'influencer-marketing' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( INFLUENCER_MARKETING_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'influencer-marketing' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( INFLUENCER_MARKETING_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'influencer-marketing' ) ?></a>
					</div>
				</div>
				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'influencer-marketing' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'influencer-marketing'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','influencer-marketing'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','influencer-marketing'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','influencer-marketing'); ?></span></p>
				<div id="admin_pro_linkss">
					<a class="blue-button-1" href="<?php echo esc_url( INFLUENCER_MARKETING_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Buy All Themes - $89', 'influencer-marketing' ) ?></a>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','influencer-marketing'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','influencer-marketing'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','influencer-marketing'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('LearnPress Campatiblity','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','influencer-marketing'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>
<?php } ?>