<?php

if ( ! defined( 'INFLUENCER_MARKETING_BUY_NOW_1' ) ) {
define('INFLUENCER_MARKETING_BUY_NOW_1',__('https://www.misbahwp.com/products/free-influencer-wordpress-theme','influencer-marketing'));
}

if ( class_exists("Kirki")){

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'influencer_marketing_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'influencer-marketing' ),
		'section'     => 'title_tagline',
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'influencer-marketing' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'influencer-marketing' ),
		'section'     => 'title_tagline',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'influencer_marketing_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'influencer-marketing' ),
	) );

	Kirki::add_section( 'influencer_marketing_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'influencer-marketing' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_all_headings_typography',
		'section'     => 'influencer_marketing_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'influencer_marketing_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'influencer-marketing' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'influencer-marketing' ),
		'section'     => 'influencer_marketing_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_body_content_typography',
		'section'     => 'influencer_marketing_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'influencer_marketing_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'influencer-marketing' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'influencer-marketing' ),
		'section'     => 'influencer_marketing_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'influencer_marketing_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'influencer-marketing' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'influencer_marketing_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'influencer-marketing' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'influencer_marketing_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'influencer-marketing' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'influencer_marketing_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'influencer-marketing' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'influencer_marketing_dark_colors',
	    'section'     => 'influencer_marketing_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'influencer-marketing' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );


	// PANEL
	Kirki::add_panel( 'influencer_marketing_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings / No Result', 'influencer-marketing' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'influencer_marketing_section_404', array(
		'panel'          => 'influencer_marketing_panel_id_3',
	    'title'          => esc_html__( '404 Settings', 'influencer-marketing' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'influencer_marketing_404_heading',
	    'section'     => 'influencer_marketing_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Heading', 'influencer-marketing' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_404_page_title',
		'section'  => 'influencer_marketing_section_404',
		'default'  => esc_html__('404 Not Found', 'influencer-marketing'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'influencer_marketing_404_text',
	    'section'     => 'influencer_marketing_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Content', 'influencer-marketing' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_404_page_content',
		'section'  => 'influencer_marketing_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'influencer-marketing'),
		'priority' => 10,
	] );

	// NO Result
	Kirki::add_section( 'influencer_marketing_no_result', array(
		'panel'          => 'influencer_marketing_panel_id_3',
	    'title'          => esc_html__( 'No Result Page Settings', 'influencer-marketing' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_no_result',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'influencer_marketing_not_found_heading',
	    'section'     => 'influencer_marketing_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Heading', 'influencer-marketing' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_no_results_page_title',
		'section'  => 'influencer_marketing_no_result',
		'default'  => esc_html__('404 Not Found', 'influencer-marketing'),
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'influencer_marketing_not_found_text',
	    'section'     => 'influencer_marketing_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Content', 'influencer-marketing' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_no_results_page_content',
		'section'  => 'influencer_marketing_no_result',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'influencer-marketing'),
		'priority' => 10,
	] );

	// PANEL

	Kirki::add_panel( 'influencer_marketing_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'influencer-marketing' ),
	) );


	//COLOR SECTION

	Kirki::add_section( 'influencer_marketing_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'influencer-marketing' ),
	    'panel'          => 'influencer_marketing_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_global_colors',
		'section'     => 'influencer_marketing_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'influencer_marketing_first_color',
		'label'       => __( 'Choose Your First Color', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_color',
		'default'     => '#FF8F0B',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'influencer_marketing_second_color',
		'label'       => __( 'Choose Your Second Color', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_color',
		'default'     => '#1796F2',
	] );

	// Additional Settings

	Kirki::add_section( 'influencer_marketing_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'influencer-marketing' ),
	    'description'    => esc_html__( 'Scroll To Top', 'influencer-marketing' ),
	    'panel'          => 'influencer_marketing_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'influencer_marketing_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'influencer_marketing_scroll_top_position',
			'label'       => esc_html__( 'Alignment for Scroll To Top', 'influencer-marketing' ),
			'section'     => 'influencer_marketing_additional_settings',
			'default'     => 'Right',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'influencer-marketing' ),
				'Center' => esc_html__( 'Center', 'influencer-marketing' ),
				'Right'  => esc_html__( 'Right', 'influencer-marketing' ),
			],
		]
		);

	new \Kirki\Field\Select(
	[
		'settings'    => 'menu_text_transform_influencer_marketing',
		'label'       => esc_html__( 'Menus Text Transform', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default'     => 'CAPITALISE',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'CAPITALISE' => esc_html__( 'CAPITALISE', 'influencer-marketing' ),
			'UPPERCASE' => esc_html__( 'UPPERCASE', 'influencer-marketing' ),
			'LOWERCASE' => esc_html__( 'LOWERCASE', 'influencer-marketing' ),

		],
	]
	);

		new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_menu_zoom',
		'label'       => esc_html__( 'Menu Transition', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default' => 'None',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'None' => __('None','influencer-marketing'),
            'Zoominn' => __('Zoom Inn','influencer-marketing'),
            
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'influencer_marketing_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'influencer_marketing_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','influencer-marketing'),
            'cube-loader' => __('Type 2','influencer-marketing'),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'influencer_marketing_sticky_header',
		'label'       => esc_html__( 'Here you can enable or disable your Sticky Header.', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','influencer-marketing'),
            'Right Sidebar' => __('Right Sidebar','influencer-marketing'),
            'One Column' => __('One Column','influencer-marketing')
		],
	] );

	// Woocommerce Settings

	if ( class_exists("woocommerce")){


	Kirki::add_section( 'influencer_marketing_woocommerce_settings', array(
		'title'          => esc_html__( 'Woocommerce Settings', 'influencer-marketing' ),
		'panel'          => 'influencer_marketing_panel_id',
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_woocommerce_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'influencer_marketing_shop_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'influencer_marketing_product_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'influencer_marketing_related_product_setting',
		'label'       => esc_html__( 'Here you can enable or disable your related products.', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_woocommerce_settings',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Number(
		[
			'settings' => 'influencer_marketing_per_columns',
			'label'    => esc_html__( 'Product Per Row', 'influencer-marketing' ),
			'section'  => 'influencer_marketing_woocommerce_settings',
			'default'  => 3,
			'choices'  => [
				'min'  => 1,
				'max'  => 4,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
		[
			'settings' => 'influencer_marketing_product_per_page',
			'label'    => esc_html__( 'Product Per Page', 'influencer-marketing' ),
			'section'  => 'influencer_marketing_woocommerce_settings',
			'default'  => 9,
			'choices'  => [
				'min'  => 1,
				'max'  => 15,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
		[
			'settings' => 'custom_related_products_number_per_row',
			'label'    => esc_html__( 'Related Product Per Column', 'influencer-marketing' ),
			'section'  => 'influencer_marketing_woocommerce_settings',
			'default'  => 3,
			'choices'  => [
				'min'  => 1,
				'max'  => 4,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
		[
			'settings' => 'custom_related_products_number',
			'label'    => esc_html__( 'Related Product Per Page', 'influencer-marketing' ),
			'section'  => 'influencer_marketing_woocommerce_settings',
			'default'  => 3,
			'choices'  => [
				'min'  => 1,
				'max'  => 10,
				'step' => 1,
			],
		]
	);

		new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_shop_page_layout',
		'label'       => esc_html__( 'Shop Page Layout Setting', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','influencer-marketing'),
            'Right Sidebar' => __('Right Sidebar','influencer-marketing')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_product_page_layout',
		'label'       => esc_html__( 'Product Page Layout Setting', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','influencer-marketing'),
            'Right Sidebar' => __('Right Sidebar','influencer-marketing')
		],
	] );

	new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'influencer_marketing_woocommerce_pagination_position',
		'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_woocommerce_settings',
		'default'     => 'Center',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'influencer-marketing' ),
			'Center' => esc_html__( 'Center', 'influencer-marketing' ),
			'Right'  => esc_html__( 'Right', 'influencer-marketing' ),
		],
	]
	);

	}

	// POST SECTION

	Kirki::add_section( 'influencer_marketing_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'influencer-marketing' ),
	    'panel'          => 'influencer_marketing_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_enable_post_heading',
		'section'     => 'influencer_marketing_section_post',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Post Settings.', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_blog_admin_enable',
		'label'       => esc_html__( 'Post Author Enable / Disable Button', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_post',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_blog_comment_enable',
		'label'       => esc_html__( 'Post Comment Enable / Disable Button', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_post',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'influencer_marketing_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_post',
		'default'     => 10,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'influencer_marketing_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'influencer_marketing_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'influencer-marketing' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'influencer-marketing' ),
		'section'  => 'influencer_marketing_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'influencer-marketing' ),
			'option2' => esc_html__( 'Post Meta', 'influencer-marketing' ),
			'option3' => esc_html__( 'Post Title', 'influencer-marketing' ),
			'option4' => esc_html__( 'Post Content', 'influencer-marketing' ),
			'option5' => esc_html__( 'Post Button', 'influencer-marketing' ),
		],
	]
	);

		new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','influencer-marketing'),
            'Right Sidebar' => __('Right Sidebar','influencer-marketing'),
            'Three Column' => __('Three Column','influencer-marketing'),
            'Four Column' => __('Four Column','influencer-marketing'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','influencer-marketing'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','influencer-marketing'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','influencer-marketing')
		],
	] );
	new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','influencer-marketing'),
            'Right Sidebar' => __('Right Sidebar','influencer-marketing')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','influencer-marketing'),
            'Right Sidebar' => __('Right Sidebar','influencer-marketing'),
            'Three Column' => __('Three Column','influencer-marketing'),
            'Four Column' => __('Four Column','influencer-marketing'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','influencer-marketing'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','influencer-marketing'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','influencer-marketing')
		],
	] );

		// Breadcrumb
	Kirki::add_section( 'influencer_marketing_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'influencer-marketing' ),
	    'panel'          => 'influencer_marketing_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_enable_breadcrumb_heading',
		'section'     => 'influencer_marketing_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'influencer_marketing_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'influencer-marketing' ),
        'section'  => 'influencer_marketing_bradcrumb',
    ] );



	// HEADER SECTION

	Kirki::add_section( 'influencer_marketing_section_header', array(
	    'title'          => esc_html__( 'Header Settings', 'influencer-marketing' ),
	    'panel'          => 'influencer_marketing_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_section_header',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_phone_number_heading',
		'section'     => 'influencer_marketing_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Phone Number', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_header_phone_number',
		'section'  => 'influencer_marketing_section_header',
		'default'  => '',
		'priority' => 10,
		'sanitize_callback' => 'influencer_marketing_sanitize_phone_number',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_email_address_heading',
		'section'     => 'influencer_marketing_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Email Address', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_header_email_address',
		'section'  => 'influencer_marketing_section_header',
		'default'  => '',
		'priority' => 10,
		'sanitize_callback' => 'sanitize_email',
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'        => 'link',
        'settings'    => 'influencer_marketing_header_login_link',
        'label'       => esc_html__( 'Login Button Link', 'influencer-marketing' ),
        'section'     => 'influencer_marketing_section_header',
        'default'     => '',
    ] );

	Kirki::add_field( 'theme_config_id', [
        'type'        => 'link',
        'settings'    => 'influencer_marketing_header_signin_link',
        'label'       => esc_html__( 'Sign In Button Link', 'influencer-marketing' ),
        'section'     => 'influencer_marketing_section_header',
        'default'     => '',
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_enable_socail_link',
		'section'     => 'influencer_marketing_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'influencer_marketing_section_header',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Social Icon', 'influencer-marketing' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'influencer-marketing' ),
		'settings'     => 'influencer_marketing_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'influencer-marketing' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'influencer-marketing' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'influencer-marketing' ),
				'description' => esc_html__( 'Add the social icon url here.', 'influencer-marketing' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );

	// SLIDER SECTION

	Kirki::add_section( 'influencer_marketing_slider_section', array(
	    'title'          => esc_html__( 'Slider Settings', 'influencer-marketing' ),
	    'panel'          => 'influencer_marketing_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_slider_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_enable_heading1',
		'section'     => 'influencer_marketing_slider_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider',  'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_slider_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable',  'influencer-marketing' ),
		'section'     => 'influencer_marketing_slider_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'influencer-marketing' ),
			'off' => esc_html__( 'Disable',  'influencer-marketing' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_enable_search',
		'section'     => 'influencer_marketing_slider_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Search Box', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_search_box_enable',
		'section'     => 'influencer_marketing_slider_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_slider_heading',
		'section'     => 'influencer_marketing_slider_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Slider Section ',  'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'number',
        'settings'    => 'influencer_marketing_slider_counter',
        'label'       => esc_html__( 'Slider Counter Section',  'influencer-marketing' ),
        'section'     => 'influencer_marketing_slider_section',
        'default'     => '0',
        'choices'     => [
            'min'  => 1,
            'max'  => 5,
            'step' => 1,
        ],
    ] );

    $influencer_marketing_slider_image = get_theme_mod('influencer_marketing_slider_counter','');
        for ( $influencer_marketing_i = 1; $influencer_marketing_i <= $influencer_marketing_slider_image; $influencer_marketing_i++ ) :

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'image',
        'settings'    => 'influencer_marketing_slider_outer_image'.$influencer_marketing_i,
        'label'       => esc_html__( 'Slider Outer Image ', 'influencer-marketing' ).$influencer_marketing_i,
        'description' => esc_html__( 'Image Dimension (1400 x 650)', 'influencer-marketing' ),
        'section'     => 'influencer_marketing_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'image',
        'settings'    => 'influencer_marketing_slider_image'.$influencer_marketing_i,
        'label'       => esc_html__( 'Slider Image ', 'influencer-marketing' ).$influencer_marketing_i,
        'description' => esc_html__( 'Image Dimension (500 x 500)', 'influencer-marketing' ),
        'section'     => 'influencer_marketing_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'influencer_marketing_slider_sub_heading' .$influencer_marketing_i,
        'label'       => esc_html__( 'Sub Heading ', 'influencer-marketing' ).$influencer_marketing_i,
        'section'     => 'influencer_marketing_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'influencer_marketing_slider_main_heading' .$influencer_marketing_i,
        'label'       => esc_html__( 'Main Heading ', 'influencer-marketing' ).$influencer_marketing_i,
        'section'     => 'influencer_marketing_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'number',
        'settings'    => 'influencer_marketing_slider_populer_search',
        'label'       => esc_html__( 'Populer Search Counter',  'influencer-marketing' ),
        'section'     => 'influencer_marketing_slider_section',
        'default'     => '0',
        'choices'     => [
            'min'  => 1,
            'max'  => 5,
            'step' => 1,
        ],
    ] );

	$influencer_marketing_slider_populer_search_count = get_theme_mod('influencer_marketing_slider_populer_search','');
        for ( $influencer_marketing_m = 1; $influencer_marketing_m <= $influencer_marketing_slider_populer_search_count; $influencer_marketing_m++ ) :

            Kirki::add_field( 'theme_config_id', [
		        'type'        => 'text',
		        'settings'    => 'influencer_marketing_slider_populer_search_text' .$influencer_marketing_m,
		        'label'       => esc_html__( 'Populer Search ', 'influencer-marketing' ).$influencer_marketing_m,
		        'section'     => 'influencer_marketing_slider_section',
		        'default'     => '',
		    ] );

    	endfor;

	endfor;

	new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_slider_content_alignment',
		'label'       => esc_html__( 'Slider Content Alignment', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_slider_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'influencer-marketing' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'influencer-marketing' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'influencer-marketing' ),

		],
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_slider_opacity_color',
		'label'       => esc_html__( 'Slider Opacity Option', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_slider_section',
		'default'     => '0.1',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'0' => esc_html__( '0', 'influencer-marketing' ),
			'0.1' => esc_html__( '0.1', 'influencer-marketing' ),
			'0.2' => esc_html__( '0.2', 'influencer-marketing' ),
			'0.3' => esc_html__( '0.3', 'influencer-marketing' ),
			'0.4' => esc_html__( '0.4', 'influencer-marketing' ),
			'0.5' => esc_html__( '0.5', 'influencer-marketing' ),
			'0.6' => esc_html__( '0.6', 'influencer-marketing' ),
			'0.7' => esc_html__( '0.7', 'influencer-marketing' ),
			'0.8' => esc_html__( '0.8', 'influencer-marketing' ),
			'0.9' => esc_html__( '0.9', 'influencer-marketing' ),
			'unset' => esc_html__( 'unset', 'influencer-marketing' ),
			

		],
	] );

	// BRAND SECTION

	Kirki::add_section( 'influencer_marketing_brand_section', array(
        'title'          => esc_html__( 'Brand Settings', 'influencer-marketing' ),
        'panel'          => 'influencer_marketing_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_brand_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_brand_section_enable_heading',
		'section'     => 'influencer_marketing_brand_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Brand Section', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_brand_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_brand_section',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

    new \Kirki\Field\Number(
		[
			'settings' => 'influencer_marketing_brand_count',
			'label'    => esc_html__( 'Brand Control', 'influencer-marketing' ),
			'section'  => 'influencer_marketing_brand_section',
			'default'  => '',
			'choices'  => [
				'min'  => 0,
				'max'  => 6,
				'step' => 1,
			],
		]
	);

	$influencer_marketing_brand_count = get_theme_mod('influencer_marketing_brand_count');

	for ($i=1; $i <= $influencer_marketing_brand_count; $i++) {

		Kirki::add_field( 'theme_config_id', [
	        'type'        => 'image',
	        'settings'    => 'influencer_marketing_brand_image'.$i,
	        'label'       => esc_html__( 'Brand Logo ', 'influencer-marketing' ).$i,
	        'description' => esc_html__( 'Image Dimension (200 x 100)', 'influencer-marketing' ),
	        'section'     => 'influencer_marketing_brand_section',
	        'default'     => '',
	    ] );
		
	}
	
	// ABOUT US SECTION

	Kirki::add_section( 'influencer_marketing_about_us_section', array(
        'title'          => esc_html__( 'About Us Settings', 'influencer-marketing' ),
        'panel'          => 'influencer_marketing_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_about_us_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_about_us_section_enable_heading',
		'section'     => 'influencer_marketing_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable About Us Section', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_about_us_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_about_us_section',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

	new \Kirki\Field\Image(
		[
			'settings'    => 'influencer_marketing_about_us_image',
			'label'       => esc_html__( 'Image', 'influencer-marketing' ),
			'description' => esc_html__( 'About Image.', 'influencer-marketing' ),
			'section'     => 'influencer_marketing_about_us_section',
			'default'     => '',
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_about_us_section_title_heading',
		'section'     => 'influencer_marketing_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Section Title', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_about_us_section_title',
		'section'  => 'influencer_marketing_about_us_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_about_us_section_title_headingss',
		'section'     => 'influencer_marketing_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Section Main Title', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_about_us_main_section_title',
		'section'  => 'influencer_marketing_about_us_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_about_us_section_title_headingsss',
		'section'     => 'influencer_marketing_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Section Content', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_about_us_section_content',
		'section'  => 'influencer_marketing_about_us_section',
		'default'  => '',
		'priority' => 10,
	] );

	new \Kirki\Field\Number(
		[
			'settings' => 'influencer_marketing_about_us_progress_count',
			'label'    => esc_html__( 'List Control', 'influencer-marketing' ),
			'section'  => 'influencer_marketing_about_us_section',
			'default'  => '',
			'choices'  => [
				'min'  => 0,
				'max'  => 3,
				'step' => 1,
			],
		]
	);

	$influencer_marketing_progress_count = get_theme_mod('influencer_marketing_about_us_progress_count');

	for ($i=1; $i <= $influencer_marketing_progress_count; $i++) {

		new \Kirki\Field\Text(
			[
				'settings' => 'influencer_marketing_about_us_list_iocn'.$i,
				'label'    => esc_html__( 'List Icon', 'influencer-marketing' ).$i,
				'section'  => 'influencer_marketing_about_us_section',
			]
		);
		
		new \Kirki\Field\Text(
			[
				'settings' => 'influencer_marketing_about_us_list'.$i,
				'label'    => esc_html__( 'List ', 'influencer-marketing' ).$i,
				'section'  => 'influencer_marketing_about_us_section',
			]
		);

	}

	// FOOTER SECTION

	Kirki::add_section( 'influencer_marketing_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'influencer-marketing' ),
        'panel'          => 'influencer_marketing_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'influencer-marketing' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( INFLUENCER_MARKETING_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'influencer-marketing' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'influencer_marketing_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'influencer-marketing' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_footer_enable_heading',
		'section'     => 'influencer_marketing_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'influencer_marketing_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'influencer-marketing' ),
			'off' => esc_html__( 'Disable', 'influencer-marketing' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_footer_text_heading',
		'section'     => 'influencer_marketing_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'influencer_marketing_footer_text',
		'section'  => 'influencer_marketing_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_footer_text_heading_2',
		'section'     => 'influencer_marketing_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'influencer-marketing' ) . '</h3>',
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'influencer_marketing_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'influencer-marketing' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'influencer-marketing' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'influencer-marketing' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'influencer-marketing' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'influencer_marketing_footer_text_heading_1',
	'section'     => 'influencer_marketing_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'influencer-marketing' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'influencer_marketing_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'influencer-marketing' ),
		'section'     => 'influencer_marketing_footer_section',
		'default'     => '#000000',
	] );

		Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'influencer_marketing_enable_footer_socail_link',
		'section'     => 'influencer_marketing_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'influencer-marketing' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'influencer_marketing_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'influencer-marketing' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'influencer-marketing' ),
		'settings'     => 'influencer_marketing_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'influencer-marketing' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'influencer-marketing' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'influencer-marketing' ),
				'description' => esc_html__( 'Add the social icon url here.', 'influencer-marketing' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}