<?php
/**
 * The template part for displaying grid post
 *
 * @package Industrial Lite
 * @subpackage industrial-lite
 * @since industrial-lite 1.0
 */
?>
<?php 
  $industrial_lite_archive_year  = get_the_time('Y'); 
  $industrial_lite_archive_month = get_the_time('m'); 
  $industrial_lite_archive_day   = get_the_time('d'); 
?>
<div class="col-lg-4 col-md-6">
	<article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
	    <div class="grid-post-main-box wow bounceInDown delay-1000" data-wow-duration="2s">
	      	<div class="box-image">
	          	<?php 
		            if(has_post_thumbnail() && get_theme_mod( 'industrial_lite_grid_image_hide_show',true) == 1) { 
		              the_post_thumbnail(); 
		            }
	          	?>
	        </div>
	        <h2 class="section-title"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
	        <?php if( get_theme_mod( 'industrial_lite_grid_postdate',true) == 1 || get_theme_mod( 'industrial_lite_grid_author',true) == 1 || get_theme_mod( 'industrial_lite_grid_comments',true) == 1) { ?>
	            <div class="post-info">
	                <?php if(get_theme_mod('industrial_lite_grid_postdate',true)==1){ ?>
	                    <i class="<?php echo esc_attr(get_theme_mod('industrial_lite_grid_postdate_icon','fas fa-calendar-alt')); ?>"></i><span class="entry-date"><a href="<?php echo esc_url( get_day_link( $industrial_lite_archive_year, $industrial_lite_archive_month, $industrial_lite_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span><?php echo esc_html(get_theme_mod('industrial_lite_grid_post_meta_field_separator', '|'));?></span> 
	                <?php } ?>

	                <?php if(get_theme_mod('industrial_lite_grid_author',true)==1){ ?>
	                    <i class="<?php echo esc_attr(get_theme_mod('industrial_lite_grid_author_icon','far fa-user')); ?>"></i><span class="entry-author"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span><span><?php echo esc_html(get_theme_mod('industrial_lite_grid_post_meta_field_separator', '|'));?></span> 
	                <?php } ?>

	                <?php if(get_theme_mod('industrial_lite_grid_comments',true)==1){ ?>
	                    <i class="<?php echo esc_attr(get_theme_mod('industrial_lite_grid_comments_icon','fa fa-comments')); ?>" aria-hidden="true"></i><span class="entry-comments"><?php comments_number( __('0 Comment', 'industrial-lite'), __('0 Comments', 'industrial-lite'), __('% Comments', 'industrial-lite') ); ?> </span>
	                <?php } ?>
	                <?php echo esc_html (industrial_lite_edit_link()); ?>
	            </div>
       	 	<?php } ?>
	        <div class="new-text">
	        	<div class="entry-content">
	        		<p>
			          <?php $industrial_lite_excerpt = get_the_excerpt(); echo esc_html( industrial_lite_string_limit_words( $industrial_lite_excerpt, esc_attr(get_theme_mod('industrial_lite_related_posts_excerpt_number','30')))); ?> <?php echo esc_html( get_theme_mod('industrial_lite_grid_excerpt_suffix','') ); ?>
			        </p>
	        	</div>
	        </div>
	        <?php if( get_theme_mod('industrial_lite_grid_button_text','Read More') != ''){ ?>
		        <div class="more-btn">
		          <a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_theme_mod('industrial_lite_grid_button_text',__('Read More','industrial-lite')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('industrial_lite_grid_button_text',__('Read More','industrial-lite')));?></span></a>
		        </div>
	        <?php } ?>
	    </div>
	    <div class="clearfix"></div>
  	</article>
</div>