<?php
/**
 * Template part for displaying front page introduction.
 *
 * @package Indepth News
 */

// Banner Section.
$banner_section = get_theme_mod( 'indepth_news_banner_section_enable', false );

if ( false === $banner_section ) {
	return;
}

$featured_posts_content_ids  = $main_news_content_ids = $editor_pick_content_ids = array();
$featured_posts_content_type = get_theme_mod( 'indepth_news_banner_featured_posts_content_type', 'post' );
$main_news_content_type      = get_theme_mod( 'indepth_news_banner_main_news_content_type', 'post' );
$editor_pick_content_type    = get_theme_mod( 'indepth_news_banner_editor_pick_content_type', 'post' );

if ( $featured_posts_content_type === 'post' ) {

	for ( $i = 1; $i <= 4; $i++ ) {
		$featured_posts_content_ids[] = get_theme_mod( 'indepth_news_banner_featured_posts_post_' . $i );
	}

	$featured_posts_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 4 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $featured_posts_content_ids ) ) ) {
		$featured_posts_args['post__in'] = array_filter( $featured_posts_content_ids );
		$featured_posts_args['orderby']  = 'post__in';
	} else {
		$featured_posts_args['orderby'] = 'date';
	}
} else {
	$cat_content_id      = get_theme_mod( 'indepth_news_banner_featured_posts_category' );
	$featured_posts_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 4 ),
	);
}

if ( $main_news_content_type === 'post' ) {

	for ( $i = 1; $i <= 5; $i++ ) {
		$main_news_content_ids[] = get_theme_mod( 'indepth_news_banner_main_news_post_' . $i );
	}

	$main_news_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 5 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $main_news_content_ids ) ) ) {
		$main_news_args['post__in'] = array_filter( $main_news_content_ids );
		$main_news_args['orderby']  = 'post__in';
	} else {
		$main_news_args['orderby'] = 'date';
	}
} else {
	$cat_content_id = get_theme_mod( 'indepth_news_banner_main_news_category' );
	$main_news_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 5 ),
	);
}

if ( $editor_pick_content_type === 'post' ) {

	for ( $i = 1; $i <= 4; $i++ ) {
		$editor_pick_content_ids[] = get_theme_mod( 'indepth_news_banner_editor_pick_post_' . $i );
	}

	$editor_pick_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 4 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $editor_pick_content_ids ) ) ) {
		$editor_pick_args['post__in'] = array_filter( $editor_pick_content_ids );
		$editor_pick_args['orderby']  = 'post__in';
	} else {
		$editor_pick_args['orderby'] = 'date';
	}
} else {
	$cat_content_id   = get_theme_mod( 'indepth_news_banner_editor_pick_category' );
	$editor_pick_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 4 ),
	);
}

?>

<div id="indepth_news_banner_section" class="main-banner-section style-1 adore-navigation">
	<div class="theme-wrapper">
		<div class="main-banner-section-wrapper">
			<?php
			require get_template_directory() . '/inc/frontpage-sections/banner-sections/banner-featured-posts.php';
			require get_template_directory() . '/inc/frontpage-sections/banner-sections/banner-main-news.php';
			require get_template_directory() . '/inc/frontpage-sections/banner-sections/editor-pick.php';
			?>
		</div>
	</div>
</div>
