<!-- Banner Main News -->
<div class="main-news-outer">
	<div class="main-news-wrap">
		<?php
		$main_news_query = new WP_Query( $main_news_args );
		if ( $main_news_query->have_posts() ) {
			$i = 1;
			while ( $main_news_query->have_posts() ) :
				$main_news_query->the_post();
				?>
				<div class="post-item <?php echo esc_attr( $i === 1 ? 'overlay-post' : 'post-list' ); ?>">
					<div class="post-item-image">
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail(); ?>							
						</a>
					</div>
					<div class="post-item-content">
						<div class="entry-cat <?php echo esc_attr( $i === 1 ? '' : 'no-bg' ); ?>">
							<?php the_category( '', '', get_the_ID() ); ?>						
						</div>
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3>  
						<ul class="entry-meta">
							<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
							<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
							<li class="post-comment"> <span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
						</ul>
					</div>
				</div>
				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>
<!-- End Banner Main News -->
