<!-- Banner Featured Posts -->
<div class="featured-posts-outer">
	<div class="featured-posts">
		<?php
		$featured_posts_query = new WP_Query( $featured_posts_args );
		if ( $featured_posts_query->have_posts() ) {
			$i = 1;
			while ( $featured_posts_query->have_posts() ) :
				$featured_posts_query->the_post();
				?>
				<div class="post-item <?php echo esc_attr( $i === 1 ? 'post-grid' : 'post-list' ); ?>">
					<div class="post-item-image">
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail(); ?>							
						</a>
					</div>
					<div class="post-item-content">
						<div class="entry-cat no-bg">
							<?php the_category( '', '', get_the_ID() ); ?>						
						</div>
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3>  
						<ul class="entry-meta">
							<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
							<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
							<li class="post-comment"> <span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
						</ul>
					</div>
				</div>
				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>
<!-- End Banner Featured Posts -->
