<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'indepth_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'indepth-news' ),
		'panel' => 'indepth_news_theme_options_panel',
	)
);

// Enable single post category setting.
$wp_customize->add_setting(
	'indepth_news_enable_single_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_enable_single_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'indepth-news' ),
			'settings' => 'indepth_news_enable_single_category',
			'section'  => 'indepth_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post author setting.
$wp_customize->add_setting(
	'indepth_news_enable_single_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_enable_single_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'indepth-news' ),
			'settings' => 'indepth_news_enable_single_author',
			'section'  => 'indepth_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post date setting.
$wp_customize->add_setting(
	'indepth_news_enable_single_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_enable_single_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'indepth-news' ),
			'settings' => 'indepth_news_enable_single_date',
			'section'  => 'indepth_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post tag setting.
$wp_customize->add_setting(
	'indepth_news_enable_single_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_enable_single_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'indepth-news' ),
			'settings' => 'indepth_news_enable_single_tag',
			'section'  => 'indepth_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'indepth_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'indepth-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'indepth_news_related_posts_title',
	array(
		'label'           => esc_html__( 'Related Posts Title', 'indepth-news' ),
		'section'         => 'indepth_news_single_page_options',
		'settings'        => 'indepth_news_related_posts_title',
	)
);
