<?php
/**
 * Sidebar settings.
 */

$wp_customize->add_section(
	'indepth_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'indepth-news' ),
		'panel' => 'indepth_news_theme_options_panel',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'indepth_news_sidebar_position',
	array(
		'sanitize_callback' => 'indepth_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'indepth_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'indepth-news' ),
		'section' => 'indepth_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'indepth-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'indepth-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'indepth_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'indepth_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'indepth_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'indepth-news' ),
		'section' => 'indepth_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'indepth-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'indepth-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'indepth_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'indepth_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'indepth_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'indepth-news' ),
		'section' => 'indepth_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'indepth-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'indepth-news' ),
		),
	)
);
