<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'indepth_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'indepth-news' ),
		'panel' => 'indepth_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'indepth_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'indepth-news' ),
			'settings' => 'indepth_news_pagination_enable',
			'section'  => 'indepth_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'indepth_news_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'indepth-news' ),
		'section'         => 'indepth_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'indepth-news' ),
			'numeric' => __( 'Numeric', 'indepth-news' ),
		),
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'indepth_news_pagination_enable' )->value() );
		},
	)
);
