<?php
/**
 * Breadcrumb settings
 */

$wp_customize->add_section(
	'indepth_news_breadcrumb_section',
	array(
		'title' => esc_html__( 'Breadcrumb Options', 'indepth-news' ),
		'panel' => 'indepth_news_theme_options_panel',
	)
);

// Breadcrumb enable setting.
$wp_customize->add_setting(
	'indepth_news_breadcrumb_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_breadcrumb_enable',
		array(
			'label'    => esc_html__( 'Enable breadcrumb.', 'indepth-news' ),
			'type'     => 'checkbox',
			'settings' => 'indepth_news_breadcrumb_enable',
			'section'  => 'indepth_news_breadcrumb_section',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'indepth_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'indepth_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'indepth-news' ),
		'section'         => 'indepth_news_breadcrumb_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'indepth_news_breadcrumb_enable' )->value() );
		},
	)
);
