<?php
/**
 * Blog / Archive Options
 */

$wp_customize->add_section(
	'indepth_news_archive_page_options',
	array(
		'title' => esc_html__( 'Blog / Archive Pages Options', 'indepth-news' ),
		'panel' => 'indepth_news_theme_options_panel',
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'indepth_news_excerpt_length',
	array(
		'default'           => 25,
		'sanitize_callback' => 'indepth_news_sanitize_number_range',
	)
);

$wp_customize->add_control(
	'indepth_news_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'indepth-news' ),
		'section'     => 'indepth_news_archive_page_options',
		'settings'    => 'indepth_news_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 5,
			'max'  => 200,
			'step' => 1,
		),
	)
);

// Grid Column layout options.
$wp_customize->add_setting(
	'indepth_news_archive_grid_column_layout',
	array(
		'default'           => 'grid-column-2',
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_archive_grid_column_layout',
	array(
		'label'           => esc_html__( 'Grid Column Layout', 'indepth-news' ),
		'section'         => 'indepth_news_archive_page_options',
		'type'            => 'select',
		'choices'         => array(
			'grid-column-2' => __( 'Column 2', 'indepth-news' ),
			'grid-column-3' => __( 'Column 3', 'indepth-news' ),
		),
	)
);

// Enable archive page category setting.
$wp_customize->add_setting(
	'indepth_news_enable_archive_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_enable_archive_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'indepth-news' ),
			'settings' => 'indepth_news_enable_archive_category',
			'section'  => 'indepth_news_archive_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable archive page author setting.
$wp_customize->add_setting(
	'indepth_news_enable_archive_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_enable_archive_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'indepth-news' ),
			'settings' => 'indepth_news_enable_archive_author',
			'section'  => 'indepth_news_archive_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable archive page date setting.
$wp_customize->add_setting(
	'indepth_news_enable_archive_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_enable_archive_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'indepth-news' ),
			'settings' => 'indepth_news_enable_archive_date',
			'section'  => 'indepth_news_archive_page_options',
			'type'     => 'checkbox',
		)
	)
);
