<?php
/**
 * Adore Themes Customizer
 *
 * @package Indepth News
 *
 * Banner Section
 */

$wp_customize->add_section(
	'indepth_news_banner_section',
	array(
		'title' => esc_html__( 'Banner Section', 'indepth-news' ),
		'panel' => 'indepth_news_frontpage_panel',
	)
);

// Banner enable setting.
$wp_customize->add_setting(
	'indepth_news_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'indepth_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Indepth_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'indepth_news_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'indepth-news' ),
			'type'     => 'checkbox',
			'settings' => 'indepth_news_banner_section_enable',
			'section'  => 'indepth_news_banner_section',
			'priority' => 10
		)
	)
);

// Featured Posts Sub Heading.
$wp_customize->add_setting(
	'indepth_news_banner_featured_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Indepth_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'indepth_news_banner_featured_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Featured Posts Section', 'indepth-news' ),
			'settings'        => 'indepth_news_banner_featured_posts_sub_heading',
			'section'         => 'indepth_news_banner_section',
			'active_callback' => 'indepth_news_if_banner_enabled',
			'priority'        => 20
		)
	)
);

// banner featured posts content type settings.
$wp_customize->add_setting(
	'indepth_news_banner_featured_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_banner_featured_posts_content_type',
	array(
		'label'           => esc_html__( 'Featured Posts Content type:', 'indepth-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'indepth-news' ),
		'section'         => 'indepth_news_banner_section',
		'settings'        => 'indepth_news_banner_featured_posts_content_type',
		'type'            => 'select',
		'active_callback' => 'indepth_news_if_banner_enabled',
		'priority'        => 30,
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'indepth-news' ),
			'category' => esc_html__( 'Category', 'indepth-news' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// Featured Posts post setting.
	$wp_customize->add_setting(
		'indepth_news_banner_featured_posts_post_' . $i,
		array(
			'sanitize_callback' => 'indepth_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'indepth_news_banner_featured_posts_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'indepth-news' ), $i ),
			'section'         => 'indepth_news_banner_section',
			'type'            => 'select',
			'choices'         => indepth_news_get_post_choices(),
			'active_callback' => 'indepth_news_banner_featured_posts_content_type_post_enabled',
			'priority'        => 40
		)
	);

}

// Featured Posts category setting.
$wp_customize->add_setting(
	'indepth_news_banner_featured_posts_category',
	array(
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_banner_featured_posts_category',
	array(
		'label'           => esc_html__( 'Category', 'indepth-news' ),
		'section'         => 'indepth_news_banner_section',
		'type'            => 'select',
		'choices'         => indepth_news_get_post_cat_choices(),
		'active_callback' => 'indepth_news_banner_featured_posts_content_type_category_enabled',
		'priority'        => 50
	)
);

// Main News Sub Heading.
$wp_customize->add_setting(
	'indepth_news_banner_main_news_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Indepth_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'indepth_news_banner_main_news_sub_heading',
		array(
			'label'           => esc_html__( 'Main News Section', 'indepth-news' ),
			'settings'        => 'indepth_news_banner_main_news_sub_heading',
			'section'         => 'indepth_news_banner_section',
			'active_callback' => 'indepth_news_if_banner_enabled',
			'priority'        => 60
		)
	)
);

// banner main news content type settings.
$wp_customize->add_setting(
	'indepth_news_banner_main_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_banner_main_news_content_type',
	array(
		'label'           => esc_html__( 'Main News Content type:', 'indepth-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'indepth-news' ),
		'section'         => 'indepth_news_banner_section',
		'settings'        => 'indepth_news_banner_main_news_content_type',
		'type'            => 'select',
		'active_callback' => 'indepth_news_if_banner_enabled',
		'priority'        => 70,
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'indepth-news' ),
			'category' => esc_html__( 'Category', 'indepth-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Main News post setting.
	$wp_customize->add_setting(
		'indepth_news_banner_main_news_post_' . $i,
		array(
			'sanitize_callback' => 'indepth_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'indepth_news_banner_main_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'indepth-news' ), $i ),
			'section'         => 'indepth_news_banner_section',
			'type'            => 'select',
			'choices'         => indepth_news_get_post_choices(),
			'active_callback' => 'indepth_news_banner_main_news_content_type_post_enabled',
			'priority'        => 80
		)
	);

}

// Main News category setting.
$wp_customize->add_setting(
	'indepth_news_banner_main_news_category',
	array(
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_banner_main_news_category',
	array(
		'label'           => esc_html__( 'Category', 'indepth-news' ),
		'section'         => 'indepth_news_banner_section',
		'type'            => 'select',
		'choices'         => indepth_news_get_post_cat_choices(),
		'active_callback' => 'indepth_news_banner_main_news_content_type_category_enabled',
		'priority'        => 90
	)
);

// Editor Pick Sub Heading.
$wp_customize->add_setting(
	'indepth_news_banner_editor_pick_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Indepth_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'indepth_news_banner_editor_pick_sub_heading',
		array(
			'label'           => esc_html__( 'Editor Pick Section', 'indepth-news' ),
			'settings'        => 'indepth_news_banner_editor_pick_sub_heading',
			'section'         => 'indepth_news_banner_section',
			'active_callback' => 'indepth_news_if_banner_enabled',
			'priority'        => 100
		)
	)
);

// banner main news content type settings.
$wp_customize->add_setting(
	'indepth_news_banner_editor_pick_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_banner_editor_pick_content_type',
	array(
		'label'           => esc_html__( 'Editor Pick Content type:', 'indepth-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'indepth-news' ),
		'section'         => 'indepth_news_banner_section',
		'settings'        => 'indepth_news_banner_editor_pick_content_type',
		'type'            => 'select',
		'active_callback' => 'indepth_news_if_banner_enabled',
		'priority'        => 110,
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'indepth-news' ),
			'category' => esc_html__( 'Category', 'indepth-news' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// Editor Pick post setting.
	$wp_customize->add_setting(
		'indepth_news_banner_editor_pick_post_' . $i,
		array(
			'sanitize_callback' => 'indepth_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'indepth_news_banner_editor_pick_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'indepth-news' ), $i ),
			'section'         => 'indepth_news_banner_section',
			'type'            => 'select',
			'choices'         => indepth_news_get_post_choices(),
			'active_callback' => 'indepth_news_banner_editor_pick_content_type_post_enabled',
			'priority'        => 120
		)
	);

}

// Editor Pick category setting.
$wp_customize->add_setting(
	'indepth_news_banner_editor_pick_category',
	array(
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'indepth_news_banner_editor_pick_category',
	array(
		'label'           => esc_html__( 'Category', 'indepth-news' ),
		'section'         => 'indepth_news_banner_section',
		'type'            => 'select',
		'choices'         => indepth_news_get_post_cat_choices(),
		'active_callback' => 'indepth_news_banner_editor_pick_content_type_category_enabled',
		'priority'        => 130
	)
);

/*========================Active Callback==============================*/
function indepth_news_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'indepth_news_banner_section_enable' )->value();
}
// Banner Featured Posts
function indepth_news_banner_featured_posts_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'indepth_news_banner_featured_posts_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function indepth_news_banner_featured_posts_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'indepth_news_banner_featured_posts_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
// Banner Main News
function indepth_news_banner_main_news_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'indepth_news_banner_main_news_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function indepth_news_banner_main_news_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'indepth_news_banner_main_news_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
// Banner Editor Pick
function indepth_news_banner_editor_pick_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'indepth_news_banner_editor_pick_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function indepth_news_banner_editor_pick_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'indepth_news_banner_editor_pick_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
