<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option( 'optionsframework' );
	$optionsframework_settings['id'] = $themename;
	update_option( 'optionsframework', $optionsframework_settings );
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'options_framework_theme'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	// Test data
	$test_array = array(
		'one' => __('One', 'options_framework_theme'),
		'two' => __('Two', 'options_framework_theme'),
		'three' => __('Three', 'options_framework_theme'),
		'four' => __('Four', 'options_framework_theme'),
		'five' => __('Five', 'options_framework_theme')
	);

	// Multicheck Array
	$multicheck_array = array(
		'one' => __('French Toast', 'options_framework_theme'),
		'two' => __('Pancake', 'options_framework_theme'),
		'three' => __('Omelette', 'options_framework_theme'),
		'four' => __('Crepe', 'options_framework_theme'),
		'five' => __('Waffle', 'options_framework_theme')
	);

	// Multicheck Defaults
	$multicheck_defaults = array(
		'one' => '1',
		'five' => '1'
	);

	// Background Defaults
	$background_defaults = array(
		'color' => '',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll' );

	// Typography Defaults
	$typography_defaults = array(
		'size' => '15px',
		'face' => 'georgia',
		'style' => 'bold',
		'color' => '#bada55' );
		
	// Typography Options
	$typography_options = array(
		'sizes' => array( '6','12','14','16','20' ),
		'faces' => array( 'Helvetica Neue' => 'Helvetica Neue','Arial' => 'Arial' ),
		'styles' => array( 'normal' => 'Normal','bold' => 'Bold' ),
		'color' => false
	);

	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Pull all tags into an array
	$options_tags = array();
	$options_tags_obj = get_tags();
	foreach ( $options_tags_obj as $tag ) {
		$options_tags[$tag->term_id] = $tag->name;
	}


	// Pull all the pages into an array
	$options_pages = array();
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages[''] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
		$options_pages[$page->ID] = $page->post_title;
	}

	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/images/';

	$options = array();

	$options[] = array(
		'name' => __('Header Settings', 'options_framework_theme'),
		'type' => 'heading');

	 $options[] = array(
		'name' => __('Upload Logo', 'options_framework_theme'),
		'desc' => __('This creates a full size uploader that previews the image.', 'options_framework_theme'),
		'id' => 'logo_image',
		'type' => 'upload');

	$options[] = array(
		'name' => __('Home Settings', 'options_framework_theme'),
		'type' => 'heading');
		
		
	$options[] = array(
		'name' => __('Hero Text Title', 'options_framework_theme'),
		'desc' => __('A text input field.', 'options_framework_theme'),
		'id' => 'section_1_title',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'name' => __('Hero Text', 'options_framework_theme'),
		'desc' => __('Textarea description.', 'options_framework_theme'),
		'id' => 'section_1_text',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'name' => __('Featured Boxes', 'options_framework_theme'),
		'desc' => __('You can set Image, Title and Content for 3 boxes below.', 'options_framework_theme'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Feature Image 1', 'options_framework_theme'),
		'desc' => __('This creates a full size uploader that previews the image.', 'options_framework_theme'),
		'id' => 'feature_image_1',
		'type' => 'upload');
	
	$options[] = array(
		'name' => __('Feature Title 1', 'options_framework_theme'),
		'desc' => __('A text input field.', 'options_framework_theme'),
		'id' => 'feature_title_1',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'name' => __('Feature Content 1', 'options_framework_theme'),
		'desc' => __('Textarea description.', 'options_framework_theme'),
		'id' => 'feature_text_1',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'name' => __('Feature Image 2', 'options_framework_theme'),
		'desc' => __('This creates a full size uploader that previews the image.', 'options_framework_theme'),
		'id' => 'feature_image_2',
		'type' => 'upload');
	
	$options[] = array(
		'name' => __('Feature Title 2', 'options_framework_theme'),
		'desc' => __('A text input field.', 'options_framework_theme'),
		'id' => 'feature_title_2',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'name' => __('Feature Content 2', 'options_framework_theme'),
		'desc' => __('Textarea description.', 'options_framework_theme'),
		'id' => 'feature_text_2',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'name' => __('Feature Image 3', 'options_framework_theme'),
		'desc' => __('This creates a full size uploader that previews the image.', 'options_framework_theme'),
		'id' => 'feature_image_3',
		'type' => 'upload');
	
	$options[] = array(
		'name' => __('Feature Title 3', 'options_framework_theme'),
		'desc' => __('A text input field.', 'options_framework_theme'),
		'id' => 'feature_title_3',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'name' => __('Feature Content 3', 'options_framework_theme'),
		'desc' => __('Textarea description.', 'options_framework_theme'),
		'id' => 'feature_text_3',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => __('3 Image Boxes', 'options_framework_theme'),
		'desc' => __('Set Image, Title and Content for 3 boxes below..', 'options_framework_theme'),
		'type' => 'info');

	
	$options[] = array(
		'name' => __('Image For Link Box 1', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_image_1',
		'type' => 'upload');
	
	$options[] = array(
		'name' => __('Link Text 1', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_text_1',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Link URL 1', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_url_1',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Image For Link Box 2', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_image_2',
		'type' => 'upload');
	
	$options[] = array(
		'name' => __('Link Text 2', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_text_2',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Link URL 2', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_url_2',
		'std' => '',
		'type' => 'text');
		
	
	$options[] = array(
		'name' => __('Image For Link Box 3', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_image_3',
		'type' => 'upload');
	
	$options[] = array(
		'name' => __('Link Text 3', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_text_3',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Link URL 3', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'link_url_3',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => __('Display Post Widget', 'options_framework_theme'),
		'desc' => __('By default it displays it, uncheck to hide them', 'options_framework_theme'),
		'id' => 'display_post_widget',
		'std' => '1',
		'type' => 'checkbox');
		
	
	$options[] = array(
		'name' => __('Footer Settings', 'options_framework_theme'),
		'type' => 'heading');
	
	$options[] = array(
		'name' => __('Hide Footer Section', 'options_framework_theme'),
		'desc' => __('By default it displays it, uncheck to hide them', 'options_framework_theme'),
		'id' => 'display_footer_section',
		'std' => '1',
		'type' => 'checkbox');
		
	$options[] = array(
		'name' => __('Twitter Widget ID', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'twitter_id',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Copyright Text', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'copyright_text',
		'std' => '',
		'type' => 'text');
		
		
	$options[] = array(
		'name' => __('Pinterest Link', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'pin_link',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Twitter Link', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'tw_link',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Facebook Link', 'options_framework_theme'),
		'desc' => __('', 'options_framework_theme'),
		'id' => 'fb_link',
		'std' => '',
		'type' => 'text');
	
		
	return $options;
}