<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <main id="main">
 *
 * @package Impressio-Lite
 */
?> 
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
		<?php do_action( 'before' ); ?>
		<div class="container-fluid header-1-wrap">
			<div class="container">
				<div class="row">
					<div class="logo span4">
							
					<?php if((of_get_option('logo_image', true) != "") && (of_get_option('logo_image', true) != 1) ) { ?>
						<a href="<?php bloginfo('wpurl'); ?>"><img class="no-responsive-image" src="<?php echo of_get_option('logo_image', true); ?>" alt="<?php bloginfo('name'); ?>" /></a>
					<?php } else { ?>
						<h1 class="site-title">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1> 
					<?php } ?>
							 
						
					</div>
					<div class="top-main-menu span8">
						<?php wp_nav_menu( array( 'theme_location' => 'topmainmenu', 'menu_class' => 'nav-menu','link_before' => '<span>', 'link_after' => '</span>') ); ?>
					</div>
				</div>
			</div>
		</div>
		 
	<div class="mynavbar main-menu responsive-menu">
		<nav id="site-navigation" class="navigation main-navigation" role="navigation">
			<h3 class="menu-toggle"><?php _e( 'Menu', 'twentythirteen' ); ?></h3>
			<?php wp_nav_menu( array( 'theme_location' => 'topmainmenu', 'menu_class' => 'nav-small-menu'  ) ); ?>
		</nav><!-- #site-navigation -->
	</div><!-- #navbar -->