<?php
/**
 * Impressio-Lite functions and definitions
 *
 * @package Impressio-Lite
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

require_once('widgets/recent-posts.php');

 
if ( !function_exists( 'optionsframework_init' ) ) {
define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/theme-options/inc/' );
require_once dirname( __FILE__ ) . '/theme-options/inc/options-framework.php';
}

 			
				
 
if ( ! isset( $content_width ) )
	$content_width = 640; /* pixels */

if ( ! function_exists( 'tc_impressiolite_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function tc_impressiolite_setup() {

	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on Impressio-Lite, use a find and replace
	 * to change 'tc-impressiolite' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'tc-impressiolite', get_template_directory() . '/languages' );

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	//add_theme_support( 'post-thumbnails' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
		'topmainmenu' => __( 'Top Main Menu', 'tc-impressiolite' ) 
	) );

	/**
	 * Enable support for Post Formats
	 */
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );

	/**
	 * Setup the WordPress core custom background feature.
	 */
	//add_theme_support( 'custom-background', apply_filters( 'tc_impressiolite_custom_background_args', array(
	//	'default-color' => 'ffffff',
	//	'default-image' => '',
	//) ) );
}
endif; // tc_impressiolite_setup
add_action( 'after_setup_theme', 'tc_impressiolite_setup' );

/**
 * Register widgetized area and update sidebar with default widgets
 */
function tc_impressiolite_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'tc-impressiolite' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Left Sidebar', 'tc-impressiolite' ),
		'id'            => 'sidebar-left',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) ); 
	
	register_sidebar( array(
		'name'          => __( 'Home page Recent Posts', 'tc-impressiolite' ),
		'id'            => 'home-recent',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) ); 
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 1', 'tc-impressiolite' ),
		'id'            => 'footer-widget-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) ); 
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 2', 'tc-impressiolite' ),
		'id'            => 'footer-widget-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) ); 
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 3', 'tc-impressiolite' ),
		'id'            => 'footer-widget-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) ); 
	 
}
add_action( 'widgets_init', 'tc_impressiolite_widgets_init' );

/**
 * Enqueue scripts and styles
 */
function tc_impressiolite_scripts() { 
	wp_enqueue_style( 'impressio-fonts', '//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700,800');
	wp_enqueue_style( 'tc-impressiolite-style', get_stylesheet_uri() );
	wp_enqueue_script('jquery');
	wp_enqueue_script( 'tc-impressiolite-modernizr', get_template_directory_uri() . '/js/modernizr.js', array(), '20120206', false );
	wp_enqueue_script( 'tc-impressiolite-twitterjs', get_template_directory_uri() . '/js/twitterFetcher_v10_min.js', array(), '20120206', false );
	wp_enqueue_script( 'tc-impressiolite-navigation', get_template_directory_uri() . '/js/functions.js', array(), '20120206', true );
	wp_enqueue_script( 'tc-impressiolite-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( 'tc-impressiolite-keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202' );
	}
}
add_action( 'wp_enqueue_scripts', 'tc_impressiolite_scripts' );

/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
//require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';


function wpbootstrap_scripts_with_jquery()
{
	// Register the script like this for a theme:
	wp_register_script( 'custom-script', get_template_directory_uri() . '/bootstrap/js/bootstrap.js', array( 'jquery' ) );
	// For either a plugin or a theme, you can then enqueue the script:
	wp_enqueue_script( 'custom-script' );
	
	wp_register_style( 'custom-responsive', get_template_directory_uri() . '/custom-responsive.css',  array(), '20120208', 'all' );
	
	wp_enqueue_style( 'custom-responsive' );
}
add_action( 'wp_enqueue_scripts', 'wpbootstrap_scripts_with_jquery' );


if ( function_exists( 'add_theme_support' ) ) 
{
	add_theme_support( 'post-thumbnails' ); 
	add_image_size( 'portfolio-thumbnail', 300,217, true );
	add_image_size( 'portfolio-post-image', 611,360, true );
	add_image_size( 'portfolio-item-image', 611,9999);
	add_image_size( 'post-small-thumbnail', 82,70,true);
	 
	add_image_size( 'testimonial-photo', 112,112, true);
	add_image_size( 'featured-image', 620,999, true);
}

 


/* ACF Code */

//define( 'ACF_LITE' , false);
//include_once('advanced-custom-fields/acf.php' );

/* for testimonial custom field */

if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_testimonial-company-name',
		'title' => 'Testimonial Company Name',
		'fields' => array (
			array (
				'key' => 'field_52273797f37df',
				'label' => 'Company Name',
				'name' => 'company_name',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'tctestimonials',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'acf_after_title',
			'layout' => 'no_box',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}

 





if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_contact-form',
		'title' => 'Contact Form',
		'fields' => array (
			array (
				'key' => 'field_521caa2cddec8',
				'label' => 'Select a Contact Form',
				'name' => 'select_a_contact_form',
				'type' => 'post_object',
				'post_type' => array (
					0 => 'wpcf7_contact_form',
				),
				'taxonomy' => array (
					0 => 'all',
				),
				'allow_null' => 1,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'side',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}


function custom_excerpt($limit) {
	 
      $excerpt = explode(' ', get_the_excerpt(), $limit);
      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
      return $excerpt;
    }
	
function custom_excerpt_length( $length ) {
	return 140;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

// Replaces the excerpt "more" text by a link
function new_excerpt_more($more) {
       global $post;
	return '<p><a class="moretag" href="'. get_permalink($post->ID) . '"> Read the full article...</a></p>';
}
add_filter('excerpt_more', 'new_excerpt_more');


class WPQuestions_Walker extends Walker_Category {

    function start_el( &$output, $category, $depth = 0, $args = array(), $id = 0 ) {

        extract($args);



        $cat_name = esc_attr( $category->name );

        $cat_name = apply_filters( 'list_cats', $cat_name, $category );

	

        // ---	

	$termchildren = get_term_children( $category->term_id, $category->taxonomy );

        if(count($termchildren)>0){

			$aclass =  ' class="parent" ';

        }



        $link = '<a '.$aclass.' href="' . esc_url( get_term_link($category) ) . '" ';

	// ---

	

        if ( $use_desc_for_title == 0 || empty($category->description) )

            $link .= 'title="' . esc_attr( sprintf(__( 'View all posts filed under %s' ), $cat_name) ) . '"';

        else

            $link .= 'title="' . esc_attr( strip_tags( apply_filters( 'category_description', $category->description, $category ) ) ) . '"';

            $link .= '><span>';

            $link .= $cat_name . '</span></a>';



        if ( !empty($show_count) )

            $link .= ' (' . intval($category->count) . ')';



                if ( 'list' == $args['style'] ) {

                        $output .= "\t<li";

                        $class = 'cat-item cat-item-' . $category->term_id;



                        if ( !empty($current_category) ) {

                                $_current_category = get_term( $current_category, $category->taxonomy );

                                if ( $category->term_id == $current_category )

                                        $class .=  ' current-cat';

                                elseif ( $category->term_id == $_current_category->parent )

                                        $class .=  ' current-cat-parent';

                        }

                        $output .=  ' class="' . $class . '"';

                        $output .= ">$link\n";

                } else {

                        $output .= "\t$link<br />\n";

                }

        }

    }


function emm_paginate($args = null) {
	$defaults = array(
		'page' => null, 'pages' => null, 
		'range' => 3, 'gap' => 3, 'anchor' => 1,
		'before' => '<div class="emm-paginate">', 'after' => '</div>',
		'title' => __('Pages : '),
		'nextpage' => __('&raquo;'), 'previouspage' => __('&laquo'),
		'echo' => 1
	);

	$r = wp_parse_args($args, $defaults);
	extract($r, EXTR_SKIP);

	if (!$page && !$pages) {
		global $wp_query;

		$page = get_query_var('paged');
		$page = !empty($page) ? intval($page) : 1;

		$posts_per_page = intval(get_query_var('posts_per_page'));
		$pages = intval(ceil($wp_query->found_posts / $posts_per_page));
	}
	
	$output = "";
	if ($pages > 1) {	
		$output .= "$before<span class='emm-title'>$title</span>";
		$ellipsis = "<span class='emm-gap'>...</span>";

		if ($page > 1 && !empty($previouspage)) {
			$output .= "<a href='" . get_pagenum_link($page - 1) . "' class='emm-prev'>$previouspage</a>";
		}
		
		$min_links = $range * 2 + 1;
		$block_min = min($page - $range, $pages - $min_links);
		$block_high = max($page + $range, $min_links);
		$left_gap = (($block_min - $anchor - $gap) > 0) ? true : false;
		$right_gap = (($block_high + $anchor + $gap) < $pages) ? true : false;

		if ($left_gap && !$right_gap) {
			$output .= sprintf('%s%s%s', 
				emm_paginate_loop(1, $anchor), 
				$ellipsis, 
				emm_paginate_loop($block_min, $pages, $page)
			);
		}
		else if ($left_gap && $right_gap) {
			$output .= sprintf('%s%s%s%s%s', 
				emm_paginate_loop(1, $anchor), 
				$ellipsis, 
				emm_paginate_loop($block_min, $block_high, $page), 
				$ellipsis, 
				emm_paginate_loop(($pages - $anchor + 1), $pages)
			);
		}
		else if ($right_gap && !$left_gap) {
			$output .= sprintf('%s%s%s', 
				emm_paginate_loop(1, $block_high, $page),
				$ellipsis,
				emm_paginate_loop(($pages - $anchor + 1), $pages)
			);
		}
		else {
			$output .= emm_paginate_loop(1, $pages, $page);
		}

		if ($page < $pages && !empty($nextpage)) {
			$output .= "<a href='" . get_pagenum_link($page + 1) . "' class='emm-next'>$nextpage</a>";
		}

		$output .= $after;
	}

	if ($echo) {
		echo $output;
	}

	return $output;
}


/**
 * Helper function for pagination which builds the page links.
 *
 * @access private
 *
 * @author Eric Martin <eric@ericmmartin.com>
 * @copyright Copyright (c) 2009, Eric Martin
 * @version 1.0
 *
 * @param int $start The first link page.
 * @param int $max The last link page.
 * @return int $page Optional, default is 0. The current page.
 */
function emm_paginate_loop($start, $max, $page = 0) {
	$output = "";
	for ($i = $start; $i <= $max; $i++) {
		$output .= ($page === intval($i)) 
			? "<span class='emm-page emm-current'>$i</span>" 
			: "<a href='" . get_pagenum_link($i) . "' class='emm-page'>$i</a>";
	}
	return $output;
}


/**
* Sets posts displayed per portfolio page to 9
*/
function wpt_portfolio_custom_posts_per_page( $query ) {
	
     global $wp_the_query;
     if ( $wp_the_query === $query && !is_admin() ) {
		
          if ( is_post_type_archive( 'tcportfolio' )  ||  is_tax( 'tcportfoliocategory' ) ) {
               $posts_per_page = apply_filters( 'portfoliopress_posts_per_page', '9' );
               $query->set( 'posts_per_page', $posts_per_page );
          }
     }
}
add_action( 'pre_get_posts', 'wpt_portfolio_custom_posts_per_page' );

function staff_custom_posts_per_page( $query ) {
	
     global $wp_the_query;
     if ( $wp_the_query === $query && !is_admin() ) {
		
          if ( is_post_type_archive( 'tc_staff' )) {
               $posts_per_page = apply_filters( 'staff_posts_per_page', '8' );
               $query->set( 'posts_per_page', $posts_per_page );
          }
     }
}
add_action( 'pre_get_posts', 'staff_custom_posts_per_page' );

function testimonials_posts_per_page( $query ) {
	
     global $wp_the_query;
     if ( $wp_the_query === $query && !is_admin() ) {
		
          if ( is_post_type_archive( 'tctestimonials' )) {
               $posts_per_page = apply_filters( 'testimonials_per_page', '8' );
               $query->set( 'posts_per_page', $posts_per_page );
          }
     }
}
add_action( 'pre_get_posts', 'testimonials_posts_per_page' );

/**
* Overrides the default behavior of portfolio taxonomies to use the archive-portfolio template
* http://www.billerickson.net/reusing-wordpress-theme-files/
*/
function portfoliopress_template_chooser( $template ) { 
     if ( is_tax( 'tcportfoliocategory' ) )
          $template = get_query_template( 'archive-tcportfolio' );
     return $template;
}
add_filter( 'template_include', 'portfoliopress_template_chooser' );


/**
 * Include the TGM_Plugin_Activation class.
 */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'impressiolite_theme_register_required_plugins' );


function impressiolite_theme_register_required_plugins() {
 
	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
		 
		 
		/** This is an example of how to include a plugin from the WordPress Plugin Repository */
		  
		array(
			'name'     				=> 'Meta Slider', // The plugin name
			'slug'     				=> 'ml-slider', // The plugin slug (typically the folder name)
			'source'   				=> get_stylesheet_directory() . '/plugins/ml-slider.2.2.2.zip', // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		)
	);
 
	/** Change this to your theme text domain, used for internationalising strings */
	$theme_text_domain = 'tgmpa';
 
	/**
	 * Array of configuration settings. Uncomment and amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * uncomment the strings and domain.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	$config = array(
		/*'domain'       => $theme_text_domain,         // Text domain - likely want to be the same as your theme. */
		/*'default_path' => '',                         // Default absolute path to pre-packaged plugins */
		/*'menu'         => 'install-my-theme-plugins', // Menu slug */
		'has_notices'       => true,                         // Show admin notices or not
        'is_automatic'      => true,            // Automatically activate plugins after installation or not
		'strings'      	 => array(
			/*'page_title'             => __( 'Install Required Plugins', $theme_text_domain ), // */
			/*'menu_title'             => __( 'Install Plugins', $theme_text_domain ), // */
			/*'instructions_install'   => __( 'The %1$s plugin is required for this theme. Click on the big blue button below to install and activate %1$s.', $theme_text_domain ), // %1$s = plugin name */
			/*'instructions_activate'  => __( 'The %1$s is installed but currently inactive. Please go to the <a href="%2$s">plugin administration page</a> page to activate it.', $theme_text_domain ), // %1$s = plugin name, %2$s = plugins page URL */
			/*'button'                 => __( 'Install %s Now', $theme_text_domain ), // %1$s = plugin name */
			/*'installing'             => __( 'Installing Plugin: %s', $theme_text_domain ), // %1$s = plugin name */
			/*'oops'                   => __( 'Something went wrong with the plugin API.', $theme_text_domain ), // */
			/*'notice_can_install'     => __( 'This theme requires the %1$s plugin. <a href="%2$s"><strong>Click here to begin the installation process</strong></a>. You may be asked for FTP credentials based on your server setup.', $theme_text_domain ), // %1$s = plugin name, %2$s = TGMPA page URL */
			/*'notice_cannot_install'  => __( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', $theme_text_domain ), // %1$s = plugin name */
			/*'notice_can_activate'    => __( 'This theme requires the %1$s plugin. That plugin is currently inactive, so please go to the <a href="%2$s">plugin administration page</a> to activate it.', $theme_text_domain ), // %1$s = plugin name, %2$s = plugins page URL */
			/*'notice_cannot_activate' => __( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', $theme_text_domain ), // %1$s = plugin name */
			/*'return'                 => __( 'Return to Required Plugins Installer', $theme_text_domain ), // */
		),
	);
 
	tgmpa( $plugins, $config );
 
}
 
function the_excerpt_max_charlength($charlength) {
	$excerpt = get_the_excerpt();
	$charlength++;

	if ( mb_strlen( $excerpt ) > $charlength ) {
		$subex = mb_substr( $excerpt, 0, $charlength - 5 );
		$exwords = explode( ' ', $subex );
		$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
		if ( $excut < 0 ) {
			echo mb_substr( $subex, 0, $excut );
		} else {
			echo $subex;
		}
		//echo '[...]';
	} else {
		echo $excerpt;
	}
}

function wpb_first_and_last_menu_class($items) {
   $items[1]->classes[] = 'first';
   $items[count($items)]->classes[] = 'last';
   return $items;
}
add_filter('wp_nav_menu_objects', 'wpb_first_and_last_menu_class');


 
?>